/* File: MultimarkerMeasure.h */


#ifndef __HapCounters_cpp__
#define __HapCounters_cpp__





//using namespace stats;

namespace BIOS
{


	/**********************************/
	/* DEFINITIONS OF THE FUNCTIONS */
	/**********************************/

///////////////////
//// public ////////
///////////////////

	/*_________________________________________________________________*/

	void HapCounters::set ( HapCounters& source )
	{
		femaleHaps=NULL;
		maleHaps=NULL;
		genotypeCounters=NULL;
		hapByFreqs=NULL;
		hapByFreqsMale=NULL;
		hapByFreqsFemale=NULL;
		Bayes=source.Bayes;
		alphaBayes=source.alphaBayes;
		distance=source.distance;
		totalDifferentHaplotypes=source.totalDifferentHaplotypes;
		totalUsedDifferentHaplotypes=source.totalUsedDifferentHaplotypes;
		totalMeiosis=source.totalMeiosis;
		if ( source.genotypeCounters=NULL ) genotypeCounters=source.genotypeCounters;
		if ( source.maleHaps!=NULL ) maleHaps=new InferredHaplotypesList ( *source.maleHaps );
		if ( source.femaleHaps!=NULL ) maleHaps=new InferredHaplotypesList ( *source.femaleHaps );
		if ( source.haplotypeTable!=NULL )
		{
			haplotypeTable=new MultidimensionalEmptyTable<int> ( *source.haplotypeTable );
//setSNPFreqs();
		}
		if ( source.hapByFreqs!=NULL ) hapByFreqs=new FreqAndKeyVector ( *source.hapByFreqs );
		if ( source.hapByFreqsMale!=NULL ) hapByFreqs=new FreqAndKeyVector ( *source.hapByFreqsMale );
		if ( source.hapByFreqsFemale!=NULL ) hapByFreqs=new FreqAndKeyVector ( *source.hapByFreqsFemale );
	if ( source.haplotypeFreqsTab!=NULL ) haplotypeFreqsTab=new MultidimensionalTable<double>(*source.haplotypeFreqsTab);
	}
	/*_________________________________________________________________*/

	HapCounters::HapCounters ( HapCounters& source )
	{
		set ( source );
	}
	
		/*_________________________________________________________________*/

	HapCounters* HapCounters::clone (  )
	{
		return new HapCounters(*this);
	}
	/*_________________________________________________________________*/

	HapCounters::HapCounters ( GenotypeCounters* genotypeCounters, PhaseAlg phaseAlg, BayesType  Bay, float alphaBayes, float distance )
	{
		try
		{
			set ( genotypeCounters, phaseAlg, Bay, alphaBayes, distance );
		}
		catch ( BasicException & be ) {be.addMessage ( "\ncalled from HapCounters::HapCountersGenotypeCounters* genotypeCounters, PhaseAlg phaseAlg,..." ); throw;};
	}
	/*_________________________________________________________________*/

	void HapCounters::set ( GenotypeCounters* genotypeCounters, PhaseAlg phaseAlg, BayesType  Bay, float alphaBayes, float distance )
	{
		try
		{
			this->Bayes=Bay;
			this->alphaBayes=alphaBayes;
			this->distance=distance;
			this->phaseAlg=phaseAlg;
			this->genotypeCounters=genotypeCounters; // false for non-tdt (homo included)
			haplotypeTable=NULL;
			setHaplotypeTable();
			maleHaps=NULL;
			femaleHaps=NULL;
			hapByFreqs=NULL;
			hapByFreqsMale=NULL;
			hapByFreqsFemale=NULL;
			haplotypeFreqsTab=getHaplotypeFreqsTab();
			setTotalMeiosis();
			setHaplotypeCounts();
			if ( haplotypeTable!=NULL ) setTotalHaplotypes();
			if ( haplotypeTable!=NULL )
				setHapByFreqs();
		}
		catch ( BasicException & be ) {be.addMessage ( "\ncalled from HapCounters::set(GenotypeCounters* genotypeCounters, PhaseAlg phaseAlg,..." ); throw;};
	}

	/*_________________________________________________________________*/


	long long int HapCounters::getHap ( const long long int value, bool left )
	{
		long long int result=-2;
		if ( this->genotypeCounters->genotypeArray->getTotalSolvedConfs ( value ) ==1 )
		{
			result=this->genotypeCounters->genotypeArray->getSolvedConf ( value, 0, left, this->haplotypeTable );
		}
		return result;
	}

	/*_______________________________________________________________*/


	void HapCounters::setHaplotypeCounts()
	{
		try
		{
			this->maleHaps=new InferredHaplotypesList(); this->femaleHaps=new InferredHaplotypesList();
			int totalConfigurations;
			double maxFrequency=0, currentFrequency, total=0, freq;
			long long int ambiguousPos;
			longLongList*list=NULL;
			InferredHaplotypesList* targetList=NULL;
			InferredHaplotypes* inferredHaplotypes=NULL, *chosenInferredHaplotypes=NULL;
   int offset=0;
//cout << "geno:\n" << *genotypeCounters <<"\n";
			for ( int gen=0; gen<2; gen++ )
			{
				if ( gen==0 ) {list=genotypeCounters->genotypeCountsMale; targetList=maleHaps;}
				else {list=genotypeCounters->genotypeCountsFemale; targetList=femaleHaps; offset=genotypeCounters->genotypeCountsMale->size();}
				for ( long long int i=0; i<list->size(); i++ )
					if ( list->getElement ( i ) <0 ) targetList->insertElement ( NULL );
					else
					{
						maxFrequency=-1;
						ambiguousPos=list->getElement ( i );
//cout << "ambiguous pos:" << ambiguousPos <<"\n";
						totalConfigurations=genotypeCounters->genotypeArray->getTotalSolvedConfs ( ambiguousPos );
						if ( phaseAlg==weighted ) total=getNormalizationValue (haplotypeFreqsTab, totalConfigurations, ambiguousPos); 
//cout << "\nid is:" << i+offset;
//cout << "\ntotal confs:" << totalConfigurations;
						for ( int j=0; j<totalConfigurations; j++ )
						{
							inferredHaplotypes=getInferredHaplotypes ( ambiguousPos, j );
							inferredHaplotypes->indCount=i+offset;
							if ( phaseAlg!=onlyKnown ) currentFrequency=getCurrentFrequency ( haplotypeFreqsTab, inferredHaplotypes );
							if ( phaseAlg==maxFreq && maxFrequency<=currentFrequency )
							{
								maxFrequency=currentFrequency;
								chosenInferredHaplotypes=inferredHaplotypes;
							}
							if ( phaseAlg==weighted ) {inferredHaplotypes->freq=currentFrequency/total;targetList->insertElement ( inferredHaplotypes );}
													}// end for each conf
			
	if ( phaseAlg==maxFreq )
						{
							//freq=addBayes ( 1, Bayes, distance, alphaBayes, totalMeiosis*2 );
							chosenInferredHaplotypes->freq=1;
							inferredHaplotypes=chosenInferredHaplotypes;
//cout << "inserting haps " << *inferredHaplotypes <<"\n";
							targetList->insertElement ( inferredHaplotypes );
						}
						if ( ( phaseAlg==onlyKnown && totalConfigurations==1 ) || phaseAlg!=onlyKnown )
							if ( phaseAlg==onlyKnown ) targetList->insertElement ( inferredHaplotypes );
					} 
			}

//cout <<"final malehaps:\n" << *maleHaps <<"\n";
//cout <<"final femalehaps:\n" << *femaleHaps <<"\n";
//exit(0);
//*/
		}
		catch ( BasicException & e ) {e.addMessage ( "\n called from HapCounters::setHaplotypeCounts()" ); throw; }
	}
	/*_______________________________________________________________*/


	void HapCounters::setTotalMeiosis()
	{
		try
		{
		longLongList*list;
   totalMeiosis=0;
						for ( int gen=0; gen<2; gen++ )
			{
				if ( gen==0 ) list=genotypeCounters->genotypeCountsMale; 
				else list=genotypeCounters->genotypeCountsFemale; 
				for ( long long int i=0; i<list->size(); i++ )
					if ( list->getElement ( i ) >=0 ) 
							totalMeiosis++;
						}
		if ( totalMeiosis==0 ) this->~HapCounters();
		}
		catch ( BasicException & e ) {e.addMessage ( "\n called from HapCounters::setHaplotypeCounts()" ); throw; }
	}

	/*_______________________________________________________________*/

	HapCounters::~HapCounters()
	{
		zap ( maleHaps );
		zap ( femaleHaps );
		zap ( haplotypeTable );
		zap ( hapByFreqs );
		zap ( hapByFreqsMale );
		zap ( hapByFreqsFemale );
  if (haplotypeFreqsTab!=NULL)
			haplotypeFreqsTab->empty();
	};

	/*_______________________________________________________________*/

	double HapCounters::getNormalizationValue (MultidimensionalTable<double>* haplotypeFreqsTab, int totalConfigurations, long long int ambiguousPos)
	{
// it returns the total frequency for all the haplotype pairs compatible with an ambiguous position
		double total=0, currentFrequency;
  long long int leftHaplotype, rightHaplotype;
		for ( int j=0; j<totalConfigurations; j++ )
		{
		leftHaplotype=genotypeCounters->genotypeArray->getSolvedConf ( ambiguousPos, j, true,  this->haplotypeTable );
		rightHaplotype=genotypeCounters->genotypeArray->getSolvedConf ( ambiguousPos, j, false,  this->haplotypeTable );
			currentFrequency=getCurrentFrequency (haplotypeFreqsTab, leftHaplotype, rightHaplotype);
			total=total+currentFrequency; //totalConfigurations;
		}
		return total;
	}
	/*_______________________________________________________________*/

	double HapCounters::getCurrentFrequency ( MultidimensionalTable<double>* haplotypeFreqsTab, InferredHaplotypes *inferredHaplotypes )
	{
		return haplotypeFreqsTab->getValue ( inferredHaplotypes->leftHaplotype ) *haplotypeFreqsTab->getValue ( inferredHaplotypes->rightHaplotype );
	}
	/*_______________________________________________________________*/

	double HapCounters::getCurrentFrequency ( MultidimensionalTable<double>* haplotypeFreqsTab, long long int leftHaplotype, long long int rightHaplotype)
	{
		return haplotypeFreqsTab->getValue(leftHaplotype)*haplotypeFreqsTab->getValue (rightHaplotype);
	}
	/*_______________________________________________________________*/

	/*
	HeteroPair<HaplotypeTUCountsVector*,ParentalHaplotypesUsingPointersList*>* HapCounters::getTUCounts(bool useOnlyHetero)
	{
	ParentalHaplotypesUsingPointersList* result2=new ParentalHaplotypesUsingPointersList();
	HaplotypeTUCountsVector* result1=new HaplotypeTUCountsVector();
	HeteroPair<HaplotypeTUCountsVector*,ParentalHaplotypesUsingPointersList*>* result=new HeteroPair<HaplotypeTUCountsVector*,ParentalHaplotypesUsingPointersList*>();
	result->First=result1;
	result->Second=result2;
	HaplotypeTUCounts* h;
	ParentalHaplotypesUsingPointers* pp;
	map<long long int, int> hapPos=map<long long int, int>();
	double totalCountsUsed, totalCounts;
	intList* posList;
	int pos=0;
	for (long long int k=0; k<haplotypeTable->getSize(); k++)
	{
	totalCountsUsed=getTotalHaplotypes(k, ut, parent);
	if (totalCountsUsed>0)
	{
	posList=haplotypeTable->getPosList(k);
	h=new HaplotypeTUCounts(posList->size());
	for (int i=0; i<posList->size(); i++)
	(*h)[i]=(base)genotypeCounters->genotypeArray->getAllele(i, posList->getElement(i));
	h->frequencyT=getTotalHaplotypes(k, t, parent, onlyHetero);
	h->frequencyU=getTotalHaplotypes(k, u, parent, onlyHetero);
	if (useOnlyHetero) h->frequencyHomo=getTotalHaplotypes(k, ut, parent, onlyHomo);
	else
	{
	h->frequencyHomo=0;
	h->frequencyT+=getTotalHaplotypes(k, ut, parent, onlyHomo)/2;
	h->frequencyU+=getTotalHaplotypes(k, ut, parent, onlyHomo)/2;
	}
	zap(posList);
	hapPos[k]=pos;
	result1->insertElement(h);
	pos++;
	}
	}
	Haplotype*fatherT, *motherT, *fatherU, *motherU;
	ParentalHaplotypes* ph;
	for (ParentalHaplotypesList::iterator it=haplotypeCounts->begin(); it!=haplotypeCounts->end(); it++)
	{
	ph=*it;
	fatherT=result1->getElement(hapPos[ph->fatherT])->getHaplotype();
	fatherU=result1->getElement(hapPos[ph->fatherU])->getHaplotype();
	motherT=result1->getElement(hapPos[ph->motherT])->getHaplotype();
	motherU=result1->getElement(hapPos[ph->motherU])->getHaplotype();
	pp=new ParentalHaplotypesUsingPointers(fatherT, fatherU, motherT, motherU, ph->genotypeCount, ph->freq, ph->outputSeparator, ph->delimiters, ph->printTransmitted,  ph->printUntransmitted);
	result2->insertElement(pp);
	}
	return result;
	}

	/*_______________________________________________________________*/

	InferredHaplotypes* HapCounters::getInferredHaplotypes ( long long int ambiguousConf, int binaryKnownConfiguration )
	{
// it returns the haplotypes for a genotype, it could be an unphased pair of haplotypes
		double freq;
		InferredHaplotypes *inferredHaplotypes=new InferredHaplotypes();
		inferredHaplotypes->leftHaplotype=genotypeCounters->genotypeArray->getSolvedConf ( ambiguousConf, binaryKnownConfiguration, true,  this->haplotypeTable );
		inferredHaplotypes->rightHaplotype=genotypeCounters->genotypeArray->getSolvedConf ( ambiguousConf, binaryKnownConfiguration, false,  this->haplotypeTable );
		//freq=addBayes ( 1, Bayes, distance, alphaBayes, totalMeiosis*2 );
		inferredHaplotypes->freq=1;
		return inferredHaplotypes;
	}


	/*_______________________________________________________________*/
	/*
	ParentalHaplotypes* HapCounters::getParentalHaplotypes(long long int ambiguousConfFather, long long int ambiguousConfMother, int binaryKnownConfiguration)
	{
	ParentalHaplotypes *parentalHaplotype=new ParentalHaplotypes();
	parentalHaplotype->fatherT=genotypeCounters->genotypeArray->getSolvedConf(ambiguousConfFather, binaryKnownConfiguration, true,  this->haplotypeTable);
	parentalHaplotype->fatherU=genotypeCounters->genotypeArray->getSolvedConf(ambiguousConfFather, binaryKnownConfiguration, false,  this->haplotypeTable);
	parentalHaplotype->motherT=genotypeCounters->genotypeArray->getPartnerSolvedConf(binaryKnownConfiguration, ambiguousConfFather, ambiguousConfMother, true, this->haplotypeTable);
	parentalHaplotype->motherU=genotypeCounters->genotypeArray->getPartnerSolvedConf(binaryKnownConfiguration, ambiguousConfFather, ambiguousConfMother, false, this->haplotypeTable);
	parentalHaplotype->freq=1;
	return parentalHaplotype;
	}
	/*_______________________________________________________________*/

	MultidimensionalTable<double>* HapCounters::getHaplotypeFreqsTab()
	{
		try
		{
// It computes the haplotype frequencies
			MultidimensionalTable<double>* genotypeAbsFreqsTab=NULL;
			if ( phaseAlg==onlyKnown ) return getKnownHaplotypeFreqs();
			MultidimensionalTable<double>*result=NULL;
			genotypeAbsFreqsTab=genotypeCounters->getGenotypeAbsFreqs ( everyGender );
			int type=0; // independent loci
			result=getHaplotypeFreqsTab ( type, genotypeAbsFreqsTab );
			if ( result==NULL )
			{
				type=1;
				result=getHaplotypeFreqsTab ( type, genotypeAbsFreqsTab );
			}
			if ( result==NULL ) throw NullValue ( " at HapCounters::getHaplotypeFreqsTab" );
			zap ( genotypeAbsFreqsTab );
			return result;
		}
		catch ( BasicException & e ) {e.addMessage ( "\n called from HapCounters::getHaplotypeFreqsTab()" ); throw; }
	}
	/*_________________________________________________________________*/

	MultidimensionalTable<double>* HapCounters::getKnownHaplotypeFreqs()
	{
try
{
//cout <<"using only known\n";
 	intList* dimList=new intList();
		for ( int i=0; i<genotypeCounters->totalPos;i++ ) dimList->insertElement ( genotypeCounters->genotypeArray->totalAlleles[i] );

		MultidimensionalTable<double>*result=new MultidimensionalTable<double> ( dimList );
		double freq, total;
		long long int hLeft, hRight, value, hap;
	

//cout <<"using only known2\n";



		longLongList* list;
		for ( int i=0; i<2; i++ )
		{
			if ( i==0 ) list=genotypeCounters->genotypeCountsMale; 
			else list=genotypeCounters->genotypeCountsFemale; 

//cout <<"using only known2b\n";
			for ( int i=0; i<list->size(); i++ )
			{
				value=list->getElement ( i );
				if ( value>=0 )
				{
//cout <<"using only known2c\n";
					hLeft=getHap ( value, true );

//cout <<"using only known2d\n";
					hRight=getHap ( value, false );

//cout <<"hleft:" << hLeft <<"and hright:" << hRight << "\n";
					if ( hLeft<0 || hRight<0 ) throw BadFormat ( "Pair<MultidimensionalTable<double>*>*  HapCounters::getKnownHaplotypeFreqs()" );


				result->addValue ( hLeft, 1 );
					result->addValue ( hRight, 1 );
				}
			}
		}


total=result->getTotalCounts();
total=addBayes (total, Bayes, distance, alphaBayes, 1);
for (int i=0; i<result->getSize();i++)
{
					freq=addBayes ( result->getValue(i), Bayes, distance, alphaBayes, result->getSize());
     result->setValue(i,freq/total);
}


 

		zap ( dimList );
		return result;
 }
    catch (BasicException& be) {be.addMessage ("\ncalled from MultidimensionalTable<double>* HapCounters::getKnownHaplotypeFreqs() "); throw;};
	}

	/*_______________________________________________________________*/

	MultidimensionalTable<double>* HapCounters::getInitialEstimation ( int type )
	{
	  try
		{
		double value;
		int *position;
		intList* dimList=new intList();
		for ( int i=0; i<genotypeCounters->totalPos;i++ ) 
		  dimList->insertElement ( genotypeCounters->genotypeArray->totalAlleles[i] );
		//cout << "dimlist is:" << *dimList <<"\n";
		MultidimensionalTable<double>* currentEstimation=new MultidimensionalTable<double> ( dimList );
		zap ( dimList );
		double total=0;
		
			for ( int i=0; i<currentEstimation->getSize();i++ )
			{
				position=currentEstimation->getPositions ( i );
				switch ( type )
				{
					case 0: //independent loci

						value=1;
						for ( int j=0; j<genotypeCounters->totalPos; j++ )
							if ( genotypeCounters->totalGenotypes==0 ) throw DivisionByZero ( "HapCounters::getInitialEstimation" );
							else   value=value* ( genotypeCounters->SNPAbsFreqsMale[j][position[j]]+genotypeCounters->SNPAbsFreqsFemale[j][position[j]] ) / ( genotypeCounters->totalGenotypes*2 );
						break;
					case 1://uniform
						value=1/ ( double ) currentEstimation->getSize();
						break;
				}
				currentEstimation->setValue ( i, value );
				zap ( position );
				total=total+value;
			}
					return currentEstimation;
			
		 }
    catch (BasicException& be) {be.addMessage ("\ncalled fromMultidimensionalTable<double>* HapCounters::getInitialEstimation ( int type ) "); throw;};


	}

	/*_______________________________________________________________*/

	MultidimensionalTable<double>* HapCounters::getHaplotypeFreqsTab ( int type, MultidimensionalTable<double>* genotypeAbsFreqsTab )
	{
		try
		{
			if ( phaseAlg==onlyKnown ) throw BadFormat ( "HapCountersUnknownHaps::getHaplotypeFreqsTab" );
//cout << "in HapCounters::getHaplotypeFreqsTab()\n";

			MultidimensionalTable<double>* result=this->getInitialEstimation ( type );

			double totalHaps=genotypeCounters->totalGenotypes*2;

			MultidimensionalTable<longLongList*> * ambiguousPartnerPointers=NULL;

//cout << "before totalcounts is:" << totalHaps <<"\n";
			this->genotypeCounters->genotypeArray->estimateMLE ( result, genotypeAbsFreqsTab, ambiguousPartnerPointers, totalHaps, 1000, this->haplotypeTable, Bayes, distance, alphaBayes );
//cout << "in HapCounters::getHaplotypeFreqsTab()-2\n";
							return result;
		}
		catch ( BasicException & e ) {e.addMessage ( "\n called from HapCounters::getHaplotypeFreqsTab(int type, MultidimensionalTable<double>* genotypeAbsFreqsTab)" ); throw; }
	}

	/*_________________________________________________________________*/

	void HapCounters::setTotalHaplotypes()
	{
		totalDifferentHaplotypes=0;
		totalUsedDifferentHaplotypes=0;
		double totalHaplotypes;
		for ( long long int key=0; key<haplotypeTable->getSize(); key++ )
		{
			totalHaplotypes=getTotalHaplotypes ( key, everyGender, allHomozygosity );
			if ( totalHaplotypes>0 ) totalDifferentHaplotypes++;
			if ( totalHaplotypes>0 )
			{
				totalUsedDifferentHaplotypes++;
			}
		}
//if (totalUsedDifferentHaplotypes<2) this->~HapCounters();
	}


	/*_________________________________________________________________*/

	MultidimensionalEmptyTable<int>* HapCounters::getHaplotypeArray()
	{
		return haplotypeTable;
	}






	/*_________________________________________________________________*/

	HapCounters::HapCounters()
	{
		genotypeCounters=NULL;
		haplotypeTable=NULL;
		maleHaps=NULL;
		femaleHaps=NULL;
		hapByFreqs=NULL;
		hapByFreqsMale=NULL;
		hapByFreqsFemale=NULL;
		totalDifferentHaplotypes=0;
		totalUsedDifferentHaplotypes=0;
		totalMeiosis=0;
	}
	/*______________________________________________________*/

	void HapCounters::setHaplotypeTable()
	{

		intList* dimList=new intList();
		for ( int i=0; i<genotypeCounters->totalPos; i++ )
			dimList->insertElement ( genotypeCounters->genotypeArray->totalAlleles[i] );

		haplotypeTable=new MultidimensionalEmptyTable<int> ( dimList );
//cout <<"hap counts: " << *haplotypeTable;
//exit(0);
		zap ( dimList );
	}
	/*______________________________________________________*/
	/*
	 void HapCounters::setSNPFreqs()
	{
	try
	{
	SNPAbsFreqsMaleLeft=new double*[genotypeCounters->totalPos];
	SNPAbsFreqsMaleRight=new double*[genotypeCounters->totalPos];
	SNPAbsFreqsFemaleLeft=new double*[genotypeCounters->totalPos];
	SNPAbsFreqsFemaleRight=new double*[genotypeCounters->totalPos];
	for (int i=0; i<genotypeCounters->totalPos; i++)
	{
	 SNPAbsFreqsMaleLeft[i]=Initialize(genotypeCounters->genotypeArray->totalAlleles[i], 0.0);
	 SNPAbsFreqsMaleRight[i]=Initialize(genotypeCounters->genotypeArray->totalAlleles[i], 0.0);
	 SNPAbsFreqsFemaleLeft[i]=Initialize(genotypeCounters->genotypeArray->totalAlleles[i], 0.0);
	 SNPAbsFreqsFemaleRight[i]=Initialize(genotypeCounters->genotypeArray->totalAlleles[i], 0.0);
	}
	double** SNPAbsFreqsLeft, **SNPAbsFreqsRight;
	int i=0, *positionLeft, *positionRight, al;
	InferredHaplotypesList* list;
	InferredHaplotypes* val;
	for (int i=0; i<2; i++)
	{
	if (i==0) {list=maleHaps; SNPAbsFreqsLeft=SNPAbsFreqsMaleLeft;SNPAbsFreqsRight=SNPAbsFreqsMaleRight;}
	else {list=femaleHaps; SNPAbsFreqsLeft=SNPAbsFreqsFemaleLeft;SNPAbsFreqsRight=SNPAbsFreqsFemaleRight;}
	for (InferredHaplotypesList::iterator it=list->begin(); it<list->end(); it++)
	if (*it!=NULL)
	{
	val=(InferredHaplotypes*)list->getElement(it);
	positionLeft=haplotypeTable->getPositions(val->leftHaplotype); positionRight=haplotypeTable->getPositions(val->rightHaplotype);
	for (int j=0; j<genotypeCounters->totalPos; j++)
	{
	 al=positionLeft[j]; SNPAbsFreqsLeft[j][al]=SNPAbsFreqsLeft[j][al]+val->freq;
	 al=positionRight[j]; SNPAbsFreqsRight[j][al]=SNPAbsFreqsRight[j][al]+val->freq;
	}
	zaparr(positionLeft); zap(positionRight);
	}
	}
	}
	catch (ORLLI & e) {e.addMessage("\ncalled from HapCounters::setSNPFreqs()"); throw; }
	catch (BasicException & be) {be.addMessage("\ncalled from HapCounters::setSNPFreqs()"); throw; }
	}

	/*____________________________________________________________ */
/*
	BidimensionalTable<double>* HapCounters::getMultiallelicFreqs ( SNPPos a, SNPPos b, gender gend )
	{
		try
		{
			if ( gend==unknown ) throw BadFormat ( "BidimensionalTable<double>* HapCounters::getMultiallelicFreqs(SNPPos a, SNPPos b, gender gend" );
			BidimensionalTable<double>*result=new BidimensionalTable<double> ( genotypeCounters->genotypeArray->totalAlleles[a], genotypeCounters->genotypeArray->totalAlleles[b] );
			int posLeft, posRight, *positionsLeft, *positionsRight;
			double totalHaplotypes=this->totalMeiosis*2,  SB=0, p;
			if ( gend!=everyGender ) totalHaplotypes=totalHaplotypes/2;
			InferredHaplotypesList* list;
			InferredHaplotypes* inferredHaplotypes;
			for ( int i=0; i<2; i++ )
			{
				if ( i==0 ) list=maleHaps; else list=femaleHaps;
				if ( ( i==0 && gend==male ) || ( i==1 && gend==female ) || ( gend==everyGender ) )
					for ( InferredHaplotypesList::iterator pointer=list->begin(); pointer!=list->end(); pointer++ )
						if ( *pointer!=NULL )
						{
							inferredHaplotypes= ( InferredHaplotypes* ) list->getElement ( pointer );
							if ( inferredHaplotypes->isKnown() )
							{
								posLeft=inferredHaplotypes->leftHaplotype; posRight=inferredHaplotypes->rightHaplotype;
								positionsLeft=haplotypeTable->getPositions ( posLeft ); positionsRight=haplotypeTable->getPositions ( posRight );
								result->addValue ( positionsLeft[a], positionsLeft[b], inferredHaplotypes->freq/totalHaplotypes );
								result->addValue ( positionsRight[a], positionsRight[b], inferredHaplotypes->freq/totalHaplotypes );
								zaparr ( positionsLeft ); zaparr ( positionsRight );
							}
						}
			}
			return result;
		}
		catch ( ORLLI & e ) {e.addMessage ( "\n called from HapCounters::getMultiallelicFreqs" ); throw; }
		catch ( BasicException & be ) {be.addMessage ( "\n called from HapCounters::getMultiallelicFreqs" ); throw; };
	}
	/*____________________________________________________________ */

	BidimensionalTable<double>* HapCounters::getMultiallelicFreqs ( SNPPos a, SNPPos b)
	{
		try
		{
				BidimensionalTable<double>*result=new BidimensionalTable<double> ( genotypeCounters->genotypeArray->totalAlleles[a], genotypeCounters->genotypeArray->totalAlleles[b] );
			int posLeft, posRight, *positionsLeft, *positionsRight;
			InferredHaplotypes* inferredHaplotypes;
   int pos[genotypeCounters->totalPos]; 
   double total=0;
   for (int i=0; i<genotypeCounters->totalPos;i++) pos[i]=haplotypeFreqsTab->dimensionList->getElement(i);
			
     total=total+haplotypeFreqsTab->getTotalCounts();
						for (int j=0; j<haplotypeFreqsTab->dimensionList->getElement(a);j++) 
					for (int k=0; k<haplotypeFreqsTab->dimensionList->getElement(b);k++) 
     {
      pos[a]=j; pos[b]=k;
      result->addValue(j, k, haplotypeFreqsTab->getValue(pos));
					}
/*
   for (int i=0; i<result->getXDim(); i++)
for (int j=0; j<result->getYDim(); j++)
   result->setValue(i, j, result->getValue(i,j)/total);
*/
			return result;
		}
		catch ( ORLLI & e ) {e.addMessage ( "\n called from HapCounters::getMultiallelicFreqs" ); throw; }
		catch ( BasicException & be ) {be.addMessage ( "\n called from HapCounters::getMultiallelicFreqs" ); throw; };
	}


	/*____________________________________________________________ */

	void HapCounters::setHapByFreqs ()
	{
		hapByFreqs=new FreqAndKeyVector();
		hapByFreqsMale=new FreqAndKeyVector();
		hapByFreqsFemale=new FreqAndKeyVector();
		FreqAndKey* fv;
		double total;
		for ( long long int key=0; key<haplotypeTable->getSize(); key++ )
			for ( int g=1; g<4; g++ )
			{
				total=getTotalHaplotypes ( key, ( gender ) g, allHomozygosity );
				if ( total>0 )
				{
					fv=new FreqAndKey();
					fv->First=total;
					fv->Second=key;
					switch ( ( gender ) g )
					{
						case male: hapByFreqsMale->insertElement ( fv ); break;
						case female: hapByFreqsFemale->insertElement ( fv ); break;
						case everyGender: hapByFreqs->insertElement ( fv ); break;
					}
				}
			}
		hapByFreqs->sort ( false );
		hapByFreqsMale->sort ( false );
		hapByFreqsFemale->sort ( false );
	}
	/*____________________________________________________________ */

	double HapCounters::getTotalHeteroGenotypes ( long long int hap, gender gen )
	{
		if ( gen==unknown ) throw BadFormat ( string ( "HapCounters::getTotalHeteroGenotypes" ) );
		InferredHaplotypes* inferredHaplotypes;
		InferredHaplotypesList *list;
		double total=0;
		long long int leftHap, rightHap;
		for ( int i=0; i<2;i++ )
		{
			if ( i==0 ) list=maleHaps; else list=femaleHaps;
			if ( ( gen==male && i==0 ) || ( gen==female && i==1 ) || ( gen==everyGender ) )
				for ( InferredHaplotypesList::iterator it=list->begin(); it<list->end(); it++ )
					if ( *it!=NULL )
					{
						inferredHaplotypes= ( InferredHaplotypes* ) list->getElement ( it );
						leftHap=inferredHaplotypes->leftHaplotype; rightHap=inferredHaplotypes->rightHaplotype;
						if ( ( leftHap==hap && rightHap!=hap ) || ( leftHap!=hap && rightHap==hap ) )
							total=total+inferredHaplotypes->freq;
					}
		}
		return total;
	}


	/*____________________________________________________________ */
	/*
	double HapCounters::getTotalHomoGenotypes (long long int hap, IndCategory ic) throw (BadFormat)
	{
	if (ic==offspring || ic==everybody) throw BadFormat(string("HapCounters::getTotalMeiosis"));
	ParentalHaplotypes* parentalHaplotypes;
	double total=0;
	long long int parentT, parentU, chosenParent;


	for (ParentalHaplotypesList::iterator it=haplotypeCounts->begin(); it<haplotypeCounts->end(); it++)
	if (*it!=NULL)
	{
	parentalHaplotypes=(ParentalHaplotypes*)haplotypeCounts->getElement(it);
	for (int parentC=0; parentC<2; parentC++)
	if (ic==parent || parentC==0 && ic==father || parentC==1 && ic==mother)
	{
	if (parentC==0) {parentT=parentalHaplotypes->fatherT; parentU=parentalHaplotypes->fatherU;}
	else {parentT=parentalHaplotypes->motherT; parentU=parentalHaplotypes->motherU;}
	if (parentT==hap && parentU==hap)
	total=total+parentalHaplotypes->freq;
	}
	}

	return total;
	}

	/*____________________________________________________________ */


	double HapCounters::getTotalHaplotypes ( long long int hap, gender gend, Homozygosity h ) throw ( BadFormat )
	{
		if ( gend==unknown ) throw BadFormat ( string ( "HapCounters::getTotalHaplotypes" ) );
		InferredHaplotypes* inferredHaplotypes;
		double total=0;
		long long int rightHaplotype, leftHaplotype;
		InferredHaplotypesList* list;
		for ( int i=0; i<2; i++ )
			if ( ( gend==male && i==0 ) || ( gend==female && i==1 ) || ( gend==everyGender ) )
			{
				if ( i==0 ) list=maleHaps; else list=femaleHaps;
				for ( InferredHaplotypesList::iterator it=list->begin(); it<list->end(); it++ )
					if ( *it!=NULL )
					{
						inferredHaplotypes= ( InferredHaplotypes* ) list->getElement ( it );
						leftHaplotype=inferredHaplotypes->leftHaplotype;
						rightHaplotype=inferredHaplotypes->rightHaplotype;
						if ( ( leftHaplotype!=rightHaplotype && h==onlyHetero ) || ( leftHaplotype==rightHaplotype && h==onlyHomo ) || h==allHomozygosity )
						{
							if ( leftHaplotype==hap ) total=total+inferredHaplotypes->freq;
							if ( rightHaplotype==hap ) total=total+inferredHaplotypes->freq;
						}
					}
			}
		return total;
	}



	/*_______________________________________________*/



};  // End of Namespace

#endif

/* End of file: MultimarkerMeasure.h */







