/* File: PhylogeneticDistance.h */

#ifndef __HapCounters_h__
#define __HapCounters_h__

//using namespace stats;

namespace BIOS {


/************************/
/* SNP'S MultimarkerMeasure DEFINITION */
/************************/


/**
        @memo MultimarkerMeasure for SNPs

	@doc
        Definition:

       Class used to obtain haplotypes from genotypes. 

       With this purpose, the data structures required are:
 
       InferredHaplotypesList *maleHaps, *femaleHaps   

        @author Maria M. Abad
	@version 1.0
*/



 
class	HapCounters {

//MultimarkerMeasureHap<TrioSample> *multimarkerMeasureTransmitted, *multimarkerMeasureUntransmitted;


public:
PhaseAlg phaseAlg;


BayesType  Bayes;
float alphaBayes;
float distance;
//EMRestriction emRestriction;

MultidimensionalTable<double>* haplotypeFreqsTab;

GenotypeCounters* genotypeCounters;
FreqAndKeyVector* hapByFreqs, *hapByFreqsMale, *hapByFreqsFemale;
//	   double** SNPAbsFreqsMaleLeft, **SNPAbsFreqsMaleRight, ** SNPAbsFreqsFemaleLeft, **SNPAbsFreqsFemaleRight;
//   double** SNPFreqs;
InferredHaplotypesList* maleHaps, *femaleHaps;// it allows to impute different pairs of haplotypes (HaplotypesForEachIndiidual with different frecs: InferredHaplotypes adds freqs)
double totalDifferentHaplotypes, totalUsedDifferentHaplotypes, totalMeiosis;
MultidimensionalEmptyTable<int>* haplotypeTable;



/*********************************************************************/
/***     ASSOCIATED FUNCTIONS     ***/
/*********************************************************************/


      public:



//	HapCounters(SNPPos Pos[], SNPPos totalPos, TrioSample * samp, int affectation=allAffectation, PhaseAlg=weighted, EMDistributions emDistributions=UTDistributions, EMRestriction emRestriction=triosBasedRestriction, bool includeMissing=false, bool onlyHetero=true, int minFreq=10);
	
 HapCounters(HapCounters& source);
 
HapCounters(GenotypeCounters* source, PhaseAlg phaseAlg=weighted, BayesType  Bay=MLE, float alphaBayes=0, float distance=0.0);

 HapCounters();

void set(HapCounters& source);

virtual void setHapByFreqs();

MultidimensionalEmptyTable<int>* getHaplotypeArray();


//void setSNPFreqs();

virtual void setHaplotypeCounts();
MultidimensionalTable<double>* getKnownHaplotypeFreqs();

long long int getHap(const long long int value, bool left);
MultidimensionalTable<double>* getHaplotypeFreqsTab();
//double getNormalizationValue(int totalConfigurations, long long int ambiguousPos, MultidimensionalTable<double>* haplotypeFreqsTab);
double getNormalizationValue (MultidimensionalTable<double>* haplotypeFreqsTab, int totalConfigurations, long long int ambiguousPos);


void set(GenotypeCounters* genotypeCounters, PhaseAlg phaseAlg, BayesType  Bay, float alphaBayes, float distance);  


InferredHaplotypes* getInferredHaplotypes(long long int ambiguousConf, int binaryKnownConfiguration);

MultidimensionalTable<double>* getHaplotypeFreqsTab(int type, MultidimensionalTable<double>* genotypeAbsFreqsTab);
MultidimensionalTable<double>* getInitialEstimation(int type);
//double getIndependentLociFrequency (long long int key);
virtual ~HapCounters();
void setTotalHaplotypes();
BidimensionalTable<double>* getMultiallelicFreqs(SNPPos a, SNPPos b);
virtual HapCounters* clone();
//double getLengthMeasure (long long int pos1T, long long int pos2T, long long int pos1U, long long int pos2U);
 void setHaplotypeTable();
double getTotalHaplotypes (long long int hap, gender gend, Homozygosity h=allHomozygosity) throw (BadFormat);
double getTotalHeteroGenotypes (long long int hap, gender gend);
// virtual HapCounters* getPermutation(); //{throw NonImplemented("getPermutation");};
double getCurrentFrequency(MultidimensionalTable<double>* haplotypeFreqsTab, InferredHaplotypes *inferredHaplotypes);
double getCurrentFrequency ( MultidimensionalTable<double>* haplotypeFreqsTab, long long int leftHaplotype, long long int rightHaplotype);
void setTotalMeiosis();
//HeteroPair<HaplotypeTUCountsVector*,ParentalHaplotypesUsingPointersList*>* getTUCounts(bool onlyHetero=true);


};  // End of class MultimarkerMeasure




ostream& operator<<(ostream& out, HapCounters& pm)
       {
//if (pm.trioCounters!=NULL)
//   out << *pm.trioCounters <<"\n";
cout << "male haps:\n";
if (pm.maleHaps!=NULL)
   out << *pm.maleHaps << "\n";
cout << "female haps:\n";
   if (pm.femaleHaps!=NULL)
   out << *pm.femaleHaps << "\n";

return out;
};

};  // End of Namespace

#endif

/* End of file: MultimarkerMeasure.h */






