/* File: Haplotype.cpp */


#ifndef __Haplotype_cpp__
#define __Haplotype_cpp__

//using namespace UTILS;


namespace BIOS
{



	void Haplotype::checkRangeSNP ( SNPPos SNP )
	{
		if ( SNP<0 || SNP>=size() ) throw OutOfBounds ( SNP, size(), "Haplotype::CheckRangeSNP(SNPPos SNP)" );
	}

	/*_____________________________________________________*/

	void Haplotype::checkBase ( SNPPos SNP )
	{
		try
		{
//			throw NonImplemented ( "	void Haplotype::checkBase ( SNPPos SNP )" );
		if ( alleleArray==NULL ) throw NullValue ( "Haplotype::checkBase(SNPPos SNP)" );
if 	(!isABaseAllele ( (allele)alleleArray[SNP] ) ) throw NonSNP ( ( int ) alleleArray[SNP], "Haplotype::checkBase(SNPPos SNP)" );
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from void Haplotype::checkBase ( SNPPos SNP )" ); throw;};

	}

	/*_____________________________________________________*/

	Haplotype::Haplotype() {alleleArray=NULL; totalSNPs=0;}

	/*
	Haplotype::Haplotype(base* source, SNPPos TotalSNPs)
	{
	setHaplotypeArray(source, TotalSNPs);
	};
	*/

	/*_____________________________________________________*/

	Haplotype::Haplotype ( SNPPos totalPos ):GeneticUnit(totalPos)
	{
		alleleArray=NULL;
		if ( totalPos>0 ) alleleArray=Initialize ( totalPos, ( base ) 5 );
	}

	/*_____________________________________________________*/

	Haplotype::Haplotype ( base * alleleArray, SNPPos size ):GeneticUnit()
	{
		setHaplotypeArray ( alleleArray, size );
	}

	/*_____________________________________________________*/

	Haplotype::Haplotype ( string alleleString ):GeneticUnit()
	{
try
{		setHaplotypeArray ( alleleString, alleleString.length() );
}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from 	Haplotype::Haplotype ( string alleleString)" ); throw;};
	}

	/*_____________________________________________________*/


	Haplotype::Haplotype ( const Haplotype & source ): GeneticUnit()
	{
		try
		{
			alleleArray=NULL;
//cout <<"totalsnps: " << totalSNPs <<"\n";
			setHaplotypeArray ( source.alleleArray, source.totalSNPs );
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from 	Haplotype::Haplotype ( const Haplotype & source )" ); throw;};

	}
	/*_____________________________________________________*/

	Haplotype::~Haplotype ()
	{
		zaparr ( alleleArray );
	}
	/*
	Haplotype& Haplotype::operator=(const Haplotype& g)
	{
	return *this;
	}
	*/
	/*_____________________________________________________*/


	LongHaplotype* Haplotype::copyAsLongHaplotype ()
	{
		return new LongHaplotype ( alleleArray, totalSNPs );
	}

	/*_____________________________________________________*/

	GeneticUnit* Haplotype::clone()
	{
		try
		{
//cout <<"herecloe\n";
			return new Haplotype ( *this );
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from 	Haplotype::Haplotype* clone()" ); throw;};
	};

	/*_____________________________________________________*/


	Haplotype* Haplotype::getSymmetricalSubstitution ( intList *positionsToInvert )
	{
// replace by their complementary
		base b;
		if ( positionsToInvert==NULL ) throw NullValue ( "Haplotype* Haplotype::getSymmetricalSubstitution(intList *positionsToInvert)" );
		Haplotype* result=(Haplotype*)clone();
		for ( intList::iterator it= positionsToInvert->begin(); it!=positionsToInvert->end(); it++ )
		{
			b=alleleArray[*it];
			switch ( b )
			{
				case ad: result->alleleArray[*it]=ti; break;
				case ci: result->alleleArray[*it]=gu; break;
				case gu: result->alleleArray[*it]=ci; break;
				case ti:result->alleleArray[*it]=ad; break;
			}
		}
		return result;
	}

	

	/*_____________________________________________________*/

	double Haplotype::getDistance ( GeneticUnit* otherG, int position, bool toLeft )
	{
try
{
Haplotype* other=(Haplotype*) otherG;
		position=-1;
		double result, max;
		int cont;
		if ( other->size() != size() )  throw OutOfBounds ( other->size(), this->size(), "Haplotype::getDistance(...) " );
		if ( position>0 && size() ==0 ) throw OutOfBounds ( position, this->size(), "Haplotype::getDistance(...)-2 " );
		if ( position < -1 || position > ( size()-1 ) ) throw OutOfBounds ( position, this->size(), "Haplotype::getDistance(...) " );
		if ( size() ==0 ) return 0;
		if ( position==-1 ) // opposite to the similarity measure (Yu.zz.2005) which finds the largest segment with same alleles
		{
			max=0;
			for ( int ini=0;ini<size();ini++ )
			if (max<(size()-ini)) // to save time
			{
				cont=ini;
				result=0;
				while ( cont<size() &&  alleleArray[cont]==other->alleleArray[cont] &&  alleleArray[cont]!=na)
				{
					result++;
					cont++;
				}
				if ( result>max ) max=result;
			}
			return size()-max;
		}
		result=0;
		cont=position;
		if ( toLeft )
		{
			while ( cont>0 && ( alleleArray[cont]==other->alleleArray[cont]) && alleleArray[cont]!=na) // || other->alleleArray[cont]==na ) )
			{
				//if ( alleleArray[cont]==other->alleleArray[cont] && alleleArray[cont]!=na )
					result++;
				cont--;
			}
		}
		else
		{
			while ( cont<size() &&  alleleArray[cont]==other->alleleArray[cont] &&  alleleArray[cont]!=na) // || other->alleleArray[cont]==na ) )
			{
				result++;
				cont++;
			}
		}
		return size()-position-cont;
}
		catch ( BasicException& be )
		{
			be.addMessage ( "\ncalled from  double Haplotype::getDistance ( Haplotype* other, int position, bool toLeft )" );
			throw;
		};
	}

	/*_____________________________________________________*/



	bool Haplotype::operator== ( const GeneticUnit & h )
	{
		Haplotype& g=(Haplotype&) h;
		if ( g.alleleArray==NULL || this->alleleArray==NULL )
			throw NullValue ( "bool Haplotype::operator==(Haplotype & g)" );
		if ( g.size() !=size() ) return false;
		for ( int i=0; i<size();i++ )
			if ( g.alleleArray[i]!=this->alleleArray[i] ) return false;
		return true;
	};
	;
	/*_____________________________________________________*/

/*
	bool Haplotype::operator!= ( Genetic & g )
	{
		return ! ( g==*this );
	}

	/*_____________________________________________________*/




	base* Haplotype::getHaplotypeArray ()
	{
		return alleleArray;
	}

/*_____________________________________________________*/

	base& Haplotype::operator[] ( int position )
	{
		return alleleArray[position];
	}

	/*_____________________________________________________*/



	bool Haplotype::isMissing ( SNPPos position )
	{
		return ( alleleArray[position]==5 );
	}

 /*_____________________________________________________*/






	bool Haplotype::hasAMissingPosition()
	{
		try
		{
			for ( int i=0; i<size(); i++ )
				if ( isMissing ( i ) ) return true;
			return false;
		}
		catch ( BasicException & be ) {be.addMessage ( "\ncalled from 	bool Haplotype::hasAMissingPosition()" ); throw;};
	}
   /*_____________________________________________________*/





	void Haplotype::setHaplotypeArray ( base *array, SNPPos totalSNPs )
	{
try
{
		this->totalSNPs=totalSNPs;
		this->alleleArray=NULL;
		if ( totalSNPs>0 ) alleleArray=new base[totalSNPs];
		for ( int i=0; i<totalSNPs;i++ )
		{
			this->alleleArray[i]=array[i];
			//checkBase ( i );
		}
}
		catch ( BasicException & be ) {be.addMessage ( "\ncalled from void Haplotype::setHaplotypeArray ( base *array, SNPPos totalSNPs )" ); throw;};
	}

	/*_____________________________________________________*/


	void Haplotype::setHaplotypeArray ( string array, SNPPos totalSNPs )
	{
try
{
//cout <<"string is: " << array << ", totalpos is: " << totalSNPs <<"\n";
		this->totalSNPs=totalSNPs;
		this->alleleArray=NULL;
		if ( totalSNPs>0 ) alleleArray=new base[totalSNPs];
		for ( int i=0; i<totalSNPs;i++ )
		{
			this->alleleArray[i]=(base)(array[i]-'0');
			checkBase ( i );
		}
}
		catch ( BasicException & be ) {be.addMessage ( "\ncalled from void Haplotype::setHaplotypeArray (string array, SNPPos totalSNPs )" ); throw;};
	}

	/*_____________________________________________________*/


	void Haplotype::setAllele ( base b, SNPPos SNP )
	{
		checkRangeSNP ( SNP );
		alleleArray[SNP]=b;
		//checkBase ( SNP );
	}

	/*_____________________________________________________*/



	base Haplotype::getAllele ( SNPPos SNP )
	{
		return alleleArray[SNP];
	}

	/*_____________________________________________________*/


	GeneticUnit* Haplotype::fromString ( string s )
	{
		try
		{
			allele a;
			Haplotype* result=new Haplotype ( s.length() );
			for ( int i=0; i<s.length();i++ )
			{
				a=ConvertAllele ( tos ( s[i] ).c_str() );
				if ( !BIOS::isABaseAllele ( a ) ) throw NonSNP ( ( int ) a, "Haplotype::fromString ( string s )" );
				else 			result->setAllele ( ( base ) a, i );
			}
			return result;
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from Haplotype* Haplotype::fromString ( string s )" ); throw;};

//throw NonImplemented("Haplotype::fromString(string s)");
	}
	/*_____________________________________________________*/


	Haplotype* Haplotype::filter ( int *positions, int length )
	{
		try
		{
			Haplotype* result=new Haplotype ( length );
			for ( int i=0; i<length;i++ )
			{
				if ( positions[i]<0 || positions[i]>=size() )
					throw OutOfBounds ( positions[i], size(), "Haplotype::filter (int *positions, int length)" );
				result->setAllele(this->alleleArray[positions[i]], i);
			}
			return result;
		}
		catch ( BasicException & be ) {be.addMessage ( "\ncalled from 	Haplotype* Haplotype::filter ( int *positions, int length )" ); throw;};
	}
	/*_____________________________________________________*/


	//bool  Haplotype::operator> ( const Haplotype & ge ) {cout <<"Not implemented yet"; exit ( 0 );};;
	/*_____________________________________________________*/


	bool  Haplotype::operator< ( const GeneticUnit & ge ) {cout <<"Not implemented yet"; exit ( 0 );};

	/*_____________________________________________________*/

	bool operator< ( const Haplotype& a1, const Haplotype& a2 )
	{
		return false;
	}

	/*_____________________________________________________*/
	/*
	  bool operator<( const HapP& a1, const HapP& a2 )
	{
	return false;
	}

		/*_____________________________________________________*/


//	bool  Haplotype::operator> ( Haplotype * ge ) {cout <<"Haplotype::operator> ( Haplotype * ge ) Not implemented yet"; exit ( 0 );};;
	/*_____________________________________________________*/


	bool  Haplotype::operator< ( const GeneticUnit * ge ) const {cout <<"Haplotype::operator< ( Haplotype * ge ) Not implemented yet"; exit ( 0 );};;


	
	/*_____________________________________________________*/

	void Haplotype::print ( ostream& out )
	{
		try
		{
			for ( int i=0; i<size();i++ )
			{
//checkBase(i);
//out << alleleArray[i];
			
	out << UnconvertAllele ( ( allele ) alleleArray[i] );
			}
		}
		catch ( BasicException& be ) {be.addMessage ( "Haplotype::print(ostream& out)" ); throw;}
	}


};  // End of Namespace

#endif

/* End of file: Haplotype.h */




