#ifndef __HaplotypeCaseControlCounts_h__
#define __HaplotypeCaseControlCounts_h__

namespace BIOS
{

	/**
	HaplotypeCaseControlCounts: an haplotype and its case/control frequencies in a given sample 
**/
	class HaplotypeCaseControlCounts;
	typedef Set<HaplotypeCaseControlCounts*>::Class SetOfHaplotypeCaseControlCounts;
	

typedef Vector<HaplotypeCaseControlCounts*>::Class HaplotypeCaseControlCountsList;

typedef Vector<HaplotypeCaseControlCounts*>::Class HaplotypeCaseControlCountsVector;



//typedef  Vector<TUMeasure*>::Class ListOfCaseControlMeasures;

	class GeneticUnitCounts;

	class HaplotypeCaseControlCounts: public HaplotypeCounts
	{
		

			
		public:



			float frequencyCases;


			float frequencyControls;


			/**
			* Constructor
			*/
			HaplotypeCaseControlCounts ( int size=0 );

		
			HaplotypeCaseControlCounts ( Haplotype* haplotype, float frequencyCases, float frequencyControls );

			HaplotypeCaseControlCounts ( HaplotypeCaseControlCounts& other );

			virtual ~HaplotypeCaseControlCounts(){};





			/**
			*	Compares two haplotypes, inluding all properties
			*	@return true if haplotypes are different
			*/
			//virtual bool operator== ( GeneticUnitCounts & h );


			//virtual void sumProps(GeneticUnitCounts * h);
			


			virtual HaplotypeCaseControlCounts* fromString ( string s ) {throw NonImplemented ( "HaplotypeCaseControlCounts::fromString(string s)" );};

			virtual GeneticUnitCounts* clone(); // {return new HaplotypeCaseControlCounts ( *this );};

//virtual SampleGenericCounts* getCounts(GenericSample* ts, int* pos, int size);

			/**
			* Prints the HaplotypeCaseControlCounts in the following manner: [ a0 a1 ... an ][frequency][T/U]
			* @param output Output stream
			* @param h Vector to print
			*/
			

//virtual void print(ostream& output);

virtual double getThirdFrequency(){return 0; }; // {throw NonDefinedMethod("double HaplotypeCaseControlCounts::getThirdFrequency()");};



virtual void setThirdFrequency(double f){throw NonDefinedMethod("void HaplotypeCaseControlCounts::setThirdFrequency(double f)");};
			/*
						static void print(HaplotypeCaseControlCounts *h){
							for(int i=0; i< h->size()-1; i++)
								printf("%i ", (*h)[i]);
						}
				*/
		//	virtual void print();


	};



};

#endif
