#ifndef __HaplotypeCaseControlTable_cpp__
#define __HaplotypeCaseControlTable_cpp__
#include "HaplotypeTable.h"


namespace BIOS
{



	HaplotypeCaseControlTable::HaplotypeCaseControlTable ( int cols, double minFreq, bool HWE) :HaplotypeTable (cols, minFreq, false )
	{
	};



	/*_____________________________________________________________________________________________________________*/


	HaplotypeCaseControlTable::HaplotypeCaseControlTable ( const HaplotypeCaseControlTable& other ) :HaplotypeTable ( ( HaplotypeTable& ) other )
	{
	};
	
	/*_____________________________________________________________________________________________________________*/



	HaplotypeCaseControlTable::HaplotypeCaseControlTable (VectorSample<GeneticUnitCounts*>::Class * partition, double minFreq, bool HWE ):HaplotypeTable ( partition, 2, minFreq, HWE ) 
	{
filter();	};




	/*_____________________________________________________________________________________________________________*/


	HaplotypeCaseControlTable::HaplotypeCaseControlTable (Vector<GeneticUnitCounts*>::Class * p, double minFreq, bool HWE )
			:HaplotypeTable (p, 2, minFreq, HWE )
	{
	//  cout << "before filtering HaplotypeCaseControlTable is: " << *this <<  endl;
filter();
	};

	/*_____________________________________________________________________________________________________________*/


	AssociationTable* HaplotypeCaseControlTable::clone()
	{
		return new HaplotypeCaseControlTable ( *this );
	}

/*_____________________________________________________________________________________________________________*/


	AssociationTable* HaplotypeCaseControlTable::createEmptyTable(int totalCols)
	{
		HaplotypeCaseControlTable* result=new HaplotypeCaseControlTable(totalCols, this->minFreq, this->HWE);
		return result;
	}

	


};

#endif
