#ifndef __HaplotypeCaseControlTable_h__
#define __HaplotypeCaseControlTable_h__

namespace BIOS
{

	/**
	   @memo HaplotypeCaseControlTable
	   @doc
	   Definition:
	  Table with
	  1. as many columns as genetic units (genotypes or haplotypes) and two rows to store Case/Control haplotype/genotype frequencies for case/control samples

	   @author María M. Abad Grau
	   @version 1.0
	  
	  */




	class HaplotypeCaseControlTable: public HaplotypeTable
	{

		public:
			


			/**
			*	Constructor
			*/
			HaplotypeCaseControlTable ( int cols, double minFreq=0, bool HWE=false );

			/**
			*	Destructor
			*/
			virtual	~HaplotypeCaseControlTable(){};

			virtual AssociationTable* createEmptyTable(int totalColumns);

			static HaplotypeCaseControlTable* fromString ( string s ) {throw NonImplemented ( "static HaplotypeCaseControlTable* fromString(string s)" );};

			HaplotypeCaseControlTable ( const HaplotypeCaseControlTable& other );

			/**
			*	Constructor from a vector of genetic unit counts
			* 	Creates a table from the T/U or Case/control data in a vector of haplotypes/genotypes.
			* It creates a partition with one haplotype/genotype at each haplotypeVector or genotypeVector in the partition
			*	The number of columns in the table will be the number of haplotypes in the vextor.
			*	The number of rows will be two. The first for the Transmitted haplotypes. The second for the Non transmitted.
			*	@param p HaplotypVector from which to fill the table
			*/

		
			HaplotypeCaseControlTable (GeneticUnitCountsVector * genCounts,  double minFreq=0, bool HWE=0);

/**
		*	Constructor from a partition
		* 	Creates a table from the genetic unit data in a partition
		*	The number of columns in the table will be the number of vectors (subsets) in countPartitions.
		*	The number of rows will be two or three. The first for the Transmitted/case haplotypes/genotypes. The second for the Non transmitted/control haplotypes/genotypes and the third for homozygous transmissions in TU data sets.
		*	@param p Partition from which to fill the table
		*/	
	
			HaplotypeCaseControlTable(GeneticUnitCountsSample * countsPartition, double minFreq=0, bool HWE=0);


			virtual AssociationTable* clone();

			virtual string firstHeading(){return string("H_Cs");};

			virtual string secondHeading(){return string("H_Co");};



			

	};


};

#endif
