#ifndef __HaplotypeCounts_cpp__
#define __HaplotypeCounts_cpp__

void print(BIOS::HaplotypeCounts *h){
	cout << *h << endl;
}

void print2(BIOS::HaplotypeCounts *h){
	cout << "hola" << endl;
}

namespace BIOS {

	HaplotypeCounts::HaplotypeCounts(int size):GeneticUnitCounts()
	{
		if (size!=0) geneticUnit=new Haplotype(size);
	};
	
	
	

	/*_________________________________________________________________*/
	
			HaplotypeCounts::HaplotypeCounts(GeneticUnitCounts& other):GeneticUnitCounts(other)
			{
			}
	



				/*_________________________________________________________________*/
	
Haplotype* HaplotypeCounts::getHaplotype()
	{
		return (Haplotype*) geneticUnit;
	}


/*_________________________________________________________________*/


        GeneticUnitCounts * HaplotypeCounts::filter(int *pos, int length)
        {
                int lastPos = this->size() - 1;

                // Check all positions are valid
                for(int i=0; i<length; i++)
                        if ( pos[i] < 0 || pos[i] > lastPos){
                                //cerr << "Invalid HaplotypeCounts::newHaplotypeFromPositions" << endl;
                                throw OutOfBounds(size(), pos[i], "HaplotypeCounts::filter (int *pos, int length)");
                                return NULL;
                        }

                // create new GeneticUnitCounts
                GeneticUnitCounts * h = this->clone();

		h->empty();

		h->geneticUnit=new Haplotype(length);

                // Copy alleles values
                for (int i=0; i<length; i++)
                        ((Haplotype*)h->geneticUnit)->setAllele( (*this)[ pos[i] ], i);

                return h;

        }
	/*_________________________________________________________________*/
	

			HaplotypeCounts::HaplotypeCounts(GeneticUnit* haplotype, float frequencyCases, float frequencyControls): GeneticUnitCounts(haplotype, frequencyCases, frequencyControls)
			{
			}

			/*_________________________________________________________________*/
	
	base& HaplotypeCounts::operator[] (int position) 
	{
		//base& ini=(*this->haplotype->alleleArray);
		//return (base&)ini;
		return (*(((Haplotype*)this->geneticUnit)->alleleArray+position));
	} 

			

			/*_________________________________________________________________*/
	
	int HaplotypeCounts::getCommonPositions(GeneticUnitCounts* other, intList* positions) 
	{
HaplotypeCounts* hap=(HaplotypeCounts*) other;
		if (hap->size()!=this->size()) throw OutOfBounds(hap->size(), this->size(), "2. HaplotypeCounts::getCommonPositions"); 
		int commonPositions=0;
		for (intList::iterator it=positions->begin(); it!=positions->end(); it++)
		if (*it>=this->size() || *it<0) throw OutOfBounds(*it, this->size(), "2. HaplotypeCounts::getCommonPositions"); 
		//else if (this->getElement(*it)!= hap->getElement(*it)) return commonPositions; 
		else 
		if ((*this)[*it]!= (*hap)[*it]) return commonPositions; 
		else commonPositions++;
		return commonPositions;
	}
	

	


};

#endif
