#ifndef __HaplotypeCounts_h__
#define __HaplotypeCounts_h__

namespace BIOS
{

	/**
	HaplotypeCounts: an haplotype and its transmitted/untransmitted frequencies in a given sample 
**/
	class HaplotypeCounts;
	typedef Set<HaplotypeCounts*>::Class SetOfHaplotypeCounts;


typedef Vector<HaplotypeCounts*>::Class HaplotypeCountsList;

typedef Vector<HaplotypeCounts*>::Class HaplotypeCountsVector;

	class HaplotypeCounts: public GeneticUnitCounts
	{
		private:



		public:

			

			/**
			* Constructor
			*/
			HaplotypeCounts ( int size=0 );

		HaplotypeCounts(GeneticUnit* haplotype, float frequencyCases, float frequencyControls);

HaplotypeCounts(GeneticUnitCounts& geneticUnitCounts);

virtual GeneticUnitCounts * filter(int *pos, int length);

			virtual ~HaplotypeCounts(){};

			Haplotype* getHaplotype();



		//	virtual HaplotypeCounts * filter(int *pos, int length);

			virtual int getCommonPositions ( GeneticUnitCounts* hap, intList* positions );

			base & operator[] ( int position ) ;




			/**
			*	Compares two haplotypes, inluding all properties
			*	@return true if haplotypes are equal
			*/
			//virtual bool operator== (GeneticUnitCounts & h )=0;

			/**
			*	Compares two haplotypes, inluding all properties
			*	@return true if haplotypes are different
			*/
			//bool operator!= ( GeneticUnitCounts & h );


			
			

			virtual GeneticUnitCounts* fromString ( string s ) {throw NonImplemented ( "HaplotypeCounts::fromString(string s)" );};

			virtual GeneticUnitCounts* clone()=0;// {return new HaplotypeCounts ( *this );};

			


virtual double getThirdFrequency()=0;



virtual void setThirdFrequency(double f)=0;


	};



};

#endif
