#ifndef __HaplotypeTable_h__
#define __HaplotypeTable_h__

namespace BIOS {
	
  /**
     @memo HaplotypeTable
     @doc
     Definition:
	It adds a row to AssociationTable with homo frequencies and implements specific methods for TU tables used by TDT methods

     @author María M. Abad Grau
     @version 1.0
	
	*/	

class HaplotypeTUCountsTree;





class VectorOfParentalHaplotypes;
// typedef SingleAncestorGraph<DirectedArc, HaplotypeTUCounts*, void> TreeOfHaplotypeTUCounts;

class HaplotypeTable: public AssociationTable{
    
  

public:
		

		/**
		*	Constructor
		*/		
		HaplotypeTable(int cols, double minFreq=0, bool HWE=false);

		/**
		*	Destructor
		*/		
	virtual	~HaplotypeTable() {};

    static HaplotypeTable* fromString(string s){throw NonImplemented("static HaplotypeTable* fromString(string s)");};


		/**
		*	Constructor from a partition
		* 	Creates a table from the T/U data in a partition
		*	The number of columns in the table will be the number of vectors (subsets) in countPartitions.
		*	The number of rows will be two or three, depending on T class. The first for the Transmitted/case haplotypes/genotypes. The second for the Non transmitted/control haplotypes/genotypes.
		*	@param p Partition from which to fill the table
		*/		
	HaplotypeTable(Vector<GeneticUnitCounts*>::Class* countsVector, int totalRows, double minFreq=0, bool HWE=false);

//HaplotypeTable(PartitionHaplotypeTUCountsVector* hapCounts, double minFreq=0, bool HWE=false); is it really needed
		//PartitionHaplotypeTUCountsVector
		HaplotypeTable(const HaplotypeTable& other);

 		/*	Constructor from a partition
		* 	Creates a table from the genetic unit data in a partition
		*	The number of columns in the table will be the number of vectors (subsets) in countPartitions.
		*	The number of rows will be two or three. The first for the Transmitted/case haplotypes/genotypes. The second for the Non transmitted/control haplotypes/genotypes and the third for homozygous transmissions in TU data sets.
		*	@param p Partition from which to fill the table
		*/		
			HaplotypeTable(VectorSample<GeneticUnitCounts*>::Class * countsPartition, int totalRows, double minFreq=0, bool HWE=false);
	//HaplotypeTable(HaplotypeCaseControlCountsVector* hapCounts, int* positions=NULL, int length=-1, double minFreq=0, bool HWE=false);

  //virtual AssociationTable* clone();


		

	 /**
	 * Creates a HaplotypeTable from this and the given tree.
	 * Uses the best nodes of the tree to restrict the columns of this table.
	 * The nodes of the tree must be present in the table
	 * @param tree Tree of haplotypes used to restrict the columns in this table.
	 * @return A new table.
	 */
	 HaplotypeTable * newFromTree(HaplotypeTUCountsTree *tree);		
// 	 HaplotypeTable * newFromTree(TreeOfHaplotypeTUCounts *tree);

			virtual string firstHeading()=0;

			virtual string secondHeading()=0;

	
	};
	
	




};

#endif
