/* File: LongHaplotype.cpp */


#ifndef __LongHaplotype_cpp__
#define __LongHaplotype_cpp__

//using namespace UTILS;


namespace BIOS {


/*_____________________________________________________*/

LongHaplotype::LongHaplotype():Haplotype(){}
	
/*
Haplotype::Haplotype(base* source, SNPPos TotalSNPs)
{
setHaplotypeArray(source, TotalSNPs);
};
*/

/*_____________________________________________________*/

LongHaplotype::LongHaplotype(SNPPos totalPos):Haplotype(totalPos)
{
}

/*_____________________________________________________*/

LongHaplotype::LongHaplotype(base * alleleArray, SNPPos size):Haplotype(alleleArray, size)
{
}

/*_____________________________________________________*/


LongHaplotype::LongHaplotype(const LongHaplotype & source): Haplotype(source)
{
}

/*_____________________________________________________*/

void LongHaplotype::print(ostream& out)
{
try
{
out <<"longhap\n";
Haplotype::print(out);
}
catch (BasicException& be){be.addMessage("LongHaplotype::print(ostream& out)"); throw;}
}

	/*_____________________________________________________*/


	GeneticUnit* LongHaplotype::fromString ( string s )
	{
		LongHaplotype* result=new LongHaplotype ( s.length() );
		for ( int i=0; i<s.length();i++ )
			result->setAllele ( ( base ) ( ConvertAllele ( tos ( s[i] ).c_str() ) ), i );
		return result;
//throw NonImplemented("Haplotype::fromString(string s)");
	}


/*_____________________________________________________*/
/*
double LongHaplotype::getDistance(GeneticUnit* other, int position, bool toLeft)
{
// position and toLeft are not used, this class has been created to provide another way of computing distances: the opposite to the lenght contrast measure (Yu et al. 2005)
//return Haplotype::getDistance(other, -1, 0);  // for lengthContrastMeasure
return Haplotype::getDistance(other, 0, 0);  
*/



};  // End of Namespace

#endif

/* End of file: Haplotype.h */




