/* File: Haplotype.h */


#ifndef __LongHaplotype_h__
#define __LongHaplotype_h__

//using namespace UTILS;


namespace BIOS {


/************************/
/* SNP'S Haplotype DEFINITION */
/************************/


/**
        @memo LongHaplotype for SNPs

	@doc
        Definition:
        A unordered pair of SNPs values for an individual and a genetic position.
        One has been transmitted from the father, one for the mother. Who transmits
        each one of them does not matter.

        Memory space: O(1). 

        @author Maria M. Abad
	@version 1.0
*/


 
 
class LongHaplotype: public Haplotype {

public:

//virtual double getDistance(GeneticUnit* other, int position=0, bool toLeft=false);
 
LongHaplotype();

LongHaplotype(base* source, SNPPos TotalSNPs);
	
LongHaplotype(SNPPos TotalSNPs);

static GeneticUnit* fromString(string s);

LongHaplotype(const LongHaplotype & source);

virtual GeneticUnit* clone(){return new LongHaplotype(*this);};



	virtual void print(ostream& out);


};

}  // End of Namespace

#endif

/* End of file: Haplotype.h */




