/* File: MonolociMeasure.h */


#ifndef __MonolociMeasure_cpp__
#define __MonolociMeasure_cpp__






namespace BIOS {



/**********************************/
/* DEFINITIONS OF THE FUNCTIONS */
/**********************************/



///////////////////
//// public ////////
///////////////////

template<class T>  MonolociMeasure<T>::MonolociMeasure(T * samp, const BayesType & Bay, const float alpha, IndCategory ic)
		  {
// Marked is used for consistency when only genotypes are chosen
			  sample=samp; Bayes=Bay; this->alpha=alpha;//
			marked=new bool [sample->size()];
         samp->phenotypeSample->SetMarked ( marked, ic, everyGender, allAffectation );
	//		  IndPos TotalInds=sample->genotypeSample->size();
			  	 
		  }

/*____________________________________________________________ */


	template<>	  MonolociMeasure<TrioSample>::MonolociMeasure(TrioSample * samp, const BayesType & Bay, const float alpha, IndCategory ic)
		  {
// Marked is used for consistency when only genotypes are chosen
			  sample=samp; Bayes=Bay; this->alpha=alpha;//
			marked=new bool [sample->genotypeSample->size()];

                samp->phenotypeSample->SetMarked ( marked, ic, everyGender, allAffectation );

	//		  IndPos TotalInds=sample->genotypeSample->size();
			  	 
		  }
/*____________________________________________________________ */

template<class T> double MonolociMeasure<T>::GetTotalAllele(const SNPPos & SNP, const allele allele1, int distance)
{

double total=sample->genotypeSample->GetTotalAllele(SNP, allele1, marked);
total=AddBayesAllele(total, Bayes, distance, alpha);
return total;
}

/*____________________________________________________________ */

template<class T> double MonolociMeasure<T>::GetTotalFreqAllele(const SNPPos & SNP, const allele allele1, int distance)
{
	double total=GetTotalAllele(SNP, allele1);
	double total2=0;
	for (int i=0; i<4; i++)
	 total2=total2+GetTotalAllele(SNP, (allele)(i+1));
	total2=AddBayesAllele(total2, Bayes, distance, alpha);
 if (total2>0)
 return total/total2;
 else return 0;
}

/*____________________________________________________________ */

template<class T> double MonolociMeasure<T>::GetTotalMissing(const SNPPos & SNP)
{
	return sample->genotypeSample->getTotalMissing(SNP, marked);
	
}

/*____________________________________________________________ */

template<class T> double MonolociMeasure<T>::GetTotalKnown(const SNPPos & SNP)
{
double result=sample->genotypeSample->getTotalNonMissing(SNP, marked);
return result;
	
}
/*____________________________________________________________ */



template<class T>	  MonolociMeasure<T>::~MonolociMeasure()
{
zaparr(marked);
}


};  // End of Namespace

#endif

/* End of file: MonolociMeasure.h */




