/* File: MonolociMeasure.h */


#ifndef __MonolociMeasure_h__
#define __MonolociMeasure_h__






namespace BIOS {


/************************/
/* SNP'S MonolociMeasure DEFINITION */
/************************/


/**
        @memo MonolociMeasure for SNPs

	@doc
        Definition:
        A unordered pair of SNPs values for an individual and a genetic position.
        One has been transmitted from the father, one for the mother. Who transmits
        each one of them does not matter.

        Memory space: O(1). 

        @author Maria M. Abad
	@version 1.0
*/


 
template <class T> class MonolociMeasure {


protected:

    /** @name Implementation of class MonolociMeasure
        @memo Private part.
    */

	  BayesType Bayes;
	  T * sample;
	  float alpha;
	
	bool* marked;

/*********************************************************************/
/***     ASSOCIATED FUNCTIONS     ***/
/*********************************************************************/

/* Head */


		/* PUBLIC FUNCTIONS (INTERFACE) */

      public:



      /** @name Operations on MonolociMeasure 
        @memo Operations on a MonolociMeasure 
		  */


		  MonolociMeasure(T * samp, const BayesType & Bay=MLE, const float alpha=0, IndCategory ic=everybody);

	
		  //cout <<"\ntam:" <<sample->PhenotypeSample::size();};
		  
		  
		  double GetTotalFreqAllele(const SNPPos & SNP1, const allele allele1, int distance=0);
		  double GetTotalAllele(const SNPPos & SNP1, const allele allele1, int distance=0);
		  double GetTotalMissing(const SNPPos & SNP1);
		  double GetTotalKnown(const SNPPos & SNP1);
		 
		  
		  ~MonolociMeasure();
		  
};  // End of class MonolociMeasure

template <class T>
ostream& operator<<(ostream& out, MonolociMeasure<T>& pm)
       {
throw NonImplemented("ostream& operator<<(ostream& out, MonolociMeasure<T>& pm)");
return out;
};

};  // End of Namespace

#endif

/* End of file: MonolociMeasure.h */




