/* File: MultimarkerMeasure.h */


#ifndef __MultimarkerMeasure_cpp__
#define __MultimarkerMeasure_cpp__





//using namespace stats;

namespace BIOS {


/**********************************/
/* DEFINITIONS OF THE FUNCTIONS */
/**********************************/



///////////////////
//// public ////////
///////////////////


/*____________________________________________________________ */
/*
template<class T> BidimensionalTable<double>* MultimarkerMeasureHaps<T>::getMultiallelicFreqs(SNPPos a, SNPPos b, int phaseMethod, bool ignoreSameUT)
{

//cout << "\nInside haps for trans " << trans <<": " <<*haps;

BidimensionalTable<double>*result=new BidimensionalTable<double>(totalAlleles[a], totalAlleles[b]); 
int *positions, cont=0;
double freq;
double totalHaplotypes=0;
for (doubleList::iterator pointer=genotypeCounts->Second->begin(); pointer!=genotypeCounts->Second->end(); pointer++)
 totalHaplotypes=totalHaplotypes+haps->Second->getElement(pointer);
for (longLongList::iterator pointer=genotypeCounts->First->begin(); pointer!=genotypeCounts->First->end(); pointer++)
switch (phaseMethod)
{
case 0: // ignore not known
positions=tableHaplotypes->getPositions(haps->First->getElement(pointer));
freq=haps->Second->getElement(cont);
result->addValue(positions[a], positions[b], freq/(double)totalHaplotypes);
zaparr(positions);
cont++;
}
return result;
}


/*____________________________________________________________ */

template<class T> MultimarkerMeasure<T>* MultimarkerMeasure<T>::clone()
{
return new MultimarkerMeasure<T>((MultimarkerMeasure&)*this);
} 
/*_________________________________________________________________*/

template <class T> MultimarkerMeasure<T>::MultimarkerMeasure(MultimarkerMeasure<T>& source)
{
this->tdt=source.tdt;
Bayes=source.Bayes; 
this->alphaBayes=source.alphaBayes;
distance=source.distance;
this->totalPos=source.totalPos;
this->totalGenotypes=source.totalGenotypes;
genotypeFreqs=NULL;
//genotypeAbsFreqsTab=NULL;
genotypeCountsFather=NULL;
genotypeCountsMother=NULL;
totalAlleles=NULL;
allAlleles=NULL;
SNPAbsFreqs=NULL;
SNPFreqs=NULL;
tableGenotypes=NULL;
if (source.genotypeFreqs!=NULL) genotypeFreqs=new HeteroListPair<long long int, double>(*source.genotypeFreqs);
//if (source.genotypeAbsFreqsTab!=NULL) genotypeAbsFreqsTab=new MultidimensionalTable<double>(*source.genotypeAbsFreqsTab);
if (source.genotypeCountsFather!=NULL) genotypeCountsFather=new longLongList(*source.genotypeCountsFather);
if (source.genotypeCountsMother!=NULL) genotypeCountsMother=new longLongList(*source.genotypeCountsMother);


if (source.totalAlleles!=NULL)
{
totalAlleles=new int[totalPos];
for (int i=0; i<totalPos; i++)
 totalAlleles[i]=source.totalAlleles[i];

if (source.allAlleles!=NULL)
{
allAlleles=new allele*[totalPos];
for (int i=0; i<totalPos; i++)
{
 allAlleles[i]=new allele[totalAlleles[i]];
 for (int j=0; j<totalAlleles[i]; j++)
  allAlleles[i][j]=source.allAlleles[i][j];
}
}
if (source.SNPAbsFreqs!=NULL)
{
SNPAbsFreqs=new double*[this->totalPos];
for (int i=0; i<this->totalPos; i++)
{
 SNPAbsFreqs[i]=new double[this->totalAlleles[i]];
 for (int j=0; j<this->totalAlleles[i]; j++) SNPAbsFreqs[i][j]=source.SNPAbsFreqs[i][j];
}
}
if (source.SNPFreqs!=NULL)
{
SNPFreqs=new double*[this->totalPos];
for (int i=0; i<this->totalPos; i++)
{
 SNPFreqs[i]=new double[this->totalAlleles[i]];
 for (int j=0; j<this->totalAlleles[i]; j++)
  SNPFreqs[i][j]=source.SNPFreqs[i][j];
}
}
}
if (source.tableGenotypes!=NULL) tableGenotypes=new AmbiguousArray(*source.tableGenotypes);

}
/*_________________________________________________________________*/

template <class T> MultimarkerMeasure<T>::MultimarkerMeasure(SNPPos Pos[], SNPPos TotalPos,  T * samp,  int gender, int affectation, BayesType Bay, float alphaBayes, float dist, bool tdt)
{
genotypeFreqs=NULL;
genotypeCountsFather=NULL;
genotypeCountsMother=NULL;
totalAlleles=NULL;
allAlleles=NULL;
tableGenotypes=NULL;
//genotypeAbsFreqsTab=NULL;
set (Pos, TotalPos, samp, gender, affectation, Bay, alphaBayes, dist, mode, tdt);
}

/*_________________________________________________________________*/

template <class T> MultimarkerMeasure<T>::MultimarkerMeasure()
{
genotypeFreqs=NULL;
genotypeCountsFather=NULL;
genotypeCountsMother=NULL;
totalAlleles=NULL;
allAlleles=NULL;
tableGenotypes=NULL;
//genotypeAbsFreqsTab=NULL;
SNPAbsFreqs=NULL;
SNPFreqs=NULL;
}
/*_______________________________________________________________*/

template <class T> void MultimarkerMeasure<T>::empty()
{
zap(genotypeCountsFather);
zap(genotypeCountsMother);
zap(genotypeFreqs);
//zap(genotypeAbsFreqsTab);
zaparr(totalAlleles);


for (int i=0; i<totalPos; i++)
{
if (allAlleles!=NULL) zaparr(allAlleles[i]);
if (SNPAbsFreqs!=NULL) zaparr(SNPAbsFreqs[i]);
if (SNPFreqs!=NULL) zaparr(SNPFreqs[i]);
}

zaparr(allAlleles);
zaparr(SNPAbsFreqs);
zaparr(SNPFreqs);
zap(tableGenotypes);
}

/*_______________________________________________________________*/

template <class T> void MultimarkerMeasure<T>::setGenotypeAbsFreqs()
{
intList* dimList=new intList();
for (int i=0; i<this->totalPos; i++)
 dimList->insertElement(getTotalGenotypes(totalAlleles[i]));

zap(genotypeAbsFreqsTab);
genotypeAbsFreqsTab=new MultidimensionalTable<double>(dimList);
zap(dimList);
longLongList::iterator it;
int cont=0;
for (it=this->genotypeFreqs->First->begin(); it<genotypeFreqs->First->end(); it++)
{
genotypeAbsFreqsTab->setValue(genotypeFreqs->First->getElement(it), genotypeFreqs->Second->getElement(cont));
cont++;
}
}

/*_________________________________________________________________*/

template <class T> void MultimarkerMeasure<T>::set(SNPPos Pos[], SNPPos totalPos, T * samp, int gender, int affectation, BayesType Bay, float alphaBayes, float dist, bool tdt)
{
this->tdt=tdt;
Bayes=Bay; 
this->alphaBayes=alphaBayes;
distance=dist;
this->totalPos=totalPos;
set(samp, gender, affectation, Pos);
}
/*_______________________________________________________________*/

template <class T> void MultimarkerMeasure<T>::setGenotypeTable()
{
intList* dimList=new intList();
for (int i=0; i<totalPos; i++)
 dimList->insertElement(getTotalGenotypes(totalAlleles[i]));

tableGenotypes=new AmbiguousArray(dimList);
zap(dimList);
}
/*_______________________________________________________________*/

template <class T> longLongList* MultimarkerMeasure<T>::permuteInParent(bool father)
{
long int value, value2;
int transmitted;
longLongList* result=new longLongList(), *temp;
if (father) 
temp=genotypeCountsFather;
else temp=genotypeCountsMother;
for (longLongList::iterator it=temp->begin(); it<temp->end(); it++)
{
value=temp->getElement(it);
transmitted=ranbinom(1, 0.5);
if (transmitted)
{
result->insertElement(value);
}
else
{
value2=tableGenotypes->changePhase(value);
result->insertElement(value2);
//cout << "\npermutation: orig:"  << value << "new:" << value2;
}
}
return result;
}

/*___________________________________________________________________________________________________*/

template <class T> void MultimarkerMeasure<T>::setSNPFreqs()
{
SNPAbsFreqs=new double*[totalPos];
SNPFreqs=new double*[totalPos];
int al1, al2;

double totalSNP=0, freq=0;
for (int i=0; i<totalPos; i++)
{
 SNPAbsFreqs[i]=Initialize(totalAlleles[i], 0.0);
 SNPFreqs[i]=Initialize(totalAlleles[i], 0.0);
}
int i=0, *position;
//cout <<"hapcunts:" << *this->haplotypeCounts;
for (longLongList::iterator it=genotypeFreqs->First->begin(); it<genotypeFreqs->First->end(); it++)
{
position=tableGenotypes->getPositions(genotypeFreqs->First->getElement(it));
for (int j=0; j<totalPos; j++)
{
 al1=getAllelePos(position[j], j, true, tableGenotypes);
 al2=getAllelePos(position[j], j, false, tableGenotypes);
 this->SNPAbsFreqs[j][al1]=SNPAbsFreqs[j][al1]+genotypeFreqs->Second->getElement(i);
 this->SNPAbsFreqs[j][al2]=SNPAbsFreqs[j][al2]+genotypeFreqs->Second->getElement(i);
 this->SNPFreqs[j][al1]= SNPFreqs[j][al1]+genotypeFreqs->Second->getElement(i)/(totalGenotypes*2);
 this->SNPFreqs[j][al2]= SNPFreqs[j][al2]+genotypeFreqs->Second->getElement(i)/(totalGenotypes*2);
}
zaparr(position);
i++;
}
}
/*_______________________________________________________________*/
/*
template <class T> longLongList* MultimarkerMeasure<T>::updatePermutationsInChildren(longLongList* genotypeCountsFather, longLongList* genotypeCountsMother)
{
// It updates the permutations in the children
longLongList* result=new longLongList();
long int valueMother, valueFather, valueChild;
int alMother, alFather, *positionsFather, *positionsMother, *positionsChild;
for (int cont=0; cont<genotypeCountsFather->size(); cont++)
{
valueMother=genotypeCountsMother->getElement(cont);
valueFather=genotypeCountsFather->getElement(cont);
positionsFather=tableGenotypes->getPositions(valueFather);
positionsMother=tableGenotypes->getPositions(valueMother);
positionsChild=tableGenotypes->getPositions(valueChild);
for (int i=0; i<totalPos; i++)
if (tableGenotypes->isAKnownPosition (positionsFather[i], i)) 
if (tableGenotypes->isAPositionWithDifferentValues(positionsFather[i], i) || tableGenotypes->isAPositionWithDifferentValues(positionsMother[i], i)) 
{
alFather=tableGenotypes->getKnownValue (positionsFather[i], i, true);
alMother=tableGenotypes->getKnownValue (positionsMother[i], i, true);
positionsChild[i]=tableGenotypes->getAmbiguousPos (alFather, alMother, i);
}
valueChild=tableGenotypes->getPos(positionsChild);
zaparr(positionsFather);
zaparr(positionsMother);
zaparr(positionsChild);
result->insertElement(valueChild);
}
return result;
}
/*_______________________________________________________________*/

template <class T> MultimarkerMeasure<T>* MultimarkerMeasure<T>::getPermutation()
{
if (Bayes!=MLE) throw BadFormat("MultimarkerMeasure<T>::getPermutation()");
longLongList
* tempGenotypeCountsFather=permuteInParent(true),
* tempGenotypeCountsMother=permuteInParent(false);


MultimarkerMeasure<T>* result=clone();
zap(result->genotypeCountsFather);
zap(result->genotypeCountsMother);
result->genotypeCountsFather=tempGenotypeCountsFather;
result->genotypeCountsMother=tempGenotypeCountsMother;
if (Bayes!=MLE && alphaBayes!=0) result->addBayes();
zap(result->genotypeFreqs);
//zap(result->genotypeAbsFreqsTab);
result->setGenotypeFreqs();
//result->setGenotypeAbsFreqs();
return result;
}
/*_______________________________________________________________*/

template <class T> void MultimarkerMeasure<T>::setTotalGenotypes()
{
totalGenotypes=0;
for (doubleList::iterator it=genotypeFreqs->Second->begin(); it<genotypeFreqs->Second->end(); it++)
 totalGenotypes=totalGenotypes+genotypeFreqs->Second->getElement(it);
}

/*_______________________________________________________________*/

template <class T> void MultimarkerMeasure<T>::addBayes(HeteroListPair<long long int, double>* list, MultidimensionalEmptyTable<int>* table, double totalElements, BayesType Bayes, float alpha, float distance)
{
double freq;
for (long long int i=0; i<table->getSize(); i++)
{
freq=AddBayesGen(0, Bayes, distance, alpha, (int)totalElements);
list->addValue(i, freq);
}


}

/*_______________________________________________________________*/

template <class T> void MultimarkerMeasure<T>::addBayes()
{
addBayes(genotypeFreqs, tableGenotypes, totalGenotypes, Bayes, alphaBayes, distance);
setTotalGenotypes();
}
/*_________________________________________________________________*/

template <class T> void MultimarkerMeasure<T>::set(T* sample, int gender, int affectation, int* pos)
{
setAlleles(sample, pos);
setGenotypeTable();
setCounters(sample, gender, affectation, pos);
if (Bayes!=MLE && alphaBayes!=0) addBayes();
setGenotypeFreqs();
setGenotypeAbsFreqs();
setSNPFreqs();
}

/*_________________________________________________________________*/

template <class T> void MultimarkerMeasure<T>::setCounters(T* sample, int gender, int affectation, int* pos)
{
sample->setMarked(parent, gender, affectation);
}
/*_________________________________________________________________*/

template <class T> void MultimarkerMeasure<T>::setAlleles(T* sample, int* pos)
{

totalAlleles=Initialize(totalPos, 0);
//cout <<"totalpos is:" << totalPos <<"\n";;

allAlleles=new allele*[totalPos];
for (int i=0; i<totalPos; i++)
{
//cout << "\npos at " << i << ": " << pos[i];
 totalAlleles[i]=sample->genotypeSample->totalAlleles[pos[i]];
//cout << "\nptotal " << i << ": " << totalAlleles[pos[i]];
 allAlleles[i]=new allele[totalAlleles[i]];
for (int j=0; j<totalAlleles[i]; j++)
 allAlleles[i][j]=sample->genotypeSample->allAlleles[pos[i]][j];
}
}
/*____________________________________________________________ */

template<> MultimarkerMeasure<TrioSample>* MultimarkerMeasure<TrioSample>::convertToKnownGenotypes (MultidimensionalTable<double>* haplotypeFreqsTab, MultidimensionalTable<double>* haplotypeFreqsTabU)
{
MultimarkerMeasure<TrioSample>* result=clone();
zap(result->genotypeCountsFather);
zap(result->genotypeCountsMother);
zap(result->genotypeFreqs);
//zap(result->genotypeAbsFreqsTab);
result->genotypeCountsFather=new longLongList();
result->genotypeCountsMother=new longLongList();
long long int valueFather, valueMother;
int *fatherPositions, *motherPositions, *hap1, *hap2, *hap3, *hap4, maxPos;
double totalFreqs, maxFreq;
long long int totalCompatibleHaplotypePairs;
for (int cont=0; cont<genotypeCountsFather->size(); cont++)
{
 valueFather=genotypeCountsFather->getElement(cont);
 valueMother=genotypeCountsMother->getElement(cont);
motherPositions=tableGenotypes->getPositions(valueMother);
fatherPositions=tableGenotypes->getPositions(valueFather);
totalCompatibleHaplotypePairs=tableGenotypes->getTotalSolvedConfs(fatherPositions);
maxFreq=0;
for (int i=0; i<totalCompatibleHaplotypePairs; i++)
{
hap1=tableGenotypes->getSolvedConf(fatherPositions, i, true);
hap2=tableGenotypes->getSolvedConf(fatherPositions, i, false);
hap3=new int[totalPos];
hap4=new int[totalPos];
for (int j=0; j<totalPos; j++) 
{
if (tableGenotypes->isAKnownPosition(motherPositions[j], j) && !tableGenotypes->isAPositionWithDifferentValues(motherPositions[j], j)) // mother is homozygotic
{
 for (int k=0;k<totalAlleles[j]; k++)
{
  if ( tableGenotypes->getKnownValue (motherPositions[j], j, true)==k) {hap3[j]=k;hap4[j]=k;}
}
}
else {hap3[j]=hap2[j];hap4[j]=hap1[j];}// phase has to be solved consistently with the father
}
totalFreqs=haplotypeFreqsTab->getValue(hap1)*haplotypeFreqsTabU->getValue(hap2)*haplotypeFreqsTab->getValue(hap3)*haplotypeFreqsTabU->getValue(hap4);
if (totalFreqs>maxFreq)
{
maxFreq=totalFreqs;
maxPos=i;
}
zaparr(hap1); zaparr(hap2); zaparr(hap3); zaparr(hap4);
}
hap1=tableGenotypes->getSolvedConf(fatherPositions, maxPos, true);
hap2=tableGenotypes->getSolvedConf(fatherPositions, maxPos, false);
hap3=tableGenotypes->getSolvedConf(motherPositions, maxPos, true);
hap4=tableGenotypes->getSolvedConf(motherPositions, maxPos, false);
for (int j=0; j<totalPos; j++) 
{
fatherPositions[j]=tableGenotypes->getAmbiguousPos (hap1[j], hap2[j], j);
motherPositions[j]=tableGenotypes->getAmbiguousPos (hap3[j], hap4[j], j);
}
valueMother=tableGenotypes->getPos(motherPositions);
valueFather=tableGenotypes->getPos(fatherPositions);
zaparr(motherPositions);
zaparr(fatherPositions);
result->genotypeCountsFather->insertElement(valueFather);
result->genotypeCountsMother->insertElement(valueMother);
}
if (Bayes!=MLE && alphaBayes!=0) result->addBayes();
result->setGenotypeFreqs();
//result->setGenotypeAbsFreqs();
result->setSNPFreqs();
return result;
}
/*____________________________________________________________ */

template<> void MultimarkerMeasure<TrioSample>::setCounters (TrioSample* sample, int gender, int affectation, int*pos)
{
genotypeCountsFather=sample->getGenotypeCounts(pos, totalPos, father, gender, affectation, tableGenotypes);
genotypeCountsMother=sample->getGenotypeCounts(pos, totalPos, mother, gender, affectation, tableGenotypes);
}
/*____________________________________________________________ */

template <class T> void MultimarkerMeasure<T>::setGenotypeFreqs ()
{
longLongList* p;
genotypeFreqs=new HeteroListPair<long long int, double>();
long long int pos;
totalGenotypes=0;
for (int i=0; i<2;i++)
{
switch (i)
{
case 0: p=genotypeCountsFather; break;
case 1: p=genotypeCountsMother; break;
}
for (longLongList::iterator it=p->begin(); it<p->end(); it++)
{
pos=p->getElement(it);
if (pos>-1)
{
//if (!tdt || !tableGenotypes->hasSameValues (pos))
{
genotypeFreqs->addValue(pos, 1);
totalGenotypes=totalGenotypes+1;
}
}
}
};
}

/*____________________________________________________________ */

/*
template<class T> bool MultimarkerMeasure<T>::isSNP (SNPPos i)
{
int total=0;
for (int j=0; j<totalAlleles[i]; j++)
 if (SNPFreqs[i][j]>0) total++;

return total>1;
}
*/


};  // End of Namespace

#endif

/* End of file: MultimarkerMeasure.h */




