/* File: PairGenotype.h */


#ifndef __PairSNPGenotype_h__
#define __PairSNPGenotype_h__



namespace BIOS {


/************************/
/* SNP'S GENOTYPE DEFINITION */
/************************/


/**
        @memo Genotype for SNPs

	@doc
        Definition:
        A unordered pair of SNPs values for an individual and a genetic position.
        One has been transmitted from the First, one for the Second. Who transmits
        each one of them does not matter.

        Memory space: O(1). 

        @author Maria M. Abad
	@version 1.0
*/


 
class PairSNPGenotype {


protected:
    /** @name Implementation of class Genotype
        @memo Private part.
    */
	

 Diplotype firstGenotype, secondGenotype;

// GenotypePointer FirstGenotypePointer, SecondGenotypePointer;
   
/**
   @memo Pointer to the array of snps. It's NULL if snps has not been assigned yet.
*/


/*********************************************************************/
/***     ASSOCIATED FUNCTIONS     ***/
/*********************************************************************/

/* Head */


		/* PUBLIC FUNCTIONS (INTERFACE) */

      public:



      /** @name Operations on Genotype 
        @memo Operations on a Genotype 
    */

      /**
         @memo Constructor 
         @doc
          Allocate memory an initialize to null.
          Complexity O(1).

      */



		        /**
         @memo Copy constructor
         @param destino: Genotype where will be copy
         @param origen: Genotype to copy
         @doc
           Make a copy of Genotype
           Time complexity in time O(1).

		 */

  		  PairSNPGenotype ();

		  PairSNPGenotype (PairSNPGenotype * Source);

		  PairSNPGenotype (Diplotype Source1, Diplotype Source2);


 

	  Diplotype getFirstGenotype ();

	  Diplotype getSecondGenotype ();


	/**
         @memo Check if a pair of genotypes (used for parents) is homozygous for wild-type allele
         @param position: pointers to the genotypes to check,
         alleles to check homozygosity.
         @return bool 
         @doc Return a false if at least one of the genotype snp is not homozygous wild-type
         (it can be missing, homozygous mutant or heterozygous).
         return a true if both the genotypes snp are homozygous wild-type.
         Complexity O(1).
      */
        bool IsHomozygous1Homozygous1 (allele  MajorAllele);      

		
	/**
         @memo Check if a pair of genotypes (used for parents) is homozygous for mutant allele
         @param position: pointers to the genotypes to check,
         alleles to check homozygosity.
         @return bool 
         @doc Return a false if at least one of the genotype snp is not homozygous mutant
         (it can be missing, homozygous wild-type or heterozygous).
         return a true if both the genotypes snp are homozygous mutant.
         Complexity O(1).
      */
        bool IsHomozygous2Homozygous2 (allele  MajorAllele);      

				
	/**
         @memo Check if a pair of genotypes (used for parents) is homozygous for different types
         @param position: pointers to the genotypes to check,
         alleles to check homozygosity1 and homozygosity2.
         @return bool 
         @doc Return a false they are not homozygous1 and homozygous2 
         return a true if one genotype snp is homozygous wild-type and the other mutant.
         Complexity O(1).
      */
        bool IsHomozygous1Homozygous2 (allele  MajorAllele);      

	/**
         @memo Check if a pair of genotypes (used for parents) are homozygous1 and heterozygous
         @param position: pointers to the genotypes to check,
         alleles to check homozygosity1 and heterozygosity.
         @return bool 
         @doc Return a false they are not homozygous1 and heterozygous 
         return a true if one genotype snp is homozygous wild-type and the other heterozygous.
         Complexity O(1).
      */
        bool IsHomozygous1Heterozygous (allele  MajorAllele);      

		/**
         @memo Check if a pair of genotypes (used for parents) are homozygous2 and heterozygous
         @param position: pointers to the genotypes to check,
         alleles to check homozygosity2 and heterozygosity.
         @return bool 
         @doc Return a false they are not homozygous2 and heterozygous 
         return a true if one genotype snp is homozygous mutant and the other heterozygous.
         Complexity O(1).
      */
        bool IsHomozygous2Heterozygous (allele  MajorAllele);      

		/**
         @memo Check if a pair of genotypes (used for parents) are homozygous(1 or 2) and heterozygous
         @param position: pointers to the genotypes to check,
         alleles to check homozygosity2 and heterozygosity.
         @return bool 
         @doc Return a false they are not homozygous2 and heterozygous 
         return a true if one genotype snp is homozygous mutant and the other heterozygous.
         Complexity O(1).
      */
        bool IsHomozygousHeterozygous (allele  MajorAllele);      


			/**
         @memo Check if a pair of genotypes (used for parents) are heterozygous
         @param position: pointers to the genotypes to check,
         alleles to check heterozygosity.
         @return bool 
         @doc Return a false they are not heterozygous 
         return a true if both are heterozygous.
         Complexity O(1).
      */
        bool IsHeterozygousHeterozygous (allele  MajorAllele);      

	/**
         @memo Check if a pair of genotypes (used for parents) are both missing
         @param position: pointers to the genotypes to check,
         alleles to check double missingness.
         @return bool 
         @doc Return a false they if at least one is not missing 
         return a true if both genotypes at SNP are missing.
         Complexity O(1).
      */
        bool IsMissingMissing (allele  MajorAllele);      

	/**
         @memo Check if a pair of genotypes (used for parents) are one homozygous wild-type the other missing
         @param position: pointers to the genotypes to check,
         alleles to check one missing, the other homozygous wild-type.
         @return bool 
         @doc Return a true if one genotype at SNP is missing and the other homozyogus wild-type.
		 Otherwise return false
         Complexity O(1).
      */
        bool IsHomozygous1Missing (allele  MajorAllele);      


		/**
         @memo Check if a pair of genotypes (used for parents) are one homozygous mutant the other missing
         @param position: pointers to the genotypes to check,
         alleles to check one missing, the other homozygous mutant.
         @return bool 
         @doc Return a true if one genotype at SNP is missing and the other homozyogus mutant.
		 Otherwise return false
         Complexity O(1).
      */
        bool IsHomozygous2Missing (allele  MajorAllele);      

	
		/**
         @memo Check if a pair of genotypes (used for parents) are one heterozygous and the other missing
         @param position: pointers to the genotypes to check,
         alleles to check one missing, the other heterozygous.
         @return bool 
         @doc Return a true if one genotype at SNP is missing and the other heterozyogus.
		 Otherwise return false
         Complexity O(1).
      */
        bool IsHeterozygousMissing (allele  MajorAllele);      


	
};  // End of class Genotype



};  // End of Namespace

#endif

/* End of file: PairGenotype.h */




