/* File: PairwiseCI.h */


#ifndef __PairwiseCI_h__
#define __PairwiseCI_h__





//using namespace stats;

namespace BIOS {


/************************/
/* SNP'S PairwiseCI DEFINITION */
/************************/


/**
        @memo PairwiseCI for SNPs

	@doc
        Definition:
        A unordered pair of SNPs values for an individual and a genetic position.
        One has been transmitted from the father, one for the mother. Who transmits
        each one of them does not matter.

        Memory space: O(1). 

        @author Maria M. Abad
	@version 1.0
*/


 
class PairwiseCI {


protected:

    /** @name Implementation of class PairwiseCI
        @memo Private part.
    */

map<long long int, float>* upperBound, *lowerBound;

       
/*********************************************************************/
/***     ASSOCIATED FUNCTIONS     ***/
/*********************************************************************/

/* Head */




		/* PUBLIC FUNCTIONS (INTERFACE) */

      public:



      /** @name Operations on PairwiseCI 
        @memo Operations on a PairwiseCI 
    */
	PairwiseCI(GenomaSample * sample, Positions* pos, double width, BayesType  Bay=MLE, float alphaBayes=0, bool *listOfUsedSNPs=NULL, SNPPos firstSNP=0, SNPPos lastSNP=-1);


	~PairwiseCI();



    map<long long int, float>* getUpperBound();
    map<long long int, float>* getLowerBound();
       

};  // End of class PairwiseCI

ostream& operator<<(ostream& out, PairwiseCI& pm)
       {
   
 out << pm.getUpperBound() <<", " << pm.getLowerBound() <<"\n";

return out;
};



};  // End of Namespace

#endif

/* End of file: PairwiseCI.h */




