/* File: PairwiseMeasure.h */


#ifndef __PairwiseMeasure_h__
#define __PairwiseMeasure_h__





//using namespace stats;

namespace BIOS {


/************************/
/* SNP'S PairwiseMeasure DEFINITION */
/************************/


/**
        @memo PairwiseMeasure for SNPs

	@doc
        Definition:
        A unordered pair of SNPs values for an individual and a genetic position.
        One has been transmitted from the father, one for the mother. Who transmits
        each one of them does not matter.

        Memory space: O(1). 

        @author Maria M. Abad
	@version 1.0
*/


 
template <class T> class PairwiseMeasure: public MultiallelicPairwiseMeasure {


protected:

    /** @name Implementation of class PairwiseMeasure
        @memo Private part.
    */
/*
	  BayesType Bayes;

	  float alphaBayes;

	  IndCategory ic;

	  int affectation, gender; 

	  T * sample;
*/
   double nAB, nAb, naB, nab, nHH, fA, fB, fAB;

	  //SNPPos SNP1, SNP2;

	//  char *line;
/*
	  bool missing, recomb, partiallySolved, knownPhase;

	  int mode;
// in trios, mode=1 means to use partially solved
// in unrelated, mode=1 means phase is known

	  float distance;

   Transmission transmission;
*/
//bool* Marked;

       
/*********************************************************************/
/***     ASSOCIATED FUNCTIONS     ***/
/*********************************************************************/

/* Head */

    double GetnxyKnown(bool IsMajor1, bool IsMajor2);


	void CheckFrequency (double f, bool fa);


		/* PUBLIC FUNCTIONS (INTERFACE) */

      public:



      /** @name Operations on PairwiseMeasure 
        @memo Operations on a PairwiseMeasure 
    */
	PairwiseMeasure(SNPPos* pos,  T * samp, IndCategory ic=everybody, int gender=everyGender, int affectation=allAffectation, BayesType  Bay=MLE, float alphaBayes=0, float distance=0.0, AlleleOrderType mode=MajorFirst, bool recomb=false, Transmission transmission=ut);


//	void set(SNPPos SNP1, SNPPos SNP2, T * samp, IndCategory ic=everybody, int gender=everyGender, int affectation=allAffectation, BayesType  Bay=MLE, float alphaBayes=0.0, float distance=0.0, int mode=0, bool recomb=false, Transmission transmission=ut);

	PairwiseMeasure(T * samp);

	~PairwiseMeasure()
	{
	//zap(line);
	};

        void recombine(int trioPos, IndCategory ic, double fABWithoutUsingChildren=-1);

        void recombine(Genoma* G, double fABWithoutUsingChildren);


        void recombineAll(double fABWithoutUsingChildren);

	
	double GetTotalUnKnown ();

	double GetTotalKnown();

	//double GetTotalKnown(double nAB, double nAb, double naB, double nab);

	double GetfAB();

	double GetfABNoEM();

    double GetnA();

	double GetnB();
	
    double Getna();

	double Getnb();

	double GetfA();

	double GetfB();

	double GetnAB();

	double GetnAb();

	double GetnaB();
	
	double Getnab();

	double getDPrime();

 double getCompositeLD();

 double getStandardizedCompositeLD();

	void setfA();

	void setfB();

	double setfAB();

	double getD();

        int GetAllelePair();

	int getTotalDifferentHaplotypes();

	//IndPos SetBootstrapFrequenciesOld(double *DPrimeList, unsigned long int size);

	IndPos SetBootstrapFrequencies(double* AbsDPrimeList, unsigned long int size);

	IndPos SetBootstrapFrequenciesFast(double* AbsDPrimeList, unsigned long int size);

	void GetSampleFrequencies(IndPos & bnAB, IndPos & bnAb,IndPos & bnaB,IndPos & bnab);

	void SetDPrimeDistribution();

	void SetDDistribution();

	double GetMaxDPrime();

	double getR2();
	
	double getYuresQ();

	double GetQuantileDPrime (float quantile);

	char* PrintHaplotypeFrequencies();

	//void InitializeMarkers();

	void set();

double getConditionalEntropy(bool disease0_sex1);

double getSimilarityMeasure ();

//double getDelta ();

double getMaxDelta (bool positiveDelta);

//double getStandardizedCompositeLD ();

double getSignedRankTest();

double getStandardizedSimilarityMeasure();


//CPT* getCPT(bool disease0-sex1);

};  // End of class PairwiseMeasure

template <class T> ostream& operator<<(ostream& out, PairwiseMeasure<T>& pm)
       {
   
 out << pm.GetnA() <<", " << pm.GetnB()  <<", " << pm.GetTotalKnown() <<", " << pm.GetTotalUnKnown()  <<", " << pm.GetnAB() <<"\n";

return out;
};



};  // End of Namespace

#endif

/* End of file: PairwiseMeasure.h */




