#ifndef __PairwiseMeasuresResults_h__
#define __PairwiseMeasuresResults_h__






namespace BIOS
{


 /************************/
 /* SNP'S MultiallelicPairwiseMeasuresResults DEFINITION */
 /************************/


 /**
         @memo MultiallelicPairwiseMeasuresResults for SNPs
  
  @doc
   
  
  
         @author Maria Mar Abad
  @version 1.0
 */
class TrioSample;

 template<class T> class PairwiseMeasuresResults
 {
  private:
bool printLogs;
   char line[1024];
   char filename[1024],fileSelection[1024],*fileLogs;
   float MAF;
   BayesType BayesMode;
   IndCategory ic;
//   int phase;
   bool invariant,Selection;
   float alpha,alphaBayes;
   AlleleOrderType AlleleOrderMode;
   double fAB,fA,fB,AvDPrime,MaxDPrime;
   T *gs,*gs2;
   char filepos[1024];
   double upperbound,lowerbound,MLDPrime,YulesQ,r2,DPrime;
   Positions* Pos;
   Table2x2 T2x2;
   Pair<double> pair;
   SNPPos SNP2,SNP3,TotalSNPs,total;
   double firstPosition,lastPosition;
   MonolociMeasure<T>* MM ;
   MonolociMeasure<T>* MM2;
   //bool* Marked;
   bool onlyConsecutives;
   long totalPairs;
   ofstream logs;
		PhaseAlg phaseAlg;

GenomaSample* wholeSample;

  public:
   char* PrintHeading ( int type,bool basic=true );
   char* PrintConfiguration();
   PairwiseMeasuresResults ( char filenam[1024],char *filelogs,float maf,BayesType BayesMod,float alphaBayes,bool onlyConsecutives,IndCategory i,AlleleOrderType AlleleOrderMod, PhaseAlg phaseAlg, float alph=90,bool invarian=false,double firstPosition=0,double lastPosition=0,char* filesel=NULL );
   void PrintClassicPairwisesMeasures ( char filename2[1024], bool PrintConf=true,double MaximumDistance=500000,bool basic=true );
   void PrintClassicPairwisesMeasuresInside1 ( double MaximumDistance=500000,bool basic=true );
   void PrintClassicPairwisesMeasuresInside2 ( Positions::iterator p,int SNP,double MaximumDistance=500000,bool basic=true );
   void printLDDecay ( char filename2[1024],double MaximumDistance,SNPPos SlideSize,SNPPos SlideOverlap,bool PrintConf );
   void printSlidingWindows ( char filename2[1024],double MaximumDistance,SNPPos SlideSize,SNPPos SlideOverlap,bool PrintConf );
   void PrintLD ( MultiallelicPairwiseMeasure *PM,Positions::iterator p,Positions::iterator p2,int SNP,int SNP2,double MaximumDistance,bool basic, MonolociMeasure<T>* MM, double totalHaplotypes);
   char* setCommon ( int type,char filename2[1024],bool PrintConf,double& MaximumDistance,bool basic=true );
   bool isInside ( double position );
   string getAverageResults();
//    void printGenotypeAssociation(GenotypeMultiallelicPairwiseMeasure<T> *PM,Positions::iterator p,Positions::iterator p2,int SNP,int SNP2,double MaximumDistance,bool basic);
   ~PairwiseMeasuresResults();
};


}
;  // End of Namespace

#endif

/* End of file: PairwiseMeasuresResults.h */



