/* File: Phenotype.cpp */


#ifndef __Phenotype_cpp__
#define __Phenotype_cpp__



#include "Phenotype.h"



namespace BIOS
{



	/**********************************/
	/* DEFINITIONS OF THE FUNCTIONS */
	/**********************************/


//


///////////////////
//// public ////////
///////////////////


int Phenotype::inputFormat=1;

	/*________________________________________________________________________________________*/


	/*____________________________________________________________ */

	Phenotype::Phenotype ( const PhenotypeS & PS )
	{
		phenotype=PS;
	}
	/*____________________________________________________________ */

	Phenotype* Phenotype::clone()
	{
		return new Phenotype ( *this );
	}

	/*____________________________________________________________ */

	bool Phenotype::isMale ()
	{
		return phenotype.Gender==1;
	}
	/*____________________________________________________________ */

	bool Phenotype::isFemale ()
	{
		return phenotype.Gender==2;
	}
	/*____________________________________________________________ */

	bool Phenotype::isAChild ()
	{
		return phenotype.Father!=string("0") || phenotype.Mother!=string("0");
	}
	/*____________________________________________________________ */

	bool Phenotype::isAParent ( PhenotypeSample * sample )
	{
		return isAFather ( sample ) || isAMother ( sample );
	}
	/*____________________________________________________________ */

	bool Phenotype::isAMother ( PhenotypeSample * sample )
	{
		return isAFounder ( sample ) && isFemale();
	}
	/*____________________________________________________________ */

	bool Phenotype::isAFather ( PhenotypeSample * sample )
	{
		return isAFounder ( sample ) && isMale();
	}
	/*____________________________________________________________ */

	bool Phenotype::isUnrelated ( PhenotypeSample * sample )
	{
		return !isAFounder ( sample ) && !isAChild();
	}
	/*____________________________________________________________ */

	bool Phenotype::isARelative ( PhenotypeSample * sample )
	{
		return isAFounder ( sample ) || isAChild();
	}
	/*____________________________________________________________ */

	bool Phenotype::isAFounder ( PhenotypeSample * sample )
	{
// it is not a child (does not have parents) and does have offspring
		return !isAChild() && hasOffspring ( sample );
	}
	/*____________________________________________________________ */

	bool Phenotype::hasOffspring ( PhenotypeSample* sample )
	{
		Phenotype * p;
		for ( PhenotypeSample::iterator it=sample->begin(); it!=sample->end(); it++ )
		{
			p=*it;
			if ( p->getPedigree() ==this->getPedigree() && ( p->getFather() ==this->getCode() || p->getMother() ==this->getCode() ) )  return true;
		}
		return false;
	}
	/*____________________________________________________________ */

	IndCategory Phenotype::getIndCategory ( PhenotypeSample * sample )
	{
		IndCategory result;
		if ( isAFather ( sample ) ) return father;
		if ( isAMother ( sample ) ) return mother;
		if ( isAChild() ) return offspring;
		return unrelated;
	}

	/*____________________________________________________________ */

	bool Phenotype::isAffected ()
	{
		return phenotype.isAffected();
	}
	/*____________________________________________________________ */

	affectation Phenotype::getAffectation ()
	{
		return phenotype.getAffectation();
	}

	/*____________________________________________________________ */

	string Phenotype::PrintPhenotype ()
	{
//strcpy(line,"\0");
//cout <<"j";
//exit(0);
		char line[100]="\0";
//cout <<phenotype.Code;// << phenotype.Code;// << phenotype.Father << phenotype.Mother;
//phenotype.Gender, phenotype.Affectation, phenotype.Code2;
//exit(0);
		sprintf ( line, "%s %s %s %s %d %d %s", phenotype.Pedigree.c_str(), phenotype.Code.c_str(), phenotype.Father.c_str(), phenotype.Mother.c_str(),
		          phenotype.Gender, phenotype.getAffectation(), phenotype.Code2.c_str() );
		string p=string ( line );
		return p;
	}
	/*____________________________________________________________ */

	string Phenotype::printPhenotypeInMakePed ()
	{
//strcpy(line,"\0");
//cout <<"j";
//exit(0);
		char line[100]="\0";
//cout <<phenotype.Code;// << phenotype.Code;// << phenotype.Father << phenotype.Mother;
//phenotype.Gender, phenotype.Affectation, phenotype.Code2;
//exit(0);
		sprintf ( line, "%s %s %s %s %d %d", phenotype.Pedigree.c_str(), phenotype.Code.c_str(), phenotype.Father.c_str(), phenotype.Mother.c_str(),
		          phenotype.Gender, phenotype.getAffectation() );
		string p=string ( line );
		return p;
	}
	/*____________________________________________________________ */

	void Phenotype::SetPhenotype ( const PhenotypeS & PS )
	{
		phenotype=PS;
	}


	/*____________________________________________________________ */

	bool  Phenotype::operator> ( Phenotype & phe )
	{
		return ( ( phenotype.Pedigree==phe.getPedigree() && phenotype.Code>phe.getCode() ) || phenotype.Pedigree>phe.getPedigree() );
	}
	/*____________________________________________________________ */

	bool  Phenotype::operator< ( Phenotype & phe )
	{
		return ( ( phenotype.Pedigree==phe.getPedigree() && phenotype.Code<phe.getCode() ) || phenotype.Pedigree<phe.getPedigree() );
	}
	/*____________________________________________________________ */

	bool  Phenotype::operator== ( Phenotype & phe )
	{
		return ( phenotype.Pedigree==phe.getPedigree() && phenotype.Code==phe.getCode() );
	}
	/*____________________________________________________________ */

void  Phenotype::setInputFormat(int inputFormat)
{
Phenotype::inputFormat=inputFormat;
}

	/*___________________________________________________________ */

	Phenotype* Phenotype::fromString ( string s )
	{
		Phenotype::PhenotypeS pS;
		char pedigree[256], code[256], father[256], mother[256], code2[256];
		int pos;

		/*
		sscanf(s.c_str(), "%s%s%s%s%d%d%s", &(pedigree), &(code), &(father), &(mother), 	&(pS.Gender), &(pS.Affectation), &(code2));



			pos=findFirstDigit(string(pedigree));
			pS.Pedigree=atoi(&pedigree[pos]);
			pos=findFirstDigit(string(code));
			pS.Code=atoi(&code[pos]);
			pos=findFirstDigit(string(father));
			pS.Father=atoi(&father[pos]);
		  pos=findFirstDigit(string(mother));
			pS.Mother=atoi(&mother[pos]);
			pos=findFirstDigit(string(code2));
			pS.Code2=atoi(&code2[pos]);
		*/

char affect[256], gend[256];
switch (inputFormat)
{
case 1: // extended makeped
		sscanf ( s.c_str(), "%s%s%s%s%s%s%s", (char*)& ( pedigree ), (char*)& ( code ), (char*)& ( father ), (char*)& ( mother ), (char*)& gend, (char*)& affect,  (char*)& ( code2 ) );break;
case 0: // make ped (PLINK)
sscanf ( s.c_str(), "%s%s%s%s%s%s", (char*)& ( pedigree ), (char*)& ( code ), (char*)& ( father ), (char*)& ( mother ), 	(char*)& gend, (char*)& affect ); break;
case 2: // only one column with individual code
sscanf ( s.c_str(), "%s", (char*)& ( code ) );
strcpy(pedigree, code);
strcpy(father,"0\0");
strcpy(mother,"0\0");
pS.Gender=unknown;
pS.Affectation=unknownAff;
strcpy(code2,code);
break;
}
		pS.Pedigree=string ( pedigree );
/*
		pos=findFirstDigit ( string ( code ) );
		pS.Code=atoi ( &code[pos] );
		pos=findFirstDigit ( string ( father ) );
		pS.Father=atoi ( &father[pos] );
		pos=findFirstDigit ( string ( mother ) );
		pS.Mother=atoi ( &mother[pos] );*/

		pS.Code=string ( code );
		pS.Father=string ( father ) ;
		pS.Mother=string ( mother );

//cout << "makeped is::" << extendedMakeped <<"\n";
if (inputFormat!=0)
{
		/*pos=findFirstDigit ( string ( code2 ) );
		pS.Code2=atoi ( &code2[pos] );*/
		pS.Code2=string ( code2 );

int af=atoi(affect), ge=atoi(gend);
string afS=tos(af), geS=tos(ge);
if (strcmp(afS.c_str(), affect)!=0 || strcmp(geS.c_str(), gend)!=0)
{
cout << affect << " is not an allowed affectation code\n";
cout << " or " << gend << " is not an allowed gender code\n";
throw BadFormat("Phenotype::fromString:1");
}

if (af!=unknownAff && af!=unaffected && af!=affected)
{
cout << affect << " is not an allowed affectation code\n";
throw BadFormat("Phenotype::fromString:2");
}

if (ge!=unknown && ge !=male && ge != female)
{
cout << gend << " is not an allowed gender code\n";
throw BadFormat("Phenotype::fromString:3");
}
pS.Affectation=(affectation) af;
pS.Gender=(gender)ge;
}
else 		// makeped
/*
pos=findFirstDigit ( string ( code ) );
		pS.Code2=atoi ( &code[pos] );
pos=findFirstDigit ( string ( pedigree ) );
	pS.Code2=	pS.Code2+atoi ( &pedigree[pos] )*100000;*/
pS.Code2=	string(code)+string(pedigree);


		return ( new Phenotype ( pS ) );
	}


};  // Fin del Namespace

#endif

/* Fin Fichero: Phenotype.h */
