/* File: PhenotypeSample.cpp */


#ifndef __PhenotypeSample_cpp__
#define __PhenotypeSample_cpp__



#include "PhenotypeSample.h"


//using namespace UTILS;


namespace BIOS
{



	/**********************************/
	/* DEFINITIONS OF THE FUNCTIONS */
	/**********************************/


//



	/*___________________________________________________________ */
	/*
	Phenotype vector<Phenotype>::ReadElement (ifstream* source, unsigned long int size)
	{
		BIOS::PhenotypeSample::ReadElement(source, size);
	}
	*/

	/*---------------------------------------------------------------*/
	/*
		template <> Phenotype* fromString(Phenotype* i, string s)
			// convert  string
		{
	Phenotype::PhenotypeS pS;
	return (new Phenotype(pS));
	char* line=new char[s.length()+1];
	strcpy(line, s.c_str());
	int cont=0;
	while (line[cont]<'0' || line[cont]>'9') cont++;
	line=line+cont;

	int cont2=0;
	while (line[cont2]!='\0')
	{
	if (line[cont2]==',') line[cont2]=' ';
	cont2++;
	}


		sscanf(line, "%d%d%d%d%d%d%d", &(pS.Pedigree), &(pS.Code), &(pS.Father), &(pS.Mother),
		&(pS.Gender), &(pS.Affectation), &(pS.Code2));

	line=line-cont;
		zaparr(line);
			return (new Phenotype(pS));
		};




	/*___________________________________________________________ */
	/*
	template <> Phenotype* Container<vector<Phenotype*>, Phenotype*>::readElement (ifstream* source, const char* tokens, int* pos, int size)
	{


		char *line =CaptureLine(source), *line2=line;

	int cont=0;
	while (line[cont]<'0' || line[cont]>'9') cont++;
	line=line+cont;
	int cont2=0;
	while (line[cont2]!='\0')
	{
	if (line[cont2]==',') line[cont2]=' ';
	cont2++;
	}

	Phenotype* result=Phenotype::fromString(string(line));

	//line=line-cont;
		//if (line==NULL) cout <<"is null\n"; else
	zaparr(line);
	return result;
	};

	/*___________________________________________________________ */

///////////////////
//// public ////////
///////////////////


	/*____________________________________________________________ */

	PhenotypeSample* PhenotypeSample::clone ()
	{
		return new PhenotypeSample ( ( PhenotypeSample& ) *this );
	}

	/*____________________________________________________________ */

	PhenotypeSample* PhenotypeSample::emptyCopy ()
	{
		return new PhenotypeSample();
	}
	/*____________________________________________________________ */

	PhenotypeSample::PhenotypeSample ( char* filename, int inputFormat ) :Container<vector<Phenotype*>, Phenotype*> ()// filename )
	{
		try
		{
Phenotype::setInputFormat(inputFormat);
			this->getInfo ( filename );
			outputSeparator='\n';
   if (inputFormat==2) replaceIndividualCodes(filename);
   

		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from PhenotypeSample::PhenotypeSample (char * filename" ); throw;};
	};
	/*____________________________________________________________ */

	PhenotypeSample::PhenotypeSample ( PhenotypeSample & source ) :Container<vector<Phenotype*>, Phenotype*>()
	{
		outputSeparator=source.outputSeparator;
		iterator p=source.getFirst();
		Phenotype* g, *g2;
		int i=0;
		while ( p!=source.end() )
		{
			g=source.getElement ( p );
			insertElement ( new Phenotype ( *g ) );
			p=source.getNext ( p );
		}
	};

/*____________________________________________________________ */

	void PhenotypeSample::replaceIndividualCodes ( char * filename)
	{
		try
		{
char indFile[1024];
			changeExtension ( filename, indFile, "indv" );
stringList * indCodes=new stringList(indFile);
if (indCodes->size() != size())
throw BadFormat("	void GenotypeSample::replaceIndividualCodes ( char * filename)");
Phenotype*p;
for (int i=0; i<indCodes->size(); i++)
{
p=getElement(i);
p->setCode(indCodes->getElement(i));
p->setCode2(indCodes->getElement(i));
}
}
catch ( BasicException& be ) {be.addMessage ( string ( "\ncalled from void GenotypeSample::replaceIndividualCodes ( char * filename)" ) +string ( filename ) ); throw;};
}
/*____________________________________________________________ */

PhenotypeSample::iterator  PhenotypeSample::findIndividualByCode (string code)
{
for (iterator p=begin(); p!=end();p++)
{
if (getElement(p)->getCode()==code) return p;
}
return end();
}
/*____________________________________________________________ */

PhenotypeSample::iterator  PhenotypeSample::findIndividualByCode2 (string code)
{
for (iterator p=begin(); p!=end();p++)
{
if (getElement(p)->getCode2()==code) return p;
}
return end();
}
	/*____________________________________________________________ */

	PhenotypeSample* PhenotypeSample::permute ()
	{
		PhenotypeSample* phenotypeSample=this->clone();
		PhenotypeSample::iterator p;
		Sampling* sampling=new Sampling ( this->size() );
		int* positions=sampling->getPositionsTable();
		int i=0;
		Phenotype::PhenotypeS phen; //=phenotypeSample->getFirstElement->GetPhenotype();
		while ( p!=phenotypeSample->end() )
		{
			phen=phenotypeSample->getElement ( p )->GetPhenotype();
			phen.Affectation=phenotypeSample->getElement ( positions[i] )->getAffectation();
			phenotypeSample->getElement ( p )->SetPhenotype ( phen );
			p=phenotypeSample->getNext ( p );
			i++;
		}
		zap ( sampling );
		return phenotypeSample;
	}
	/*____________________________________________________________ */

	void PhenotypeSample::setAffectationRandomly ()
	{
		Phenotype::PhenotypeS phen;
//cout << "sss\n";
		for ( PhenotypeSample::iterator p=getFirst();p!=end();p++ )
		{
			phen=this->getElement ( p )->GetPhenotype();
			phen.Affectation=unaffected;
			if ( ranbinom ( 1, uniform() ==1 ) ) phen.Affectation=affected;
			this->getElement ( p )->SetPhenotype ( phen );
		}
	}


	/*____________________________________________________________ */

	PhenotypeSample::iterator PhenotypeSample::GetRelative ( IndCategory ic, iterator const i )
	{
		try
		{
			unsigned int SizeP=size();
			if ( i==end() ) throw NullValue ( "PhenotypeSample::iterator PhenotypeSample::GetRelative(IndCategory ic, iterator const i)" );
			Phenotype::PhenotypeS ind = getElement ( i )->GetPhenotype(), ind2;
//	cout <<"\nfinding relative type " << ic <<" for ind " << *getElement(i)  <<"\n";
			unsigned int pos=0;
//cout << "\nFirst is: " << *getElement(p);
			for ( iterator p = this->begin();p!=this->end(); p++ )
				if ( p!=i )
				{
//			cout << "next: " << **p << "\n";
					ind2=getElement ( p )->GetPhenotype();
//cout << "\n" << *getElement(i) << " versus " << *getElement(p);
					switch ( ic )
					{
						case father:
							if	( ind2.Code == ind.Father && ind.Pedigree == ind2.Pedigree )
								return p;
							break;
						case mother:
							if	( ind2.Code == ind.Mother && ind.Pedigree == ind2.Pedigree )
								return p;
							break;
						case offspring:
							if	( ( ( ind2.Father == ind.Code ) || ( ind2.Mother==ind.Code ) ) && ( ind.Pedigree == ind2.Pedigree ) )
								return p;
							break;
					}
				};
   return this->end();
		//	cout << "no relative found for " << **i << "\n";
	//		throw NullValue ( "PhenotypeSample::iterator PhenotypeSample::GetRelative(IndCategory ic, iterator const i)-2" );
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled fromPhenotypeSample::iterator PhenotypeSample::GetRelative(IndCategory ic, iterator const i)" ); throw;};
	}

	/*____________________________________________________________ */

	PhenotypeSample::iterator PhenotypeSample::GetFather ( iterator const i )
	{
		try
		{
			return GetRelative ( father, i );
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from PhenotypeSample::iterator PhenotypeSample::GetFather(iterator const i)" ); throw;};
	}


	/*____________________________________________________________ */

	bool PhenotypeSample::isATrioDataset ()
	{
		try
		{
			for (iterator it=begin(); it!=end(); it++)
    if (((Phenotype*)*it)->isUnrelated(this)) return false;
  return true;
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from bool PhenotypeSample::isATrioDataset ()" ); throw;};
	};

	/*____________________________________________________________ */

	PhenotypeSample::iterator PhenotypeSample::GetMother ( iterator const i )
	{
		try
		{
			return GetRelative ( mother, i );
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from PhenotypeSample::iterator PhenotypeSample::GetMother(iterator const i)" ); throw;};
	};

	/*____________________________________________________________ */

	PhenotypeSample::iterator PhenotypeSample::getFirstChild ( iterator const i )
	{
		try
		{
			return GetRelative ( offspring, i );
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from PhenotypeSample::iterator PhenotypeSample::getFirstChild(iterator const i)" ); throw;};
	}
	/*____________________________________________________________ */
/*
void PhenotypeSample::addPartner (PhenotypeSample::iterator IndPhenotypeIt, PhenotypeSample::iterator partnerPhenotypeIt)
{
Phenotype *partnerPhenotype=**partnerPhenotypeIt;
Phenotype *newPhenotype;
PhenotypeS values=partnerPhenotype->phenotype;
if (!partnerPhenotype->isAFounder()) throw BadFormat ("void PhenotypeSample::addPartner (PhenotypeSample::iterator IndPhenotypeIt, PhenotypeSample::iterator partnerPhenotypeIt)");
values.Code++;
if (values.Code==**IndPhenotypeIt->phenotype.Code) values.Code++;
values.Code2=values.Code;
values.Affectation=0; // unknown
if (partnerPhenotype->isAMother()) values.Gender=1; else values.Gender=2;
newPhenotype=new Phenotype(values);
insertElement(newPhenotype);
}

	/*____________________________________________________________ */

	PhenotypeSample::iterator PhenotypeSample::getNextSib ( iterator const i, iterator const parent )
	{
		try
		{
			if ( i==end() )
				throw NullValue();
		}
		catch ( NullValue nv )
		{
			nv.PrintMessage();
		}

		iterator p=getFirstChild ( parent );
		IndPos Position=getPosition ( p );
		Phenotype::PhenotypeS Ind=getElement ( i )->GetPhenotype(), Ind2, Parent=getElement ( parent )->GetPhenotype();

		p = getNext ( p );
		Position++;
		while ( p!=end() )
		{
			// if sibs
			Ind2=getElement ( p )->GetPhenotype();
			if	(
			    ( ( Ind.Father==Ind2.Father && Ind2.Father==Parent.Code ) ||
			      ( Ind.Mother==Ind2.Mother && Ind2.Mother==Parent.Code ) )
			    && ( Ind2.Pedigree == Ind.Pedigree ) && ( Ind2.Pedigree == Parent.Pedigree )

			)
				return p;
			Position=Position+1;
			p=getNext ( p );
		};

		return p;


	}

	/*____________________________________________________________ */

	PhenotypeSample::iterator PhenotypeSample::GetPartner ( iterator const p, iterator const pChild )
	{

		Phenotype::PhenotypeS IndAdult=getElement ( p )->GetPhenotype(), IndChild=getElement ( pChild )->GetPhenotype();
		try
		{
			if ( p==end() || pChild==end() )
				throw NullValue();

			if ( IndAdult.Pedigree==IndChild.Pedigree )
			{
				if ( IndAdult.Gender==female && ( IndAdult.Code==IndChild.Mother || IndAdult.Code==IndChild.Father ) )
					return GetFather ( pChild );
				if ( IndAdult.Gender==male && ( IndAdult.Code==IndChild.Father || IndAdult.Code==IndChild.Mother ) )
					return GetMother ( pChild );
			}

			cout <<"Individual code " << IndChild.Code << "/" << IndChild.Pedigree
			<< " is not a child of individual code " << IndAdult.Code <<"/" << IndAdult.Pedigree;

			throw NullValue ();

		}

		catch ( NullValue nv )
		{
			nv.PrintMessage();
		}

	}
	/*____________________________________________________________ */

	PhenotypeSample::iterator PhenotypeSample::GetPartner ( iterator const p )
	{
		try
		{
			iterator pChild=getFirstChild ( p );
			return GetPartner ( p, pChild );
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from PhenotypeSample::iterator PhenotypeSample::GetPartner(iterator const p)" ); throw;};
	}


	/*____________________________________________________________ */

	string PhenotypeSample::PrintPhenotype ( iterator p )
	{
		return  getElement ( p )->PrintPhenotype();

	}
	/*____________________________________________________________ */

	void  PhenotypeSample::PrintPhenotypes ()
	{
		iterator IndPhenotype=getFirst();

		while ( IndPhenotype!=end() )
		{
			cout <<PrintPhenotype ( IndPhenotype );
			cout <<"\n";
			IndPhenotype=PhenotypeSample::getNext ( IndPhenotype );
		}
	}
	/*____________________________________________________________ */

	IndPos PhenotypeSample::GetTotalOffSpring ()
	{
		return GetTotalIndividuals ( offspring );
	}
	/*____________________________________________________________ */

	IndPos PhenotypeSample::GetTotalIndividuals ( IndCategory ic, int gender, int affectation )
	{
		bool* Marked=Initialize ( this->size(), ( bool ) false );
		SetMarked ( Marked, ic, gender, affectation );
		int total=0;
		for ( int i=0; i<size(); i++ )
			if ( Marked[i] ) total++;
		zaparr ( Marked );
		return total;
		/*
		IndPos Total=0;

		Phenotype IndPhenotype;
		iterator p=getFirst();
		Phenotype P;

		while (p!=end())
		  {
		   P=getElement(p);
		   if ((ic==offspring && P.IsAChild ()) || (ic==parent && P.IsAParent ())
			 || (ic==everybody) || (ic==father && P.IsAFather()) || (ic==mother && P.IsAMother()))
			  Total++;

		   p=getNext(p);
		  };



		  return Total;
		*/
	}
	/*____________________________________________________________ */

	IndPos PhenotypeSample::getTotalByAffectation ( int affectation )
	{
		IndPos Total=0;

		iterator p=getFirst();
		Phenotype* P;

		while ( p!=end() )
		{
			P=getElement ( p );
			if ( ( affectation==allAffectation )
			        || ( affectation== P->GetPhenotype().getAffectation() ) )
				Total++;

			p=getNext ( p );
		};



		return Total;
	}
	/*____________________________________________________________ */

	IndPos PhenotypeSample::getTotalByAffectationAndIC ( int affectation, IndCategory ic )
	{
		IndPos Total=0;

		iterator p=getFirst();
		Phenotype *P;

		while ( p!=end() )
		{
			P=getElement ( p );
			if ( ( ic==offspring && P->isAChild () ) || ( ic==parent && P->isAParent ( this ) )
			        || ( ic==everybody ) || ( ic==father && P->isAFather ( this ) ) || ( ic==mother && P->isAMother ( this ) ) )
				if ( ( affectation==allAffectation )
				        || ( affectation== P->GetPhenotype().getAffectation() ) )
					Total++;

			p=getNext ( p );
		};



		return Total;
	}

	/*__________________________________________________________*/

	void PhenotypeSample::SetMarked ( bool *Marked, IndCategory ic, int genderN, int affectationN )
	{
		IndPos TotalInds=size(), cont=0;
		InitializeList ( Marked, TotalInds, false );
		iterator p=getFirst();
		Phenotype* ph;
		gender Gender;
		affectation Affectation;
		if ( genderN!=everyGender ) Gender= ( gender ) genderN;
		if ( affectationN!=allAffectation ) Affectation= ( affectation ) affectationN;
		while ( p!=end() )
		{
			ph=getElement ( p );
			switch ( ic )
			{
				case offspring:
					if ( ph->isAChild() ) Marked[cont]=true;
					break;
				case father:
					if ( ph->isAFather ( this ) ) Marked[cont]=true;
					break;
				case mother:
					if ( ph->isAMother ( this ) ) Marked[cont]=true;
					break;
				case parent:
					if ( ph->isAParent ( this ) ) Marked[cont]=true;
					break;
				case everybody:
					Marked[cont]=true;
					break;
				case unrelated:
					if ( ph->isUnrelated ( this ) ) Marked[cont]=true;
					break;
			}
//cout <<"ic is" << ic;
//cout <<"\nmarked " << cont << " is " << Marked[cont];
			if ( genderN!=everyGender && Marked[cont]==true )
				if ( ph->GetPhenotype().Gender!=Gender ) Marked[cont]=false;
			if ( affectationN!=allAffectation && Marked[cont]==true )
				if ( ph->GetPhenotype().getAffectation() != ( int ) Affectation ) Marked[cont]=false;

			p=getNext ( p );
//cout <<"ind:" << cont;
			cont++;
		}
	}





};  // Fin del Namespace

#endif

/* Fin Fichero: PhenotypeSample.h */
