#ifndef __RandomizationDistribution_cpp__
#define __RandomizationDistribution_cpp__

void print(BIOS::RandomizationDistribution * rd){
	cout << *rd ;
}

namespace BIOS {


	RandomizationDistribution::RandomizationDistribution(){
		collapsed_values = NULL;
		collapsed_freqs = NULL;
		values = new doubleList();
		sorted == false;
	}
	
	RandomizationDistribution::~RandomizationDistribution(){

		if (values != NULL)
			delete values;



		if (collapsed_values != NULL)
			delete collapsed_values;

		if (collapsed_freqs != NULL)
			delete collapsed_freqs;
		

	}

	void RandomizationDistribution::sort(){
		if (values != NULL)
			values->sort();
	}

	double RandomizationDistribution::getPvalue(double z){

		if ( !sorted )
			sort();

		double unit = (float)1/(float)values->size();
		bool found = false;
		double p=0;

		for(int i=0; i < values->size() && !found; i++){

			if ( (*values)[i] < z)
				p += unit;
			else
				found = true;
						
		}
		return 1-p;
		
	}

	void RandomizationDistribution::collapse(){
		if ( values->size() == 0) 
			return;

		collapsed_values = new doubleList();
		collapsed_freqs = new doubleList();


		double value;
		double freq = 0;
		value = (*values)[0];

		for (int i=0; i<(*values).size(); i++){
			if ( fabs( value - (*values)[i] ) < 0.0001)
				freq = freq +1 ;
			else{
				//cout << value << "\t" << freq << endl;
				collapsed_values->insertElement(value);
				collapsed_freqs->insertElement(freq);
				freq=1;
				value = (*values)[i];

				
			}

		}

				collapsed_values->insertElement(value);
				collapsed_freqs->insertElement(freq);
	


	};

	void RandomizationDistribution::getFreqTable(){
		if ( collapsed_values != NULL)
			for(int i=0; i< collapsed_values->size(); i++)						
				cout << collapsed_values << "[" << collapsed_freqs <<"]" << endl;
	};

};

#endif
