
/* File: RepeatedGenomaSample.cpp */



#ifndef __RepeatedGenomaSample_cpp__
#define __RepeatedGenomaSample_cpp__


#include "RepeatedGenomaSample.h"
      
        



namespace BIOS {




/*____________________________________________________________ */

RepeatedGenomaSample::RepeatedGenomaSample(char* filename, bool  ExistPhen): 
				PhenotypeSample(filename), 
				RepeatedGenotypeSample(filename, ExistPhen)
{
// cout <<"gentot:" << genotype::TotalSNPs;
};
/*____________________________________________________________ */

void RepeatedGenomaSample::PrintOrderedUnrepeatedGenoma (char* filename, bool PrintPhenotypes)
 {

  PhenotypeSample::iterator IndPhenotype=PhenotypeSample::getFirst(); 
  RepeatedGenotypeSample::iterator IndOrderedGenotype=RepeatedGenotypeSample::getFirst();
  Genotype* genotype;


  try
{
	  OutputFile.open (filename, ifstream::out);
	  if (!OutputFile)
	   throw ErrorFile();
}
catch (ErrorFile NoFile) {
        NoFile.PrintMessage();
      }

while (IndPhenotype!=PhenotypeSample::end() && IndOrderedGenotype!=GenotypeSample::end())
  {
   if (PrintPhenotypes)	OutputFile << PhenotypeSample::getElement(IndPhenotype)->PrintPhenotype();

	OutputFile << RepeatedGenotypeSample::getElement(IndOrderedGenotype)->print();    
	OutputFile << "\n";
    IndOrderedGenotype=RepeatedGenotypeSample::getNext(IndOrderedGenotype);
    IndPhenotype=PhenotypeSample::getNext(IndPhenotype);
  }
  OutputFile.close();

cout << "\nInformation about ordered genotype has been saved in file " << filename <<"\n";
 }




};  // Fin del Namespace

#endif

/* Fin Fichero: RepeatedGenomaSample.h */
