/* File: MultimarkerMeasure.h */


#ifndef __SampleGeneticCounts_cpp__
#define __SampleGeneticCounts_cpp__





//using namespace stats;

namespace BIOS {


/**********************************/
/* DEFINITIONS OF THE FUNCTIONS */
/**********************************/



///////////////////
//// public ////////
///////////////////



/*_________________________________________________________________*/

SampleGeneticCounts::SampleGeneticCounts(int* pos, int* absPos, int length, GeneticUnitCountsVector* countsVector, int totalPermutations): SampleGenericCounts(totalPermutations)
{
//  cout << "really clonig here\n";
this->countsVector=countsVector->clone();
//cout << "counts vector cloed is: " << *this->countsVector << endl;
this->length=length;
//setSize();
//cout << "ength is: " << length << end;
if (pos!=NULL)
{
this->pos=new int[length];
this->absPos=new int[length];
for (int i=0; i<length; i++)
{
 this->pos[i]=pos[i];
 this->absPos[i]=absPos[i];
// cout << "pos at " << i <<": " << pos[i] << endl;
}
}
else 
{
this->pos=NULL;
this->absPos=NULL;
}
}


/*_________________________________________________________________*/
/*
SampleGeneticCounts::SampleGeneticCounts(int* pos, int length, GeneticUnitCountsVector* countsVector, int totalPermutations): SampleGenericCounts(totalPermutations)
{
this->countsVector=countsVector;
this->hapExtractionConfiguration=NULL;
this->length=length;
if (pos!=NULL)
{
this->pos=new int[length];
for (int i=0; i<length; i++)
 this->pos[i]=pos[i];
}
else this->pos=NULL;
}

/*_________________________________________________________________*/

SampleGeneticCounts::SampleGeneticCounts(SampleGeneticCounts& tu): SampleGenericCounts((SampleGenericCounts&) tu)
{
pos=NULL;
absPos=NULL;
if (tu.pos!=NULL)
{
pos=new int[tu.getTotalPos()];
absPos=new int[tu.getTotalPos()];
for (int i=0; i<tu.getTotalPos(); i++)
{
 pos[i]=tu.pos[i];
 absPos[i]=tu.absPos[i];
}
}
length=tu.length;
//sizeV=tu.sizeV;
countsVector=NULL;
if (tu.getCountsVector()!=NULL)
  countsVector=tu.getCountsVector()->clone();
}

 	
/*_________________________________________________________________*/

void SampleGeneticCounts::setSize()
{
  throw NonImplemented("void SampleGeneticCounts::setSize()");
  /*
  int sizeV=0;

  GeneticUnitCounts* gc;
    if (getCountsVector()!=NULL)
for (GeneticUnitCountsList::iterator it=getCountsVector()->begin(); it<getCountsVector()->end(); it++)
{
  gc=*it;
  sizeV+=gc->getFirstFrequency()+gc->getSecondFrequency()+2*gc->getThirdFrequency();
}
*/
}


/*_________________________________________________________________*/

SampleGeneticCounts::~SampleGeneticCounts ()
{
empty();
}

/*_________________________________________________________________*/

void SampleGeneticCounts::empty ()
{
zaparr(pos);
zap(countsVector);
zaparr(absPos);

}


	/*_________________________________________________________________*/

Vector<GeneticUnitCounts*>::Class* SampleGeneticCounts::getCountsVector()
{
return countsVector;
}

/*_________________________________________________________________*/

 SampleGeneticCounts::SampleGeneticCounts(): SampleGenericCounts()
{
length=0;
//sizeV=0;
pos=NULL;
absPos=NULL;
}

/*_________________________________________________________________*/

int SampleGeneticCounts::size()
{
  throw NonImplemented("int SampleGeneticCounts::size()");
 // if (sizeV==0) setSize();
//return sizeV;
  
}

/*_________________________________________________________________*/

void SampleGeneticCounts::print(ostream& out)
       {
try
{
  if (getCountsVector()!=NULL && getCountsVector()->size()>0)
          out <<"size of " <<  getCountsVector()->getFirstElement()->getGeneticElement()->getName() << "s is:" << getTotalPos() <<"\n";
for (int i=0; i<getTotalPos();i++)
out <<"pos at " << i << ": " << pos[i] <<"\n";
for (int i=0; i<getTotalPos();i++)
out <<"as pos at " << i << ": " << absPos[i] <<"\n";
countsVector->print(out);
}


		catch ( BasicException& be ) {be.addMessage ( "\ncalled from void SampleGeneticCounts<T>::print(ostream& out)" ); throw;};
};







  /*_________________________________________________________________*/

int SampleGeneticCounts::getTotalPos()
  {
  return length;
  }

  /*_________________________________________________________________*/

int* SampleGeneticCounts::getPositions()
  {
  return pos;
  }

  /*_________________________________________________________________*/

int* SampleGeneticCounts::getAbsolutePositions()
  {
  return absPos;
  }

/*_________________________________________________________________*/
	
Vector<GeneticUnitCounts*>::Class::iterator SampleGeneticCounts::findElement(GeneticUnit * h)
{
for (Vector<GeneticUnitCounts*>::Class::iterator it=countsVector->begin(); it!=countsVector->end(); it++)
if (h==countsVector->getElement(it)->getGeneticElement())
return it;
return countsVector->end();
	}

/*_________________________________________________________________*/


	AssociationTable* SampleGeneticCounts::createAssociationTable(TUMeasure*g)
{
	//	cout << "before in s\n";	
AssociationTable* a= createBasicAssociationTable(g), *result=NULL;
			double totalFirst=a->getTotalFirstRow(), totalSecond=a->getTotalSecondRow();

//cout <<"basictable is:" << *a <<"\n";
   zap(a);
GeneticUnitCountsSample * p=g->getPartition(getCountsVector(), totalFirst, totalSecond);
//cout <<"partition is: " << *p <<"\n";
//cout <<"after fil\n";
//cout <<"remove p\n";
//cout << "totalelement in first:" << p->getElement(0)->size() <<"\n";
//cout << "totalelement in second:" << p->getElement(1)->size() <<"\n";
//zap( p->getElement(0));
//zap( p->getElement(1));
//			zap ( p );
			if ( p->getElement ( 0 )->size() >0 && p->getElement ( 1 )->size() >0 )
				result=createComposedAssociationTable( p );
//cout <<"newtable:" << *result <<"\n";

			zap ( p );
			return result;
}



AssociationTable* SampleGeneticCounts::createAssociationTable(Vector<GeneticUnitCounts*>::Class*g){throw NonImplemented("AssociationTable* createAssociationTable(Vector<GeneticUnitCounts*>::Class*g");};


AssociationTable* SampleGeneticCounts::createBasicAssociationTable(TUMeasure*g){throw NonImplemented("AssociationTable* createBasicAssociationTable(TUMeasure*g)");};

AssociationTable* SampleGeneticCounts::createComposedAssociationTable(GeneticUnitCountsSample * p){throw NonImplemented("AssociationTable* createComposedAssociationTable(GeneticUnitCountsSample * p)");};

};  // End of Namespace

#endif

/* End of file: MultimarkerMeasure.h */

//stringList * BIOS::SampleGeneticCounts::getTDTFreqsResults(SNPPos snpPos)
//{
//}






