/* File: PhylogeneticDistance.h */

#ifndef __SampleGeneticCounts_h__
#define __SampleGeneticCounts_h__

//using namespace stats;

namespace BIOS {

class AssociationTable;
/************************/
/* SNP'S MultimarkerMeasure DEFINITION */
/************************/


/**
        @memo Haplotype or Genotype counts for a given window in a genetic sample

	@doc
        Definition:

       Class used mainly to compute multimarker TU or their generalization to case/control samples.
?? In order to similarity measures to can be applied, haplotype counters (or freqs if EM-freq is used) for each couple in case of TU samples must be independently kept        With this purpose, the data structures required is:       Container<<vector, ParentalHaplotypes>> *parentalHaps   

        @author Maria M. Abad Grau
	@version 1.0
*/



//class countsVector;

//class GenericcountsVector;

class GeneticUnitCounts;
class SampleGenericCounts;
typedef VectorSample<GeneticUnitCounts*>::Class GeneticUnitCountsSample;



typedef Vector<GeneticUnitCounts*>::Class GeneticUnitCountsList;

typedef Vector<GeneticUnitCounts*>::Class GeneticUnitCountsVector;
 
class SampleGeneticCounts: public SampleGenericCounts {
// T will be HaplotypeTUCounts or HaplotypeCaseControlCounts

//class	SampleGeneticCounts: public SampleGenericCounts {


public:

Vector<GeneticUnitCounts*>::Class* countsVector; // it may be a Vector of
// 1. HaplotypeTUCounts
// 2. HaplotypeCaseControlCounts
// 3. GenotypeCaseControlCounts

protected:




int* pos; // used positions (NULL if all positions from parentalGenotypes are used)
int length;
int* absPos;

//int sizeV;

//countsVector* countsVector; 

/*********************************************************************/
/***     ASSOCIATED FUNCTIONS     ***/
/*********************************************************************/

private:


//void set(SNPPos Pos[], SNPPos totalPos, TrioSample * samp, HapExtractionConfiguration* hapExtractionConfiguration, int totalPermutations);  



      public:

SampleGeneticCounts();

//	SampleGeneticCounts(SNPPos Pos[], SNPPos totalPos, TrioSample * samp, AlleleOrderType alleleOrderType=LeftRight, PhaseAlg=weighted, EMDistributions emDistributions=UTDistributions, EMRestriction emRestriction=triosBasedRestriction, int totalPermutations=100);

SampleGeneticCounts(int*pos, int* absPos, int length, Vector<GeneticUnitCounts*>::Class* countsVector, int totalPermutations);

//SampleGeneticCounts(int*pos, int length, Vector<GeneticUnitCounts*>::Class* countsVector, int totalPermutations);

//SampleGeneticCounts(char* filename, HapExtractionConfiguration* hapExtractionConfiguration, int totalPermutations);
	
 SampleGeneticCounts(SampleGeneticCounts& source);
 
virtual int getTotalPos();

int* getPositions();

int* getAbsolutePositions();
 
 //SampleGeneticCounts(char*filename);

 //virtual SampleGeneticCounts* clone();

virtual ~SampleGeneticCounts();

virtual void empty();

void setSize();

GeneticUnitCountsVector::iterator findElement(GeneticUnit * h);

//virtual void setPermutations();

Vector<GeneticUnitCounts*>::Class* getCountsVector();

virtual void print(ostream&);

virtual AssociationTable* createAssociationTable(Vector<GeneticUnitCounts*>::Class*g);


virtual int size();
AssociationTable* createAssociationTable(TUMeasure*g);

virtual AssociationTable* createBasicAssociationTable(TUMeasure*g);

virtual AssociationTable* createComposedAssociationTable(GeneticUnitCountsSample * p);

};  // End of class SampleGeneticCounts








};  // End of Namespace

#endif

/* End of file: MultimarkerMeasure.h */




