/* File: MultimarkerMeasure.h */


#ifndef __SampleGenotypeCaseControlCounts_cpp__
#define __SampleGenotypeCaseControlCounts_cpp__





//using namespace stats;

namespace BIOS {


/**********************************/
/* DEFINITIONS OF THE FUNCTIONS */
/**********************************/



///////////////////
//// public ////////
///////////////////

/*____________________________________________________________ */

SampleGeneticCounts* SampleGenotypeCaseControlCounts::clone()
{
return new SampleGenotypeCaseControlCounts(*this);
} 
/*_________________________________________________________________*/
/*
AssociationTable* SampleGenotypeCaseControlCounts::createAssociationTable(TUMeasure* g)
{
AssociationTable* a= new TDTtable(this->getCountsVector(), g->minFreq), *result=NULL;
			double totalFirst=a->getTotalFirstRow(), totalSecond=a->getTotalSecondRow();
   zap(a);


//cout <<"before filling\n";
GeneticUnitCountsSample * p=g->getPartition(getCountsVector(), totalFirst, totalSecond);
//cout <<"after fil\n";
//cout <<"remove p\n";
//cout << "totalelement in first:" << p->getElement(0)->size() <<"\n";
//cout << "totalelement in second:" << p->getElement(1)->size() <<"\n";
//zap( p->getElement(0));
//zap( p->getElement(1));
//			zap ( p );
			//if ( p->getElement ( 0 )->size() >0 && p->getElement ( 1 )->size() >0 )
				result=new GenotypeCaseControlTable( p );
			zap ( p );
			return result;
}


/*_________________________________________________________________*/

SampleGenotypeCaseControlCounts::SampleGenotypeCaseControlCounts(int*pos, int* absPos, int length, GeneticUnitCountsVector* genotypeCountsVector, int totalPermutations, GenotypeList*caseGenotypes, GenotypeList* controlGenotypes): SampleGeneticCounts(pos, absPos, length, genotypeCountsVector, totalPermutations)
{
totalHaps=0;
this->caseGenotypes=caseGenotypes;
this->controlGenotypes=controlGenotypes;
//this->haplotypeCaseControlCountsVector=haplotypeCaseControlCountsVector;
}

/*_________________________________________________________________*/

SampleGenotypeCaseControlCounts::SampleGenotypeCaseControlCounts(SampleGenotypeCaseControlCounts& tu):SampleGeneticCounts((SampleGeneticCounts&)tu)
{
caseGenotypes=tu.caseGenotypes->clone();
controlGenotypes=tu.controlGenotypes->clone();
}
 


/*_________________________________________________________________*/

SampleGenotypeCaseControlCounts::~SampleGenotypeCaseControlCounts()
{
zap(caseGenotypes);
zap(controlGenotypes);
}

/*_________________________________________________________________*/

SampleGenotypeCaseControlCounts::SampleGenotypeCaseControlCounts():SampleGeneticCounts()
{
caseGenotypes=NULL;
controlGenotypes=NULL;
totalHaps=0;
}

			/*_________________________________________________________________*/

int SampleGenotypeCaseControlCounts::size()
{
if (totalHaps<0) throw BadFormat("int SampleGenotypeCaseControlCounts::size()");
if (totalHaps>0) return totalHaps;

for (GeneticUnitCountsVector::iterator it=countsVector->begin(); it< countsVector->end(); it++)
totalHaps=totalHaps+countsVector->getElement(it)->getFirstFrequency()+countsVector->getElement(it)->getSecondFrequency();
return totalHaps;
}


/*_________________________________________________________________*/
/*
void SampleGenotypeCaseControlCounts::setPermutations()
{
throw NonImplemented("CaseControlCounts::setPermutations()");
}

/*_________________________________________________________________*/

GenotypeList* SampleGenotypeCaseControlCounts::getCaseGenotypes()
{
return caseGenotypes;
}


/*_________________________________________________________________*/

GenotypeList* SampleGenotypeCaseControlCounts::getControlGenotypes()
{
return controlGenotypes;
}
/*_________________________________________________________________*/
/*
void SampleGenotypeCaseControlCounts::print(ostream& out)
       {
try
{
          out <<"size is:" << getTotalPos() <<"\n";
for (int i=0; i<getTotalPos();i++)
out <<"pos at " << i << ": " << pos[i] <<"\n";


}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from void SampleGeneticCounts<T>::print(ostream& out)" ); throw;};
};

/*_________________________________________________________________*/


AssociationTable* SampleGenotypeCaseControlCounts::createAssociationTable(Vector<GeneticUnitCounts*>::Class*g)
{
return new GenotypeCaseControlTable(g);
};
/*_________________________________________________________________*/

AssociationTable* SampleGenotypeCaseControlCounts::createBasicAssociationTable(TUMeasure*g)
{
  throw NonImplemented(" AssociationTable* SampleGenotypeCaseControlCounts::createBasicAssociationTable(TUMeasure*g)");
}

/*_________________________________________________________________*/


AssociationTable* SampleGenotypeCaseControlCounts::createComposedAssociationTable(GeneticUnitCountsSample * p)
{
  throw NonImplemented(" AssociationTable* SampleGenotypeCaseControlCounts::createComposedAssociationTable(GeneticUnitCountsSample * p");
}



};  // End of Namespace

#endif

/* End of file: MultimarkerMeasure.h */

//stringList * BIOS::CaseControlCounts::getTDTFreqsResults(SNPPos snpPos)
//{
//}






