/* File: PhylogeneticDistance.h */

#ifndef __SampleGenotypeCaseControlCounts_h__
#define __SampleGenotypeCaseControlCounts_h__

//using namespace stats;

namespace BIOS {


/************************/
/* SNP'S MultimarkerMeasure DEFINITION */
/************************/


/**
        @memo TUCounters for a given window in a TrioSample

	@doc
        Definition:

       Class used mainly to compute multimarker TU measures. In order to similarity measures to can be applied, haplotype counters (or freqs if EM-freq is used) for each couple must be independently kept 

       With this purpose, the data structures required is:
 
       Container<vector, ParentalHaplotypes> *parentalHaps   

        @author Maria M. Abad
	@version 1.0
*/


//class HaplotypeSampleGeneticCountsVector;
//class HaplotypeCaseControlCounts;
//class HaplotypeCaseControlCountsVector;

//typedef Vector<HaplotypeCaseControlCounts*>::Class HaplotypeCaseControlCountsVector;
 typedef Vector<HaplotypeCaseControlCounts*>::Class HaplotypeCaseControlCountsList;
 typedef Vector<Genotype*>::Class GenotypeList;
//class HaplotypeCaseControlCountsVector;




class	SampleGenotypeCaseControlCounts: public SampleGeneticCounts {

private:

int totalHaps;
//GenericSample* genotypes; // genotype counters, required to compute permutations
//CaseControlCounts** permutations;

GenotypeList* caseGenotypes, *controlGenotypes;

//HaplotypeCaseControlCountsVector* haplotypeCaseControlCountsVector;

public:


//HaplotypeCaseControlCountsList::iterator findElement(Haplotype * h);
//HaplotypeCaseControlCountsVector* haplotypeCaseControlCountsVector; 



/*********************************************************************/
/***     ASSOCIATED FUNCTIONS     ***/
/*********************************************************************/

private:


//void set(SNPPos Pos[], SNPPos totalPos, TrioSample * samp, HapExtractionConfiguration* hapExtractionConfiguration, int totalPermutations);  



      public:

SampleGenotypeCaseControlCounts();

//	CaseControlCounts(SNPPos Pos[], SNPPos totalPos, TrioSample * samp, AlleleOrderType alleleOrderType=LeftRight, PhaseAlg=weighted, EMDistributions emDistributions=UTDistributions, EMRestriction emRestriction=triosBasedRestriction, int totalPermutations=100);

SampleGenotypeCaseControlCounts(int*pos, int* absPos, int length, GeneticUnitCountsVector* haplotypeCountsVector, int totalPermutations, GenotypeList*caseGenotypes, GenotypeList* controlGenotypes);


//CaseControlCounts(char* filename, HapExtractionConfiguration* hapExtractionConfiguration, int totalPermutations);
	
 SampleGenotypeCaseControlCounts(SampleGenotypeCaseControlCounts& source);
 
 
virtual SampleGeneticCounts* clone();

virtual ~SampleGenotypeCaseControlCounts();

//void setPermutations();

virtual int size();

GenotypeList* getCaseGenotypes();

GenotypeList* getControlGenotypes();

//virtual void print(ostream&);

//virtual AssociationTable* createAssociationTable(TUMeasure* g);


virtual AssociationTable* createAssociationTable(Vector<GeneticUnitCounts*>::Class*g);

virtual AssociationTable* createBasicAssociationTable(TUMeasure*g);

virtual AssociationTable* createComposedAssociationTable(GeneticUnitCountsSample * p);

//GenericHaplotypeCountsVector* getHaplotypeCountsVector();


};  // End of class SampleGenotypeCaseControlCounts








};  // End of Namespace

#endif

/* End of file: MultimarkerMeasure.h */




