/* File: PhylogeneticDistance.h */

#ifndef __SampleHaplotypeCaseControlCounts_h__
#define __SampleHaplotypeCaseControlCounts_h__

//using namespace stats;

namespace BIOS {

class AssociationTable;
/************************/
/* SNP'S MultimarkerMeasure DEFINITION */
/************************/


/**
        @memo Haplotype or Genotype counts for a given window in a genetic sample

	@doc
        Definition:

       Class used mainly to compute multimarker TU or their generalization to case/control samples.
?? In order to similarity measures to can be applied, haplotype counters (or freqs if EM-freq is used) for each couple in case of TU samples must be independently kept        With this purpose, the data structures required is:       Container<<vector, ParentalHaplotypes>> *parentalHaps   

        @author Maria M. Abad Grau
	@version 1.0
*/


//class HapExtractionConfiguration;

//class countsVector;

//class GenericcountsVector;

class GeneticUnitCounts;
class SampleGenericCounts;
 
class SampleHaplotypeCaseControlCounts: public SampleHaplotypeCounts {
// T will be HaplotypeTUCounts or HaplotypeCaseControlCounts

//class	SampleHaplotypeCaseControlCounts: public SampleGenericCounts {

//protected:
//HapExtractionConfiguration* hapExtractionConfiguration;//how haps were extracted from genotytpes
//SampleGeneticCounts** permutations;


//countsVector* countsVector; 

/*********************************************************************/
/***     ASSOCIATED FUNCTIONS     ***/
/*********************************************************************/

private:


//void set(SNPPos Pos[], SNPPos totalPos, TrioSample * samp, HapExtractionConfiguration* hapExtractionConfiguration, int totalPermutations);  



      public:

SampleHaplotypeCaseControlCounts();

//	SampleHaplotypeCaseControlCounts(SNPPos Pos[], SNPPos totalPos, TrioSample * samp, AlleleOrderType alleleOrderType=LeftRight, PhaseAlg=weighted, EMDistributions emDistributions=UTDistributions, EMRestriction emRestriction=triosBasedRestriction, int totalPermutations=100);

SampleHaplotypeCaseControlCounts(int*pos, int* absPos, int length, Vector<GeneticUnitCounts*>::Class* countsVector, int totalPermutations);

//SampleHaplotypeCaseControlCounts(int*pos, int length, Vector<GeneticUnitCounts*>::Class* countsVector, int totalPermutations);

//SampleHaplotypeCaseControlCounts(char* filename, HapExtractionConfiguration* hapExtractionConfiguration, int totalPermutations);
	
SampleHaplotypeCaseControlCounts(SampleHaplotypeCaseControlCounts& source);

virtual ~SampleHaplotypeCaseControlCounts ();

virtual SampleGenericCounts* clone();


virtual AssociationTable* createAssociationTable(Vector<GeneticUnitCounts*>::Class*g);



//virtual AssociationTable* createAssociationTable(TUMeasure*g);

virtual AssociationTable* createBasicAssociationTable(TUMeasure*g);

virtual AssociationTable* createComposedAssociationTable(GeneticUnitCountsSample * p);

//print void print(ostream& out);
 

//HapExtractionConfiguration* getHapExtractionConfiguration();

};  // End of class SampleHaplotypeCaseControlCounts








};  // End of Namespace

#endif

/* End of file: MultimarkerMeasure.h */




