/* File: PhylogeneticDistance.h */

#ifndef __SampleHaplotypeCounts_h__
#define __SampleHaplotypeCounts_h__

//using namespace stats;

namespace BIOS {

class AssociationTable;
/************************/
/* SNP'S MultimarkerMeasure DEFINITION */
/************************/


/**
        @memo Haplotype or Genotype counts for a given window in a genetic sample

	@doc
        Definition:

       Class used mainly to compute multimarker TU or their generalization to case/control samples.
?? In order to similarity measures to can be applied, haplotype counters (or freqs if EM-freq is used) for each couple in case of TU samples must be independently kept        With this purpose, the data structures required is:       Container<<vector, ParentalHaplotypes>> *parentalHaps   

        @author Maria M. Abad Grau
	@version 1.0
*/


//class HapExtractionConfiguration;

//class countsVector;

//class GenericcountsVector;

class GeneticUnitCounts;
class SampleGenericCounts;
 
class SampleHaplotypeCounts: public SampleGeneticCounts {
// T will be HaplotypeTUCounts or HaplotypeCaseControlCounts

//class	SampleHaplotypeCounts: public SampleGenericCounts {


//SampleGeneticCounts** permutations;


//countsVector* countsVector; 

/*********************************************************************/
/***     ASSOCIATED FUNCTIONS     ***/
/*********************************************************************/

private:


//void set(SNPPos Pos[], SNPPos totalPos, TrioSample * samp, HapExtractionConfiguration* hapExtractionConfiguration, int totalPermutations);  



      public:

SampleHaplotypeCounts();

//	SampleHaplotypeCounts(SNPPos Pos[], SNPPos totalPos, TrioSample * samp, AlleleOrderType alleleOrderType=LeftRight, PhaseAlg=weighted, EMDistributions emDistributions=UTDistributions, EMRestriction emRestriction=triosBasedRestriction, int totalPermutations=100);

SampleHaplotypeCounts(int*pos, int* absPos, int length, Vector<GeneticUnitCounts*>::Class* countsVector, int totalPermutations);

//SampleHaplotypeCounts(int*pos, int length, Vector<GeneticUnitCounts*>::Class* countsVector, int totalPermutations);

//SampleHaplotypeCounts(char* filename, HapExtractionConfiguration* hapExtractionConfiguration, int totalPermutations);


virtual ~SampleHaplotypeCounts ();

virtual void print(ostream& out);
	
 SampleHaplotypeCounts(SampleHaplotypeCounts& source);


virtual AssociationTable* createAssociationTable(Vector<GeneticUnitCounts*>::Class*g)=0;

virtual AssociationTable* createBasicAssociationTable(TUMeasure*g)=0;

virtual AssociationTable* createComposedAssociationTable(GeneticUnitCountsSample * p)=0;

//virtual AssociationTable* createAssociationTable(TUMeasure*g)=0; 

//HapExtractionConfiguration* getHapExtractionConfiguration();

};  // End of class SampleHaplotypeCounts








};  // End of Namespace

#endif

/* End of file: MultimarkerMeasure.h */




