#ifndef __HaplotypeTUCounts_cpp__
#define __HaplotypeTUCounts_cpp__

void print(BIOS::HaplotypeTUCounts *h){
	cout << *h << endl;
}

void print2(BIOS::HaplotypeTUCounts *h){
	cout << "hola" << endl;
}

namespace BIOS {

	HaplotypeTUCounts::HaplotypeTUCounts(int size):HaplotypeCounts(size)
	{
		setThirdFrequency(0);
	};
	

	/*_________________________________________________________________*/
	

			HaplotypeTUCounts::HaplotypeTUCounts(GeneticUnit* haplotype, float frequencyT, float frequencyU, float frequencyHomo): HaplotypeCounts(haplotype, frequencyT, frequencyU)
			{
		setThirdFrequency(frequencyHomo);
			}
			
				/*_________________________________________________________________*/
	
			HaplotypeTUCounts::HaplotypeTUCounts(GeneticUnitCounts& other):HaplotypeCounts(other)
			{

			  setThirdFrequency(other.getThirdFrequency());
			  cout << "haplotypr counts: " << other << " has been copied to " << *this << endl;
			}
	
	

			/*_________________________________________________________________*/
	
	bool HaplotypeTUCounts::isTransmitted()
	{
		return getFirstFrequency() > 0;
	};

			/*_________________________________________________________________*/
	
	bool HaplotypeTUCounts::isNonTransmitted()
	{
		return getSecondFrequency() > 0;
	};

			/*_________________________________________________________________*/
	
	
double  HaplotypeTUCounts::getFrequencyT()
{
return getFirstFrequency();
}


			/*_________________________________________________________________*/
	
double  HaplotypeTUCounts::getFrequencyU()
{
return getSecondFrequency();
}


			/*_________________________________________________________________*/
	
	
void  HaplotypeTUCounts::setFrequencyT(double f)
{
return setFirstFrequency(f);
}


			/*_________________________________________________________________*/
	
void  HaplotypeTUCounts::setFrequencyU(double f)
{
return setSecondFrequency(f);
}


			/*_________________________________________________________________*/
	

double  HaplotypeTUCounts::getFrequencyHomo()
{
return getThirdFrequency();
}

			/*_________________________________________________________________*/
	
	bool HaplotypeTUCounts::operator==(GeneticUnitCounts & other){
		//cout << " comparing HaplotypeTUCounts ..." << endl;
HaplotypeTUCounts& h=(HaplotypeTUCounts&) other;
return this->GeneticUnitCounts::operator==((GeneticUnitCounts&)h) && getFrequencyHomo() == h.getFrequencyHomo();
/*
		if ( frequencyT != h.frequencyT || frequencyU != h.frequencyU || frequencyHomo != h.frequencyHomo)  
			return false;
		if (haplotype==NULL && h.haplotype==NULL) return true;
  if ((haplotype==NULL && h.haplotype!=NULL) || (haplotype==NULL && h.haplotype!=NULL))
   return false;
 //throw BadFormat("	bool HaplotypeTUCounts::operator==(HaplotypeTUCounts & h)");
		return * this->haplotype == * h.haplotype;
*/
	}


			/*_________________________________________________________________*/
	
	void HaplotypeTUCounts::sumProps(GeneticUnitCounts * other){

GeneticUnitCounts::sumProps(other);
HaplotypeTUCounts* h=(HaplotypeTUCounts*) other;
		this->frequencyHomo += h->frequencyHomo;
	}

			/*_________________________________________________________________*/
	
	void HaplotypeTUCounts::chop(HaplotypeTUCounts * & v1, HaplotypeTUCounts * & v2, int pos)
	{
		int lastPos = this->size() - 1;

		if ( pos < 0 || pos > lastPos){
			cerr << "Invalid chop" << endl;
			return;
		}
		
		int size1 = pos + 1;
		int size2 = this->size() - size1;

		v1 = new HaplotypeTUCounts(size1);
		v2 = new HaplotypeTUCounts(size2);

		// Copy data
		v1->setFrequencyT(getFrequencyT());
		v1->setFrequencyU(getFrequencyU());
		v1->frequencyHomo = frequencyHomo;

		v2->setFrequencyT(getFrequencyT());
		v2->setFrequencyU(getFrequencyU());
		v2->frequencyHomo = frequencyHomo;

		for (int i=0; i<size1; i++)
			((Haplotype*)v1->geneticUnit)->setAllele( (*this)[i], i);

		for (int i=size1; i<size(); i++)
			((Haplotype*)v2->geneticUnit)->setAllele( (*this)[i], i-size1);
	}
			

	




/*_________________________________________________________________*/

double HaplotypeTUCounts::getThirdFrequency()
{
return frequencyHomo;
}

/*_________________________________________________________________*/


void HaplotypeTUCounts::setThirdFrequency(double f)
{
frequencyHomo=f;
}


/*_________________________________________________________________*/

void HaplotypeTUCounts::print(ostream& output)
{
try
{
				GeneticUnitCounts::print(output);
//cout << "printing haplotypeTUCounts\n";
//cout << "frequency homo is: " <<  this->frequencyHomo <<"\n";
				output << "[" << this->frequencyHomo << "]";

}

		catch ( BasicException& be ) {be.addMessage ( "\ncalled from void HaplotypeTUCounts::print(ostream& out)" ); throw;};
				//return output;
}

};

#endif
