#ifndef __HaplotypeTUCounts_h__
#define __HaplotypeTUCounts_h__

namespace BIOS
{

	/**
	HaplotypeTUCounts: an haplotype and its transmitted/untransmitted frequencies in a given sample 
**/
	class HaplotypeTUCounts;
	typedef Set<HaplotypeTUCounts*>::Class SetOfHaplotypeTUCounts;



typedef Vector<HaplotypeTUCounts*>::Class HaplotypeTUCountsList;



	class HaplotypeTUCounts: public HaplotypeCounts
	{
		private:

			//Haplotype* haplotype;

		public:


			// number of haplotypes that came from homozygous genotype (=2xhomo genotypes)
			float frequencyHomo;

			/**
			* Constructor
			*/
			HaplotypeTUCounts ( int size=0 );

			HaplotypeTUCounts ( GeneticUnit* haplotype, float frequencyT, float frequencyU, float frequencyHomo );

			HaplotypeTUCounts ( GeneticUnitCounts& other );

			virtual ~HaplotypeTUCounts(){};



			bool isTransmitted();

			bool isNonTransmitted();

			

			/**
			*	Compares two haplotypes, inluding all properties
			*	@return true if haplotypes are equal
			*/
			bool operator== ( GeneticUnitCounts & h );

			

			/**
			*	Adds properties values of the given haplotype to the current one.
			*/
			void sumProps ( GeneticUnitCounts * h );

			/**
			*	splits the haplotype in two new haplotypes
			*	@param v1 First half
			*	@param v2 Second half
			*	@param pos Position to chop the haplotype. Indexed from 0. Must be between 0 and size()-1
			*/
			void chop ( HaplotypeTUCounts * & v1, HaplotypeTUCounts * & v2, int pos );

			/**
			*	Creates a new haplotype from the given one. The new haplotype has only the positions given in pos.
			*	@param[in] pos Vector with the positions to extract
			*	@param[in] length Number of elements in vector position
			*	@return New HaplotypeTUCounts with the positions indicated.
			*/
			//virtual HaplotypeTUCounts * filter ( int *pos, int length );


			GeneticUnitCounts* fromString ( string s ) {throw NonImplemented ( "HaplotypeTUCounts::fromString(string s)" );};

			virtual GeneticUnitCounts* clone() {return new HaplotypeTUCounts ( *this );};



virtual double getThirdFrequency();

virtual void setThirdFrequency(double f);

double getFrequencyT();
double getFrequencyU();
void setFrequencyT(double d);
void setFrequencyU(double d);
double getFrequencyHomo();

virtual void print(ostream& output);

			/**
			* Prints the HaplotypeTUCounts in the following manner: [ a0 a1 ... an ][frequency][T/U]
			* @param output Output stream
			* @param h Vector to print
			*/

//   ostream& print(ostream& output);
/*
			friend ostream& operator<< (ostream& output ,  HaplotypeTUCounts& h )
			{
h.print(output);
			}
*/
			/*
						static void print(HaplotypeTUCounts *h){
							for(int i=0; i< h->size()-1; i++)
								printf("%i ", (*h)[i]);
						}
				*/



	};



};

#endif
