

#ifndef __HaplotypeTUCountsTree_cpp__
#define __HaplotypeTUCountsTree_cpp__



namespace BIOS
{

	void HaplotypeTUCountsTree::updateFrequenciesFromLeaves()
	{
	  updateFrequenciesFromLeaves( begin() );
	}
	template <class T>
	double TreeWithBestNodes<T>::getBestScore(long wholeSampleT, long wholeSampleU){
		long t,u;
		
		vector<int> index;
		
		switch(best_k){
		case 0:
			index.push_back(0);
			break;
		case 1:
			index.push_back(1);
			index.push_back(2);
			break;
		case 2:
			index.push_back(3);
			index.push_back(4);
			index.push_back(5);
			break;
		}
		
		double sum=0;
		for(int i=0; i<index.size(); i++)
		{
			int id = index[i];
			t = (*best_nodes[id])->frequencyT;
			u = (*best_nodes[id])->frequencyU;
			sum += calcScore(t, u, wholeSampleT, wholeSampleU);				
						
		}
		return sum;
	}
	
	template <class T>
	double TreeWithBestNodes<T>::calcScore(long a, long c,long wholeSampleT, long wholeSampleU){
		double nchromoF = wholeSampleT + wholeSampleU;
	  	float na = wholeSampleT;
		float nc = wholeSampleU;

		double p = (a + c) / (double)nchromoF, pa = na / (double)nchromoF;
		double ea = na * p, ec = nc * p;
		double x = (a - ea) / sqrt((a + c) * pa * (1 - pa));
		return x;		
	}
	
	
	HaplotypeTUCountsTree::HaplotypeTUCountsTree()
	{
		leaves = NULL;
		interiorNodes = NULL;
	}

	HaplotypeTUCountsTree::~HaplotypeTUCountsTree()
	{
		zap(leaves);
		zap(interiorNodes);
		
	}
	
	void HaplotypeTUCountsTree::updateFrequenciesFromLeaves( iterator it )
	{
	  	sibling_iterator iChildren;
	  
		float sumT=0, sumU=0; // sum of frequencies of the cildren
		HaplotypeTUCounts * h = *it; // haplotype pointed by this node


		if ( number_of_children(it) > 0) { // if not a leave
		  for (iChildren = begin(it); iChildren != end(it); iChildren++){
			 // update children frequencies
			 updateFrequenciesFromLeaves( iChildren );
			 // sum the children values
			 sumT += (*iChildren)->frequencyT;
			 sumU += (*iChildren)->frequencyU;
			 
		  }
		  
		  	// update current node
			h->frequencyT = sumT;
			h->frequencyU = sumU;
		}


	}


	PartitionHaplotypeTUCountsVector * HaplotypeTUCountsTree::getBestLeaves()
	{
		PartitionHaplotypeTUCountsVector * p = new PartitionHaplotypeTUCountsVector();
		HaplotypeTUCountsVector * hv;

		switch ( best_k )
		{

			case 0:
				hv = getHaplotypeLeaves ( best_nodes[0] );
				p->insertSubsetCopy ( hv );
				delete hv;
// 			  (*(p[0]))->collapse();
// 				HaplotypeTUCountsVector * h;
				( *p ) [0]->collapse();
// 				h->collapse();
				break;

			case 1:
				hv = getHaplotypeLeaves ( best_nodes[1] );
				p->insertSubsetCopy ( hv );
				delete hv;
				hv = getHaplotypeLeaves ( best_nodes[2] );
				p->insertSubsetCopy ( hv );
				delete hv;
				( *p ) [0]->collapse();
				( *p ) [1]->collapse();
				break;

			case 2:
				hv = getHaplotypeLeaves ( best_nodes[3] );
				p->insertSubsetCopy ( hv );
				delete hv;
				hv = getHaplotypeLeaves ( best_nodes[4] );
				p->insertSubsetCopy ( hv );
				delete hv;
				hv = getHaplotypeLeaves ( best_nodes[5] );
				p->insertSubsetCopy ( hv );
				delete hv;
				( *p ) [0]->collapse();
				( *p ) [1]->collapse();
				( *p ) [2]->collapse();
				break;
		}

		return p;
	}
	
	HaplotypeTUCountsVector * HaplotypeTUCountsTree::getHaplotypeLeaves ( iterator node )
	{
		HaplotypeTUCountsVector * v = new HaplotypeTUCountsVector();

		for(leaf_iterator l=begin_leaf(node); l != end_leaf(node); l++){
		  v->push_back ( *l );
		}

		return v;

	}
	
	HaplotypeTUCountsTree * HaplotypeTUCountsTree::getCloneDuplicatingLeaves()
	{

		// Create a new tree
		HaplotypeTUCountsTree * newTree = new HaplotypeTUCountsTree( *this );
		
		// Create new sets of nodes
		newTree->leaves = new HaplotypeTUCountsVector();
		newTree->interiorNodes = new HaplotypeTUCountsVector();		

		// Iterate duplicating nodes
		HaplotypeTUCountsTree::pre_order_iterator iterator = newTree->begin();
		while( iterator != newTree->end() ){
			
			BIOS::HaplotypeTUCounts * h;
			h = (*iterator)->clone();
			
			if ( iterator.number_of_children() == 0 ) // leave
				newTree->leaves->push_back(h);
			else // interior node
				newTree->interiorNodes->push_back(h);
				
			(*iterator) = h; // replace the node
				
			iterator++;
			
		}
		
		return newTree;
		
	}
	
	int HaplotypeTUCountsTree::find_position_in_array(HaplotypeTUCountsTree::leaf_iterator &it, HaplotypeTUCountsVector *v)
	{
		bool found=false;
		
		int pos=-1;
		
		for(int i=0; i<v->size() && !found; i++){
			if  ( (*it)->hasSameAllelesAs((*v)[i]) ){
				found = true;
				pos = i;
			}
		}
		
		return pos;
		
	}
	
	void HaplotypeTUCountsTree::collapse(){
		
		// collapse leaves
		HaplotypeTUCountsVector * newLeaves = this->leaves->clone();
		newLeaves->collapse();
		
		// create array of used leaves
		bool positionsUsed[ newLeaves->size() ];
		for(int i=0; i<newLeaves->size(); i++) positionsUsed[i] = false;
		
		// Update nodes in the tree 
		
		HaplotypeTUCountsTree::leaf_iterator it = this->begin_leaf();
		while(it != this->end_leaf())
		{
			
			int pos = find_position_in_array(it, newLeaves);
			
			if( positionsUsed[pos] == false ){
			// new element	
				positionsUsed[pos] = true;
				(*it) = (*newLeaves)[pos];
				it++;
			}
			else{
			// old element
				it = erase(it);
			}
		}
		
		// update leaves vector
		zap(this->leaves);
		this->leaves = newLeaves;
		
		
	}
	
	void HaplotypeTUCountsTree::print(){
	  kptree::print_subtreeOfPointers_bracketed( *this, begin() );
	  cout << endl;
	}
  

};
;  // Fin del Namespace

#endif

