
#ifndef __HaplotypeTUCountsVector_cpp__
#define __HaplotypeTUCountsVector_cpp__

void print (BIOS::HaplotypeTUCountsVector *hv)
{
  cout << *hv << endl;
}



void print (BIOS::PartitionHaplotypeTUCountsVector *p)
{
  cout << *p << endl;
}


namespace BIOS
{
/*
  template <>
  void HaplotypeTUCountsList::removeObjects (HaplotypeTUCountsList::iterator it, HaplotypeTUCountsList::iterator it2)
  {
    this->erase (it, it2);
  };
*/
  /*_____________________________________________________*/

  HaplotypeTUCountsVector::~HaplotypeTUCountsVector()
  {
    //for(int i=0; i< size(); i++){
    //	delete (*this)[i];
    //}
  };

  /*_____________________________________________________*/
/*
  void HaplotypeTUCountsVector::Delete (HaplotypeTUCountsVector * & hv)
  {
    hv->free();
    delete hv;
    hv = NULL;
  }

  /*_____________________________________________________*/

/*
  void HaplotypeTUCountsVector::Delete()
  {
    this->free();
    delete this;
  }

  /*_____________________________________________________*/

/*
  void HaplotypeTUCountsVector::free()
  {
    for (int i=0; i< size(); i++)
    {
      delete (*this) [i];
//   (*this)[i]=NULL;
//to review
    }
  };

  /*_____________________________________________________*/
/*
  void HaplotypeTUCountsVector::remove (int index)
  {
    delete (*this) [ index ] ;
    this->erase (this->begin() + index );
  }

  /*_____________________________________________________*/

  HaplotypeTUCountsVector::HaplotypeTUCountsVector (HaplotypeTUCountsVector & v): HaplotypeTUCountsList(v)
  {
/*
    // For each haplotype in v
    for (int i=0; i< v.size(); i++)
    {

      // Create a copy of the haplotype
      HaplotypeTUCounts * h = new HaplotypeTUCounts ( * ( v[i] ) ) ;

      // Insert the copy in the new vector
      this->push_back (h);


    }
*/
  };

  /*________________________________________________________________________________________*/

  HaplotypeTUCountsVector* HaplotypeTUCountsVector::clone()
  {
    return new HaplotypeTUCountsVector (*this);
  }

  /*________________________________________________________________________________________*/
  
  
	HaplotypeTUCountsVector* HaplotypeTUCountsVector::expand()
	{
	  HaplotypeTUCountsVector * out = new HaplotypeTUCountsVector();

	  
    for (int i=0; i< size(); i++)
    {

      // Create a copy of the haplotype
      HaplotypeTUCounts * h = (*this)[i];
		
		// transmissions
		for(int j=0; j< h->frequencyT; j++){
			// Create a haplotype 
			HaplotypeTUCounts * hT1 = new HaplotypeTUCounts ( *h ) ;
			hT1->frequencyT=1;
			hT1->frequencyU=0;
			
			// insert it in out
			out->push_back (hT1);
		}
		
		// non transmissions
		for(int j=0; j< h->frequencyU; j++){
			// Create a haplotype 
			HaplotypeTUCounts * hU1 = new HaplotypeTUCounts ( *h ) ;
			hU1->frequencyT=0;
			hU1->frequencyU=1;
			
			// insert it in out
			out->push_back (hU1);
		}		

    }
	  return out;
	}
  
  /*________________________________________________________________________________________*/  

  int HaplotypeTUCountsVector::split (HaplotypeTUCountsVector * & v1, HaplotypeTUCountsVector * &v2, int last_marker, bool toLeft)
  {

    int marker = nextDifferentMarker (last_marker, toLeft);

    if ( marker < 0 )
    {
      v1 = NULL;
      v2 = NULL;
      return -1 ; // No marker found
    }

    v1 = new HaplotypeTUCountsVector;
    v2 = new HaplotypeTUCountsVector;

    for (int i=0; i< size(); i++)
    {
      if ( (* (*this) [i] ) [marker] == 1)
      {
        v1->push_back ( (*this) [i] ) ;
      }
      else
      {
        v2->push_back ( (*this) [i] ) ;
      }
    }

    return marker;


  };

  /*_____________________________________________________*/

  void HaplotypeTUCountsVector::chop (HaplotypeTUCountsVector * & v1, HaplotypeTUCountsVector * &v2, int pos)
  {

    if ( size() <= 0 )
    {
      cerr << " Invalid chop in HaplotypeTUCountsVector::chop" ;
      v1 = NULL;
      v2 = NULL;
      return;
    }
    HaplotypeTUCounts * h1, *h2;
    v1 = new HaplotypeTUCountsVector;
    v2 = new HaplotypeTUCountsVector;

    for (int i=0; i< size(); i++)
    {
      // Chop haplotype
      (*this) [i]->chop (h1, h2, pos);
      // insert each side on the corresponding vector
      v1->push_back ( h1 ) ;
      v2->push_back ( h2 ) ;

    }
    //v1->free();
    //delete v1;
    //v2->free();
    //delete v2;

    //cout <<"V1: " <<  *v1 << endl;
    //cout <<"V2: " <<  *v2 << endl;
    //cout << "collapsing v1" << endl;
    v1->collapse();
    //cout << "collapsing end v1" << endl;
    v2->collapse();

  };

  /*_____________________________________________________*/

  HaplotypeTUCountsVector * HaplotypeTUCountsVector::filter (int *pos, int length)
  {

    if ( size() <= 0 )
    {
      cerr << " Invalid chop in HaplotypeTUCountsVector::chop" ;
      return NULL;
    }

    HaplotypeTUCountsVector *v1 = new HaplotypeTUCountsVector;
    HaplotypeTUCounts * h1;

    for (int i=0; i< size(); i++)
    {
      // Chop haplotype
      h1 = (*this) [i]->filter (pos, length);
      // insert the new vector
      v1->push_back ( h1 );
    }

    v1->collapse();
    return v1;

  };

  /*_____________________________________________________*/

  void HaplotypeTUCountsVector::collapse()
  {

    if ( size() == 0)
      return;

    int i = 0;
    while ( i < size() )
    {
      int j = i+1;
      while ( j< size() )
      {
        if ( (*this) [i]->hasSameAllelesAs ( (*this) [j] ) )
        {
          //cout << i << " equals " << j << endl;
          (*this) [i]->sumProps ( (*this) [j] );
          removeNode ( getNode(j) );
          //delete (*this)[j] ;
          //this->erase (this->begin()+j);
          //cout << *this << endl;
          j=i;
        }
        j++;
      }
      i++;
    }





  }

  /*_____________________________________________________*/

	void HaplotypeTUCountsVector::copyFrequencies(HaplotypeTUCountsVector * & v1)
	{
	  	for(int i=0; i<size(); i++){
			(*this)[i]->frequencyT = (*v1)[i]->frequencyT;
			(*this)[i]->frequencyU = (*v1)[i]->frequencyU;
			(*this)[i]->frequencyHomo = (*v1)[i]->frequencyHomo;
		}
	}

  /*_____________________________________________________*/

  void HaplotypeTUCountsVector::chopInHalf (HaplotypeTUCountsVector * & v1, HaplotypeTUCountsVector * &v2)
  {

    if ( size() <= 0 )
    {
      cerr << " Invalid chop in HaplotypeTUCountsVector::chop" ;
      v1 = NULL;
      v2 = NULL;
      return;
    }

    int position = ( (*this) [0])->size() /2-1;

    chop (v1,v2, position);

  }

  /*_____________________________________________________*/

  void HaplotypeTUCountsVector::insertClone (HaplotypeTUCountsVector * v)
  {

    for (int i=0; i< v->size(); i++)
    {
      HaplotypeTUCounts * h = new HaplotypeTUCounts ( * ( (*v) [i] ) ) ;

      // Insert the copy in the new vector
      this->push_back (h);

    }

  };

  /*
  	void HaplotypeTUCountsVector::insertVector(HaplotypeTUCountsVector hv)
  	{
  		for (int i=0; i< hv.size(); i++)
  			this->push_back( hv[i] );

  	};
  */

  /*_____________________________________________________*/

  int HaplotypeTUCountsVector::nextDifferentMarker (int last_marker, bool toLeft)
  {
    bool found;


    if ( this->size() == 0)
      return -2; // No haplotypes to compares
    if ( this->size() == 1)
      return -1; // Only one, so all haplotypes are the same

    if (toLeft)
    {
      int haplotypeSize = ( (*this) [0])->size();
      int first=-1;

      if (last_marker == -1 )
        last_marker = haplotypeSize;

      // Compare by pairs
      for (int i=0; i < this->size() -1 ; i++)
      {

        found=false;
        HaplotypeTUCounts *h1 = (*this) [ i ];
        HaplotypeTUCounts *h2 = (*this) [ i+1 ];

        for (int m=last_marker-1; m>=0 & ! found;m--)
        {
          if ( (*h1) [m] != (*h2) [m] )
          {
            found = true;
            if (m>first)
              first = m;
          }
        }


      }

      return first;





    }
    else  // to the right
    {
      int haplotypeSize = ( (*this) [0])->size();
      int first=haplotypeSize;


      // Compare by pairs
      for (int i=0; i < this->size() -1 ; i++)
      {

        found=false;
        HaplotypeTUCounts *h1 = (*this) [ i ];
        HaplotypeTUCounts *h2 = (*this) [ i+1 ];

        for (int m=last_marker+1; m<h1->size() & ! found;m++)
        {
          if ( (*h1) [m] != (*h2) [m] )
          {
            found = true;
            if (m<first)
              first = m;
          }
        }


      }

      if ( first == haplotypeSize)
        return -1; // All haplotypes are the same
      else
        return first;
    }


  }

  /*_____________________________________________________*/

  int HaplotypeTUCountsVector::firstDifferentMarker()
  {
    bool found;


    if ( this->size() == 0)
      return -2; // No haplotypes to compares
    if ( this->size() == 1)
      return -1; // Only one, so all haplotypes are the same

    int haplotypeSize = ( (*this) [0])->size();
    int first=haplotypeSize;


    // Compare by pairs
    for (int i=0; i < this->size() -1 ; i++)
    {

      found=false;
      HaplotypeTUCounts *h1 = (*this) [ i ];
      HaplotypeTUCounts *h2 = (*this) [ i+1 ];

      for (int m=0; m<h1->size() & ! found;m++)
      {
        if ( (*h1) [m] != (*h2) [m] )
        {
          found = true;
          if (m<first)
            first = m;
        }
      }


    }

    if ( first == haplotypeSize)
      return -1; // All haplotypes are the same
    else
      return first;


  }

  /*_____________________________________________________*/

  double HaplotypeTUCountsVector::getZstatistic (double p)
  {
    double a; // number of disease-associated haplotypes (sum of T frequencies)
    double n; // the total number of haplotypes (sum of frequencies)
    double z;

    // Calculate a
    a = getTransmittedFreqSum();

    // Calculate n
    n= getFreqSum();

    // Calculate z statistic
    if ( n == 1)
      z = 0;
    else
      z = ( a - n*p ) / ( sqrt ( n*p* (1.0-p) ) ) ;

    return z;


  }

  /*_____________________________________________________*/


  float HaplotypeTUCountsVector::getTransmittedCountProportion()
  {
    int t_count = getTransmittedCount();
    return (float) t_count / (float) size();
  };

  /*_____________________________________________________*/

  double HaplotypeTUCountsVector::getFreqSum()
  {
    double sum=0;
    for ( int i=0; i< size(); i++)
      //sum += (*this)[i]->frequency;
      sum += (*this) [i]->frequencyT + (*this) [i]->frequencyU;

    return sum;
  };

  /*_____________________________________________________*/

  double HaplotypeTUCountsVector::getTransmittedFreqSum()
  {
    double sum=0;
    for ( int i=0; i< size(); i++)
    {
      //if (  (*this)[i]->transmitted )
      sum += (*this) [i]->frequencyT;
    }
    return sum;
  }

  /*_____________________________________________________*/

  double HaplotypeTUCountsVector::getNonTransmittedFreqSum()
  {
    double sum=0;
    for ( int i=0; i< size(); i++)
    {
      //if (  ! (*this)[i]->transmitted )
      sum += (*this) [i]->frequencyU;
    }
    return sum;
  }

  /*_____________________________________________________*/


  bool HaplotypeTUCountsVector::operator== (HaplotypeTUCountsVector & h)
  {
    //cout << "Calling comparision ..." << endl;
    if ( size() != h.size() )
      return false;

    for ( int i=0; i< size(); i++)
    {
      //cout << *(*this)[i] << endl;
      //cout << *h[i] << endl;
      if (  * (*this) [i]  != *h[i] )
        return false;
    }
    return true;
  };

  /*_____________________________________________________*/

  bool HaplotypeTUCountsVector::operator!= (HaplotypeTUCountsVector & h)
  {
    //cout << "Calling differents ..." << endl;
    return ! (*this == h);
  }

  /*_____________________________________________________*/

  PartitionHaplotypeTUCountsVector::PartitionHaplotypeTUCountsVector()
  {
    //split_marker = -1;
  };

  /*_____________________________________________________*/

  PartitionHaplotypeTUCountsVector::PartitionHaplotypeTUCountsVector(PartitionHaplotypeTUCountsVector& other): VectorOfHaplotypeTUCountsVectors(other)
  {
splitMarkers=other.splitMarkers;
    //split_marker = -1;
  };

  /*_____________________________________________________*/


  PartitionHaplotypeTUCountsVector::~PartitionHaplotypeTUCountsVector()
  {
    //for (int i=0; i< size(); i++)
     // delete (*this) [i];

  };

  /*________________________________________________________________________________________*/

  PartitionHaplotypeTUCountsVector* PartitionHaplotypeTUCountsVector::clone()
  {
    return new PartitionHaplotypeTUCountsVector (*this);
  }

 /*_____________________________________________________*/


/*
  void PartitionHaplotypeTUCountsVector::free()
  {
    for (int i=0; i< size(); i++)
      (*this) [i]->free();

  };

  /*_____________________________________________________*/
/*
  template <>
  void VectorOfHaplotypeTUCountsVectors::removeObjects (VectorOfHaplotypeTUCountsVectors::iterator it, VectorOfHaplotypeTUCountsVectors::iterator it2)
  {
    this->erase (it, it2);
  };

  /*_____________________________________________________*/

  double PartitionHaplotypeTUCountsVector::getZstatistic (double proportion)
  {

    // We are interested only in
    // subtrees in which the proportion of disease-associated
    // haplotypes is greater than expected, zi > 0 (i.e., we assume
    // the mutation to increase the risk of the disease). (From 2006.Sevon)


    double z=0;
    double z_i=0;

    // For each haplotype set, Calculate z statistic and p value for the set
    for ( int i=0; i< size(); i++)
    {
      HaplotypeTUCountsVector * hv = (*this) [i];
      z_i = hv->getZstatistic (proportion);
      if ( z_i > 0)
        z += z_i;
    }

    return z;

  };
  /*_____________________________________________________*/

  void PartitionHaplotypeTUCountsVector::insertSubset (HaplotypeTUCountsVector *hv, int splitMarker)
  {
    splitMarkers.push_back (splitMarker);
    push_back (hv);
  }

  /*_____________________________________________________*/

  void PartitionHaplotypeTUCountsVector::insertSubsetCopy (HaplotypeTUCountsVector *hv, int splitMarker)
  {

//     HaplotypeTUCountsVector *v_copy = new HaplotypeTUCountsVector;
//     for ( int h = 0; h < hv->size(); h++){
//       //v_copy->push_back ( (*hv) [h] );
// 		HaplotypeTUCounts * original = (*hv)[h];
// 		v_copy->push_back ( original->clone() );
// 	 }
		HaplotypeTUCountsVector *v_copy = hv->clone();
		

    insertSubset (v_copy, splitMarker);
  }
  /*
  	TDTtable * PartitionHaplotypeTUCountsVector::createTable()
  	{
  		double t_freq, u_freq;
  		TDTtable * t = new TDTtable( size() );

  		// Fill each column
  		for (int i=0; i < size(); i++){
  			t_freq = (*this)[i]->getTransmittedFreqSum();
  			u_freq =  (*this)[i]->getFreqSum() - t_freq;
  			t->setValue(0,i, t_freq);
  			t->setValue(1,i, u_freq);
  		}

  		return t;
  	};
  */




};

#endif
