/* File: MultimarkerMeasure.h */


#ifndef __MultimarkerMeasureHapUAndT_cpp__
#define __MultimarkerMeasureHapUAndT_cpp__





//using namespace stats;

namespace BIOS {


/**********************************/
/* DEFINITIONS OF THE FUNCTIONS */
/**********************************/



///////////////////
//// public ////////
///////////////////

/*____________________________________________________________ */
/*
MultimarkerMeasureHapUAndT* MultimarkerMeasureHapUAndT::clone()
{
return new MultimarkerMeasureHapUAndT(*this);
} 
/*_________________________________________________________________*/

void MultimarkerMeasureHapUAndT::set(MultimarkerMeasureHapUAndT& source)
{
tdt=source.tdt;
//haplotypeFreqs=NULL;
haplotypeFreqs=NULL;
trioCounters=NULL;
totalHaplotypes=source.totalHaplotypes;
totalDifferentHaplotypes=source.totalDifferentHaplotypes;
if (source.trioCounters=NULL) trioCounters=new TrioCounters(*source.trioCounters);
if (source.haplotypeFreqs!=NULL) haplotypeFreqs=new HeteroListPair<ParentalHaplotypes, double>(*source.haplotypeFreqs);
if (source.haplotypeTable!=NULL) haplotypeTable=new MultidimensionalEmptyTable<int>(*source.haplotypeTable);
}
/*_________________________________________________________________*/

MultimarkerMeasureHapUAndT::MultimarkerMeasureHapUAndT(MultimarkerMeasureHapUAndT& source)
{
set(source);
}
/*_________________________________________________________________*/

MultimarkerMeasureHapUAndT::MultimarkerMeasureHapUAndT(TrioCounters* source)
{
trioCounters=source;
setHaplotypeTable();
setTotalDifferentHaplotypes();
haplotypeFreqs=NULL;
}
/*_________________________________________________________________*/

MultimarkerMeasureHapUAndT::MultimarkerMeasureHapUAndT(SNPPos Pos[], SNPPos totalPos, TrioSample * samp, int gender, int affectation, BayesType  Bay, float alphaBayes, float distance)
{
trioCounters=new TrioCounters(Pos, totalPos, samp, gender, affectation, false); // false for non-tdt (homo included)
setHaplotypeTable();
setTotalDifferentHaplotypes();
haplotypeFreqs=NULL;
}
/*_________________________________________________________________*/

void MultimarkerMeasureHapUAndT::setTotalDifferentHaplotypes()
{
totalDifferentHaplotypes=1;
for (int i=0; i<trioCounters->totalPos; i++)
totalDifferentHaplotypes=totalDifferentHaplotypes*trioCounters->totalAlleles[i];
}
/*_________________________________________________________________*/

void  MultimarkerMeasureHapUAndT::empty()
{
 zap(trioCounters);
 zap(haplotypeFreqs);
 zap(haplotypeTable);
	};
/*_________________________________________________________________*/
/*
HeteroListPair<long long int, double>* MultimarkerMeasureHapUAndT::getComposedList(longLongList *fatherHaps, longLongList* motherHaps)
{
long long int pos, pos2;
HeteroListPair<long long int, double>* result=new HeteroListPair<long long int, double>();
longLongList* haps=fatherHaps;
longLongList::iterator it;
for (int parent=0; parent<2; parent++)
{
if (parent==1) haps=motherHaps;
for (int i=0; i<haps->size(); i++)
{
pos=haps->getElement(i);
it=result->First->findElement(pos);
if (it==result->First->end())
{
 result->First->insertElement(pos);
 result->Second->insertElement(1); 
}
else
{
pos2=result->First->getPosition(it);
(*result->Second)[pos2]=(*result->Second)[pos2]+1;
}
}
}
return result;
}
/*_________________________________________________________________*/

MultimarkerMeasureHapUAndT::MultimarkerMeasureHapUAndT()
{
trioCounters=NULL;
haplotypeTable=NULL;
haplotypeFreqs=NULL;
totalHaplotypes=0;
}
/*______________________________________________________*/

void MultimarkerMeasureHapUAndT::setHaplotypeTable()
{

intList* dimList=new intList();
for (int i=0; i<trioCounters->totalPos; i++)
 dimList->insertElement(trioCounters->totalAlleles[i]);
haplotypeTable=new MultidimensionalEmptyTable<int>(dimList);
zap(dimList);
}
/*_______________________________________________________________*/
/*
void MultimarkerMeasureHapUAndTUnknownHaps::setHaplotypeFreqs()
{
//zap(this->haplotypeFreqs);
this->haplotypeFreqs=new HeteroListPair<long long int, double>();
this->haplotypeFreqsU=new HeteroListPair<long long int, double>();
for (int i=0;i<2;i++)
{
if (i==0) {this->hapFreqs=this->haplotypeFreqs; hapFreqsTab=haplotypeFreqsTab;}
else  {this->hapFreqs=this->haplotypeFreqsU; hapFreqsTab=haplotypeFreqsTabU;}
for (long long int i=0; i<hapFreqsTab->getSize(); i++)
if (hapFreqsTab->getValue(i)>0)
{
 this->hapFreqs->First->insertElement(i);
 this->hapFreqs->Second->insertElement(hapFreqsTab->getValue(i)*this->totalHaplotypes/2);
}
}
}

/*_______________________________________________________________*/
/*
Pair<MultidimensionalTable<double>*>* MultimarkerMeasureHapUAndTUnknownHaps::getHaplotypeFreqsTab(int type)
{
Pair<MultidimensionalTable<double>*>* result=new Pair<MultidimensionalTable<double>*>();
result->First=this->getInitialEstimation(type);
result->Second=new MultidimensionalTable<double>(*result->First);
//cout <<"\nrrr\n";
multimarkerMeasure->tableGenotypes->estimateMLE(result->First, multimarkerMeasure->genotypeAbsFreqsTab, multimarkerMeasure->totalGenotypes, 1000, false, result->Second);
return result;
}
/*_______________________________________________________________*/
/*
void MultimarkerMeasureHapUAndTUnknownHaps::setHaplotypeFreqsTab()
{
Pair<MultidimensionalTable<double>*>* result=getHaplotypeFreqsTab(0);
if (result->First==NULL) result=getHaplotypeFreqsTab(1);
if (result->First==NULL)
throw NullValue(" at MultimarkerMeasureHapUAndTUnknownHaps::setHaplotypeFreqsTab");
haplotypeFreqsTab=result->First;
haplotypeFreqsTabU=result->Second;
zap(result);
}

/*_________________________________________________________________*/
/*
MultimarkerMeasureHapUAndT * MultimarkerMeasureHapUAndT::getPermutation ()
{
cout <<"herepermutation??\n";
//cout <<"orig bef:" << *multimarkerMeasure->genotypeFreqs; 
MultimarkerMeasureHapUAndT *result=new MultimarkerMeasureHapUAndT();
result->multimarkerMeasure=multimarkerMeasure->getPermutation();
//cout <<"\norig:" << *multimarkerMeasure->genotypeFreqs <<" versus new:" << *result->multimarkerMeasure->genotypeFreqs;
zap(result->haplotypeFreqs);
zap(result->haplotypeFreqsU);
result->setTableHaplotypes();
result->setTotalDifferentHaplotypes();
result->totalHaplotypes=totalHaplotypes;
//cout <<"\norig2:" << *multimarkerMeasure <<" versus new:" << *result->multimarkerMeasure;
return result;
}
/*____________________________________________________________ */
/*

double MultimarkerMeasureHapUAndT::getStandardizedSimilarityMeasure (IndCategory ic)
// for Length contrast test
{
cout << "Error, MultimarkerMeasureHapUAndT::getStandardizedSimilarityMeasure is undefined";
exit(0);
//return getTest(1);
}


/*____________________________________________________________ */

/*
double MultimarkerMeasureHapUAndT::getSimilarityMeasure (IndCategory ic)
// for Length contrast test
{
cout << "Error, MultimarkerMeasureHapUAndT::getStandardizedSimilarityMeasure is undefined";
exit(0);
//return getTest(0);
}

/*____________________________________________________________ */
/*

double MultimarkerMeasureHapUAndT::getSignedRankTest (bool Wilcoxon, IndCategory ic)
// for Length contrast test
{
cout << "Error, MultimarkerMeasureHapUAndT::getSignedRankTest is undefined";
exit(0);
}


/*____________________________________________________________ */


double MultimarkerMeasureHapUAndT::getSimilarityMeasure (IndCategory ic)
// for Length contrast test
{
return getTest(0, ic);
}
/*____________________________________________________________ */


double MultimarkerMeasureHapUAndT::getSignedRankTest (bool Wilcoxon, IndCategory ic)
// for Length contrast test
{
//cout << "\nsigned rank is:" << 2+!Wilcoxon;
return getTest(2+!Wilcoxon, ic);
}

/*___________________________________________________*/

double MultimarkerMeasureHapUAndT::getLengthMeasure (int*pos1T, int* pos2T, int* pos1U, int* pos2U) 
{
int resultT=0, resultU=0, maxResultT=0, maxResultU=0;
for (int i=0; i< trioCounters->totalPos; i++)
{
//cout <<"\n" << pos1T[i] <<"-" << pos2T[i] << "-" << pos1U[i] << "-" << pos2U[i];
if (pos1T[i]==pos2T[i]) {resultT++;} else {if (resultT>maxResultT) maxResultT=resultT; resultT=0;};
if (pos1U[i]==pos2U[i]) {resultU++;} else {if (resultU>maxResultU) maxResultU=resultU; resultU=0;};
}
if (resultT>maxResultT) maxResultT=resultT; 
if (resultU>maxResultU) maxResultU=resultU; 
return (maxResultT-maxResultU)/(double)trioCounters->totalPos;
};


/*____________________________________________________________ */

BidimensionalTable<double>* MultimarkerMeasureHapUAndT::getMultiallelicFreqs(SNPPos a, SNPPos b, Transmission trans)
{
ParentalHaplotypes parentalHaplotypes;
BidimensionalTable<double>*result=new BidimensionalTable<double>(trioCounters->totalAlleles[a], trioCounters->totalAlleles[b]); 
int pos, *positions, cont=0;
double totalHaplotypes=this->totalHaplotypes,  SB=0, p, freq=0;
if (trans!=ut) totalHaplotypes=this->totalHaplotypes/2;
for (longLongList::iterator pointer=haplotypeFreqs->First->begin(); pointer!=haplotypeFreqs->First->end(); pointer++)
{
parentalHaplotypes=hapFreqs->First->getElement(pointer);
freq=haplotypeFreqs->Second->getElement(cont);
for (int i=0; i<2; i++)
for (int parent=0; parent<2; parent++)
{
if (i==0) if (parent==0) pos=parentalHaplotypes.fatherT; else pos=parentalHaplotypes.motherT;
else if (parent==0) hpos=parentalHaplotypes.fatherU; else pos=parentalHaplotypes.motherU;
if ((i==0 && trans==t) || (i==1 && trans==u) || trans==ut)
{
positions=haplotypeTable->getPositions(pos);
result->addValue(positions[a], positions[b], freq/totalHaplotypes);
zaparr(positions);
}
}
cont++;
}
return result;
}

/*____________________________________________________________ */
/*
double MultimarkerMeasureHapUAndT::getGenericTDT (int test, IndCategory ic)
{
cout << "Error, MultimarkerMeasureHapUAndT::getGenericTDT is undefined";
exit(0);}


/*____________________________________________________________ */

double MultimarkerMeasureHapUAndT::getSquareSB (bool df)
{
return getSquareSB(df, t)-getSquareSB(df, u);
}
/*____________________________________________________________ */

double MultimarkerMeasureHapUAndT::getEntropySB (bool df)
{
return getEntropySB(df, u)-getEntropySB(1, t);
}
/*____________________________________________________________ */

double MultimarkerMeasureHapUAndT::getMultimarkerDPrime (int type, bool df)
{
//cout << "\ndprime for t:" << getMultimarkerDPrime(type, df, t) <<", and dprime for u:" << getMultimarkerDPrime(type, df, u);
return getMultimarkerDPrime(type, df, t)-getMultimarkerDPrime(type, df, u);
}


/*____________________________________________________________ */

double MultimarkerMeasureHapUAndT::getLinearSB (bool df, Transmission trans)
{
// S_B=-sum_{foreach n hap presents in the sample} p_i 
double totalHaplotypes=this->totalHaplotypes;
if (trans!=ut) totalHaplotypes=totalHaplotypes/2;
double SB=0, p, counts;
int c=0;
ParentalHaplotypes parentalHaplotypes;

c=0;
for (longLongList::iterator pointer=haplotypeFreqs->First->begin(); pointer!=haplotypeFreqs->First->end(); pointer++)
{
parentalHaplotypes=haplotypeFreqs->First->getElement(pointer);
counts=haplotypeFreqs->Second->getElement(c);
if (i==0) if (parent==0) pos=parentalHaplotypes.fatherT; else pos=parentalHaplotypes.motherT;
else if (parent==0) hpos=parentalHaplotypes.fatherU; else pos=parentalHaplotypes.motherU;
if ((i==0 && trans==t) || (i==1 && trans==u) || trans==ut)
if (!haplotypeTable->inferredFrequency(pos) || !df)
{
p=counts/totalHaplotypes; 
if (p>0) SB=SB+p;
}
c++;
}
//cout << "\ntransmission:" << this->transmission <<" linearSB:" << SB;
return SB;
}
/*____________________________________________________________ */

double MultimarkerMeasureHapUAndT::getSquareSB (double df, Transmission trans)
{
double totalHaplotypes=this->totalHaplotypes,  SB=0, p, counts;
if (trans!=ut) totalHaplotypes=totalHaplotypes/2;

int c;
c=0;
for (longLongList::iterator pointer=haplotypeFreqs->First->begin(); pointer!=haplotypeFreqs->First->end(); pointer++)
{
parentalHaplotypes=haplotypeFreqs->First->getElement(pointer);
counts=haplotypeFreqs->Second->getElement(c);
if (i==0) if (parent==0) pos=parentalHaplotypes.fatherT; else pos=parentalHaplotypes.motherT;
else if (parent==0) hpos=parentalHaplotypes.fatherU; else pos=parentalHaplotypes.motherU;
if ((i==0 && trans==t) || (i==1 && trans==u) || trans==ut)
if (!haplotypeTable->inferredFrequency(pos) || !df)
{
if (!df || !haplotypeTable->inferredFrequency(hapFreqs->First->getElement(pointer)))
{
p=counts/totalHaplotypes; 
if (p>0) SB=SB+p*p;
}
}
c++;
}
return SB;
}

/*____________________________________________________________ */


void MultimarkerMeasureHapUAndT::normalizeFreqs (double total)
{
for (doubleList::iterator it=haplotypeFreqs->Second->begin(); it<haplotypeFreqs->Second->end(); it++)
 (*hapFreqs->Second)[haplotypeFreqs->Second->getPosition(it)]=haplotypeFreqs->Second->getElement(it)/total;
}
/*____________________________________________________________ */


double MultimarkerMeasureHapUAndT::getEntropySB (bool df, Transmission trans)
{
// S_B=-sum_{foreach n hap presents in the sample} p_i log p_i
double totalHaplotypes=this->totalHaplotypes,  SB=0, p, counts;
if (trans!=ut) totalHaplotypes=totalHaplotypes/2;
int c=0;
for (longLongList::iterator pointer=haplotypeFreqs->First->begin(); pointer!=haplotypeFreqs->First->end(); pointer++)
{
parentalHaplotypes=haplotypeFreqs->First->getElement(pointer);
counts=haplotypeFreqs->Second->getElement(c);
if (i==0) if (parent==0) pos=parentalHaplotypes.fatherT; else pos=parentalHaplotypes.motherT;
else if (parent==0) hpos=parentalHaplotypes.fatherU; else pos=parentalHaplotypes.motherU;
if ((i==0 && trans==t) || (i==1 && trans==u) || trans==ut)
{
if (!df || !haplotypeTable->inferredFrequency(hapFreqs->First->getElement(pointer)))
{
p=counts/totalHaplotypes; 
if (p>0) SB=SB-p*log2(p);
}
}
c++;
}
return SB;
}
/*____________________________________________________________ */


double MultimarkerMeasureHapUAndT::getEntropySE(int df)
{
//entropy in equilibrium
double SE=0, p;
int* hap;
double counts;
for (long long int i=0; i<totalDifferentHaplotypes; i++)
{
hap=haplotypeTable->getPositions(i);
if (!df || !haplotypeTable->inferredFrequency(i))
{
p=1;
for (int j=0; j<trioCounters->totalPos;j++)
{
 p=p*trioCounters->SNPAbsFreqs[j][hap[j]]/(trioCounters->totalGenotypes*2);
//cout <<"\nfreq is:" << this->SNPAbsFreqs[j][hap[j]] <<" and totalgens is:" << this->totalGenotypes*2;
}
//cout << "totalhaps:" << totalHaplotypes <<" vesus :" << this->totalGenotypes*2;
if (p>0) SE=SE-p*log2(p);
}
zaparr(hap);
}
//cout <<"entropySEis: " << SE <<", entropy SB is: " << SB;
//end();
return SE;

}



/*____________________________________________________________ */


double MultimarkerMeasureHapUAndT::getEntropyBasedLD (int df, Transmission trans)
{
// it computes Entropy-based LD (Nothnage et al. 2002) defined as S_E-S_B (deviation between entropy S_B and entropy in the equilibrium case S_E)
// S_E=-sum_{foreach haplotype configuration} q_i log q_i
// q_i=prod_{foreach SNP k} p_k^I(k=1) (1-p_k)^I(k=2)
// with I being the identity function, so for each position we use the allele frequency for the allele in the current haplotype
// S_B=-sum_{foreach n haps present in the sample} p_i log p_i
return getEntropySE(df)-getEntropySB(df, trans);
}

/*____________________________________________________________ */

double MultimarkerMeasureHapUAndT::getDPrime(BidimensionalTable<double> * multiallelicFreqs, int measure, int df)
{
// measure can be:
//0: unweighted
//1: weighted by allele freqs
//2: weighted by hapfreqs 
//3: weighted by entropy
// if df, degrees of freedom are taken into account
double DPrime=0, partD, weight=1;
int totalAllelesSNP1=multiallelicFreqs->getXDim(), totalAllelesSNP2=multiallelicFreqs->getYDim();
double *SNP1Freqs=Initialize(totalAllelesSNP1, (double)0), *SNP2Freqs=Initialize(totalAllelesSNP2, (double)0);
for (int i=0; i<totalAllelesSNP1; i++)
for (int j=0; j<totalAllelesSNP2; j++)
{
 SNP1Freqs[i]=SNP1Freqs[i]+multiallelicFreqs->getValue(i, j);
 SNP2Freqs[j]=SNP2Freqs[j]+multiallelicFreqs->getValue(i, j);
}
Table2x2 T2x2;
int cont=0;
for (int i=0; i<totalAllelesSNP1-df; i++)
 for (int j=0; j<totalAllelesSNP2-df; j++)
//if (SNP1Freqs[i]>0 && SNP1Freqs[i]<1 && SNP2Freqs[j]>0 && SNP2Freqs[j]<1)
{
if (multiallelicFreqs->getValue(i, j)>(1+zero) || multiallelicFreqs->getValue(i, j)<-zero)
throw NonProb("MultiallelicPairwiseMeasure<T>::getDPrime", multiallelicFreqs->getValue(i, j));
partD=T2x2.GetDPrime(multiallelicFreqs->getValue(i, j), SNP1Freqs[i], SNP2Freqs[j]);
switch (measure)
{
case 1: weight=SNP1Freqs[i]*SNP2Freqs[j]; break;
case 2: weight=multiallelicFreqs->getValue(i, j); break;
case 3: if (multiallelicFreqs->getValue(i, j)==0) weight=0; else weight=-log(multiallelicFreqs->getValue(i, j)); break;
default: break; 
}
  DPrime=DPrime+weight*partD;
cont++;
}
zaparr(SNP1Freqs);
zaparr(SNP2Freqs);
return DPrime;
}


/*____________________________________________________________ */

double MultimarkerMeasureHapUAndT::getMultimarkerDPrime (int measure, int df, Transmission trans)
{
double DPrime=0, partialDPrime, totalCounts=0;
try
{
longLongList::iterator pointer;
int *positions=NULL, cont;
BidimensionalTable<double> * multiallelicFreqs=NULL;
//MultimarkerMeasureHap<TrioSample> *haps=multimarkerMeasureTransmitted;
for (int i=0; i<trioCounters->totalPos; i++)
for (int j=i+1; j<trioCounters->totalPos; j++)
{
multiallelicFreqs=getMultiallelicFreqs(i, j, trans);
partialDPrime=getDPrime(multiallelicFreqs, measure, df);
zap(multiallelicFreqs);
DPrime=DPrime+partialDPrime;
totalCounts++;
}
}
catch (ZeroValue zv){zv.PrintMessage("in MultimarkerMeasureUnknownHaplotypes<T>::getMultimarkerDPrime");};
return DPrime/totalCounts;
}
/*____________________________________________________________ */

double MultimarkerMeasureHapUAndT::getSquareHapProbs (int df, Transmission trans)
{
return getMultimarkerDPrime(2, df, trans);
}


/*____________________________________________________________ */


double MultimarkerMeasureHapUAndT::getTDT (IndCategory ic)
{
return getGenericTDT(0, ic);
}

/*____________________________________________________________ */


double MultimarkerMeasureHapUAndT::getSignedTDT (IndCategory ic)
{
return getGenericTDT(3, ic);
}
/*____________________________________________________________ */


double MultimarkerMeasureHapUAndT::getEntropyTDT (IndCategory ic)
{
return getGenericTDT(1, ic);
}
/*____________________________________________________________ */


double MultimarkerMeasureHapUAndT::getEntropySignedTDT (IndCategory ic)
{
return getGenericTDT(2, ic);
}
/*____________________________________________________________ */

double MultimarkerMeasureHapUAndT::getTest (int testType, IndCategory ic)
{
// testType=0: length contrast test
// testType=1: standardized length contrast test (standardized similarity measure)
// testType=-1: inverse length contrast test
// testType=-2: standardized inverse length contrast test (standardized similarity measure)
// testType=2: wilcoxon signed rank test
// testType=3: Yu signed rank test (described in Yu et al. 2005, based on Randles and Hoggs 1973)
IndPos TotalInds=0; //=genotypeSample->GetHap(FirstSNP, LastSNP, IsMajor1, IsMajor2, Marked);
double total=0, totalCounts=0, D, freqs, freqs2;
Container<vector, Pair<double> *>* DList=NULL;
Pair<double> *DPair;
long long int parentsT, parentsU, parentsT2, parentsU2;
ParentalHaplotypes parentalHaplotypes, parentalHaplotypes2;
if (testType==2 || testType==3) DList=new Container<vector, Pair<double> *>(); 
longLongList* parentsT, *parentsU;
int *pos1T, *pos1U, *pos2T, *pos2U, *pos, rank, ind;
for (int i=0; i<haplotypeFreqs->First->size(); i++)
{
parentalHaplotypes=haplotypeFreqs->First->getElement(i);
freqs=haplotypeFreqs->Second->getElement(i);
for (int parent=0; parent<2; parent++) // for each parent it computes length measure within parents
if (ic==parent || (parent==0 && ic==father) || (parent==1 && ic==mother))
{
if (parent==0) {parentsT=parentalHaplotypes.fatherT; parentsU=parentalHaplotypes.fatherU;}
 else  {parentsT=parentalHaplotypes.motherT; parentsU=parentalHaplotypes.motherU;}
pos1T=this->haplotypeTable->getPositions(parentsT);
pos1U=this->haplotypeTable->getPositions(parentsU);
for (int i2=i+1; i2<haplotypeFreqs->First->size(); i2++)
{
parentalHaplotypes2=haplotypeFreqs->First->getElement(pointer);
freqs=haplotypeFreqs->Second->getElement(c);
for (int withinBetweenSex=0; withinBetweenSex,2; withinBetweenSex++)
if ((withinBetweenSex==1 && parent==0) || withinBetweenSex==0)
{
if (parent==0) {parentsT2=parentalHaplotypes2.fatherT; parentsU2=parentalHaplotypes2.fatherU;}
 else  {parentsT2=parentalHaplotypes2.motherT; parentsU2=parentalHaplotypes2.motherU;}
pos2T=this->haplotypeTable->getPositions(parentsT2);
pos2U=this->haplotypeTable->getPositions(parentsU2);
//cout <<"ss\n" << "size:" << parentsT->size() <<"\n";
//cout <<"aa\n" << "size:" << parentsU->size() <<"\n";
D=getLengthMeasure(pos1T, pos2T, pos1U, pos2U);
//cout << parentsT->getElement(i) << " and " << parentsT->getElement(i2) <<" versus " << parentsU->getElement(i) << " and " << parentsU->getElement(i2) << "\nD is:" << D <<"\n";
if (testType==0 || testType==1) total=total+D;
else  {DPair=new Pair<double>(fabs(D), D); DList->insertElement(DPair);};
totalCounts++;
zaparr(pos2T); zaparr(pos2U);
}
// second it compares between gender
if (parent==0)
for (int i2=0; i2<parentsT->size(); i2++)
if (i2!=i)// if not a couple
{
pos2T=this->haplotypeTable->getPositions(motherCountsT->getElement(i2));
pos2U=this->haplotypeTable->getPositions(motherCountsU->getElement(i2));
D=getLengthMeasure(pos1T, pos2T, pos1U, pos2U);
//cout << parentsT->getElement(i) << " and " << motherCountsT->getElement(i2) <<" versus " << parentsU->getElement(i) << " and " << motherCountsU->getElement(i2) << "\nD is:" << D <<"\n";
if (testType==0 || testType==1) total=total+D;
else  {DPair=new Pair<double>(fabs(D), D); DList->insertElement(DPair);};
totalCounts++;
zaparr(pos2T); zaparr(pos2U);
}
zaparr(pos1T); zaparr(pos1U);
}
}
if (testType==1 || testType==-2) total=total/(double)totalCounts; // standardized length contrast test (standardized disimilarity measure)
if (testType<2) return total;
bool onlyOne, end;
total=0;rank=1;
DList->orderPointer();
//cout <<"ordered list:" << *DList;
//exit(0);
Container<vector, Pair<double> *>::iterator p=DList->getFirst(), pIni, p3;
int sameD=0;
double avRank=0, sigma, alpha, absD, halfComparisons=(totalCounts+1)/(double)2;;
rank=1;
while (p!=DList->end())
{
absD=DList->getElement(p)->getFirst();
D=DList->getElement(p)->getSecond();
p=DList->getNext(p);
sameD=1;
avRank=rank;
pIni=p;
onlyOne=true;
while (p!=DList->end() && DList->getElement(p)->getFirst()==absD)
{
onlyOne=false;
end=false;
sameD++;
p=DList->getNext(p);
avRank=avRank+rank;
}
avRank=avRank/sameD;
p3=pIni;
sigma=0;
if (testType==2) alpha=avRank;// Wilcoxon
else if (avRank<=halfComparisons) alpha=0; else alpha=avRank-halfComparisons;

//cout <<"\navrank is " << avRank <<" totalCounts is:" << totalCounts <<"\n";
while ((p3!=p && !onlyOne) || (onlyOne && !end))
{
if (sameD==1) end=true;
sigma=0;
if (!onlyOne) D=DList->getElement(p3)->getSecond();
if (D>0) sigma=1; else if (D==0) sigma=0.5; 
//if (avRank>(totalCounts+1)/2) total=total+(avRank-(totalCounts+1)/2)*sigma;
total=total+alpha*sigma;
p3=DList->getNext(p3);
}
rank++;
}
zap(DList);
return total;

};
/*____________________________________________________________ */

double MultimarkerMeasureHapUAndT::getGenericTDT (int test, IndCategory ic)
{
// test 0: TDT, test 1: entropy TDT
long long int key;
int i=0;
double tCounts, uCounts, measure=0, p, q, n;
longLongList::iterator it;
Pair<longLongList*>* parentCountsUT;
HeteroListPair<long long int, double>* prunedHaplotypeFreqs=NULL, *prunedHaplotypeFreqsU=NULL;
//double countsT=0, countsU=0;
for (int parentC=0; parentC<2; parentC++) // for each parent it computes length measure within parents
if (ic==parent || (parentC==0 && ic==father) || (parentC==1 && ic==mother))
{
if (parentC==0) parentCountsUT=removeSameHaplotypes(fatherCountsT, fatherCountsU); 
else parentCountsUT=removeSameHaplotypes(motherCountsT, motherCountsU); 
if (prunedHaplotypeFreqs==NULL) 
{
prunedHaplotypeFreqs=new HeteroListPair<long long int, double>(parentCountsUT->First);
prunedHaplotypeFreqsU=new HeteroListPair<long long int, double>(parentCountsUT->Second);
}
else 
{
prunedHaplotypeFreqs->updateListFromCounters(parentCountsUT->First);
prunedHaplotypeFreqsU->updateListFromCounters(parentCountsUT->Second);
}
zap(parentCountsUT->First);
zap(parentCountsUT->Second);
zap(parentCountsUT);
}
for (long long int key=0; key<haplotypeTable->getSize(); key++)
{
tCounts=0; uCounts=0;
it=prunedHaplotypeFreqs->First->findElement(key);
if (it!=prunedHaplotypeFreqs->First->end())
{
 tCounts=prunedHaplotypeFreqs->Second->getElement(prunedHaplotypeFreqs->First->getPosition(it));
// countsT=countsT+tCounts;
 }
it=prunedHaplotypeFreqsU->First->findElement(key);
if (it!=prunedHaplotypeFreqsU->First->end())
{ uCounts=prunedHaplotypeFreqsU->Second->getElement(prunedHaplotypeFreqsU->First->getPosition(it));
//countsU=countsU+uCounts;
}
n=tCounts+uCounts;
if (n>0)
{
		p=tCounts/n; q=uCounts/n;  //cout <<"p:" << p <<", and q:" << q <<"\n";
		switch (test)
		{
		case 0: measure=measure+std::pow(p-q, 2)/(p+q);break;
		case 1: 
	//	if (p==0) measure=measure+std::pow(n*q*log(q), 2); 
//		else if (q==0) measure=measure+std::pow(n*p*log(p), 2); 
//		else 
  if (p!=0 && q!=0) measure=measure+std::pow(n*(p*log(p)-q*log(q)), 2)/(p*q*std::pow(2+log(p)+log(q), 2)); break;
		case 2: 
		//if (p==0) measure=measure-n*q*log(q); 
		//else if (q==0) measure=measure+n*p*log(p); 
		if (p!=0 && q!=0) measure=measure+n*(p^2*log(p)^2-q^2*log(q)^2)/(p*q*std::pow(2+log(p)+log(q), 2)); break;
  case 3:  measure=measure+tCounts^2/n-uCounts^2/n;break;
		}
  i++;
}
}
zap(prunedHaplotypeFreqs);
zap(prunedHaplotypeFreqsU);
//cout <<"\ntcounts:" << countsT <<" and u counts:" << countsU;
//exit(0);
if (i==0) throw NullValue("TrioCounters::getGenericTDT");
return (i-1)*measure/i;
}



};  // End of Namespace

#endif

/* End of file: MultimarkerMeasure.h */




