/* File: ParentalGenotypesUsingPointers.h */

#ifndef __ParentalGenotypesUsingPointers_h__
#define __ParentalGenotypesUsingPointers_h__

//using namespace stats;

namespace BIOS {


/************************/
/* SNP'S MultimarkerMeasure DEFINITION */
/************************/


/**
        @memo ParentalHaplotype 
	@doc
        Definition:

       Class used mainly to compute multimarker tdt or its many variants. In order to similarity measures to can be applied, haplotype counters (or freqs if EM-freq is used) for each couple must be independently kept. One trio may have more than one parentalHaplotype (freqs must sum 1). For this reason, attribute trioCount is required. 

       With this purpose, the class required is:
 

        @author Maria M. Abad Grau
	@version 1.0
*/


	class ParentalGenotypesUsingPointers
{
public:
char outputSeparator;
bool delimiters;
// -1 in a hap means the genotype was missing
// -2 in a hap means is unphased
Genotype* father;
Genotype* mother;
int trioCount;
ParentalGenotypesUsingPointers();
ParentalGenotypesUsingPointers(ParentalGenotypesUsingPointers& other);
ParentalGenotypesUsingPointers(Genotype* father, Genotype* mother, int trioCount, char outputSeparator=' ', bool delimiters=true);
virtual ~ParentalGenotypesUsingPointers();
static ParentalGenotypesUsingPointers* fromString(string s);
ParentalGenotypesUsingPointers* clone();
Genotype* getGenotype(bool isMother);
bool operator==(ParentalGenotypesUsingPointers& other) {throw NonImplemented("ParentalGenotypesUsingPointers::operator==(ParentalGenotypesUsingPointers& other)");};
void print(ostream& out);
};
	
//ostream& operator<<(ostream& out, struct ParentalGenotypesUsingPointers& pm);

typedef Container<vector<ParentalGenotypesUsingPointers*>, ParentalGenotypesUsingPointers*>  ParentalGenotypesUsingPointersList;

 //  ostream& operator<<(ostream& out, ParentalGenotypesUsingPointersList& lista);
  


};  // End of Namespace

#endif

/* End of file: MultimarkerMeasure.h */




