#ifndef __PartitionHaplotypeTUCountsVector_h__
#define __PartitionHaplotypeTUCountsVector_h__

namespace BIOS {
	


typedef Vector<HaplotypeTUCounts*>::Class HaplotypeTUCountsList;
typedef Vector<HaplotypeCounts*>::Class HaplotypeCountsVector;

typedef Vector<HaplotypeCountsVector*>::Class VectorOfHaplotypeCountsVectors;
typedef Vector<HaplotypeCountsVector*>::Class VectorOfHaplotypeCountsVectors;

	typedef Vector<HaplotypeTUCountsVector*>::Class VectorOfHaplotypeTUCountsVectors;

//class VectorOfHaplotypeTUCountsVectors;

	/**
	*	A partition of haplotypes. 
	*	A vector of haplotype vectors.
	*	In practice, this is a partition of the TreeDT algorithm;	
	*/
	class PartitionHaplotypeTUCountsVector : public VectorOfHaplotypeTUCountsVectors{
		private:


		public:
			//! List of marker by which each subset was generated in the partition
			std::vector<int> splitMarkers;

			/**	
			*	Constructor
			*/
			PartitionHaplotypeTUCountsVector();

   PartitionHaplotypeTUCountsVector(PartitionHaplotypeTUCountsVector& other);

			/**	
			*	Destructor. 
			*	Deletes also the objects pointed in the vector.
			*/
			virtual ~PartitionHaplotypeTUCountsVector();

   PartitionHaplotypeTUCountsVector* clone();

			/** 
			* Free the memory used by the haplotypes contained in the subsets (the haplotypes).
			*/
			//void free();

			/**
			*	Calculates the z statistic of the partition as the sum of the z statistics of the subsets (HaplotypeTUCountsVector)
			*	@see HaplotypeTUCountsVector::getZstatistic()
			*	@param p Proportion of T/U haplotypes in the whole population
			*	@return z statistic
			*/
			double getZstatistic(double p);


			/**
			*	Inserts the vector given as a subset of the partition. 
			*	@param hv Haplotype vector to insert 
			*	@param splitMarker Marker by which the partition was made	
			*/
			void insertSubset(HaplotypeTUCountsVector *hv, int splitMarker=-1);

			/**
			*	Inserts the copy of the vector given as a subset of the partition. 
			*	@param hv Haplotype vector to insert 
			*	@param splitMarker Marker by which the partition was made	
			*/
			void insertSubsetCopy(HaplotypeTUCountsVector *, int splitMarker=-1);

			//TDTtable * createTable();

			/**
			*	print the partition 
			*/
			friend ostream& operator<<(ostream& output, const PartitionHaplotypeTUCountsVector& hv){

				output << " - Number of sub-sets: " <<  hv.size() << endl << endl;

				for (int i=0; i< hv.size(); i++)
					output << "subset " << i  << ") "<< *(hv[i]) <<endl;

				return output;

			};

void print();

	};
	



};

#endif
