/* File: MultimarkerMeasure.h */


#ifndef __SampleTUCounts_cpp__
#define __SampleTUCounts_cpp__





//using namespace stats;

namespace BIOS {


/**********************************/
/* DEFINITIONS OF THE FUNCTIONS */
/**********************************/



///////////////////
//// public ////////
///////////////////

/*____________________________________________________________ */

SampleGeneticCounts* SampleTUCounts::clone()
{
return new SampleTUCounts(*this);
} 


/*_________________________________________________________________*/

SampleTUCounts::SampleTUCounts(SampleTUCounts& tu): SampleHaplotypeCounts((SampleHaplotypeCounts&) tu)
{
this->hapExtractionConfiguration=tu.hapExtractionConfiguration;
  
}


/*_________________________________________________________________*/

SampleTUCounts::SampleTUCounts(VectorOfParentalGenotypes* parentalGenotypes, HapExtractionConfiguration* hapExtractionConfiguration, GeneticUnitCountsList* haplotypeCountsVector, VectorOfParentalHaplotypes* parentalHaplotypesList, int totalPermutations): SampleHaplotypeCounts(parentalHaplotypesList->getPositions(),parentalGenotypes->getPositions(), parentalHaplotypesList->getLength(), haplotypeCountsVector, totalPermutations)
{
try
{
//cout << "parentalGnotypes is:" << *parentalGenotypes <<"\n";
this->hapExtractionConfiguration=hapExtractionConfiguration;
this->parentalHaplotypesList=NULL;
this->parentalGenotypes=NULL;
//cout << "before clone\n";

if (parentalGenotypes!=NULL) this->parentalGenotypes=parentalGenotypes->clone();
//cout << "copy is:" << * this->parentalGenotypes <<"\n";
//SampleTUCounts* VectorOfParentalGenotypes::getSampleTUCounts(HapExtractionConfiguration* hapExtractionConfiguration, int totalPermutations, int* relativePositions, int totalPos, bool includeMissing) should be modified and zap(haplotypeCountsVector) should be performed
//cout << "before clone\n";
if (parentalHaplotypesList!=NULL)
this->parentalHaplotypesList=parentalHaplotypesList->clone();
//cout << "copy is:" << * this->parentalHaplotypesList <<"\n";
//if (haplotypeCountsVector!=NULL) cout << "copy is: " << *this->countsVector << "\n";
//cout << "end new\n";
}
catch (BasicException& be){be.addMessage("\ncalled from SampleTUCounts::SampleTUCounts(VectorOfParentalGenotypes* parentalGenotypes, HapExtractionConfiguration* hapExtractionConfiguration, HaplotypeSampleTUCountsVector* haplotypeCountsVector, VectorOfParentalHaplotypes* parentalHaplotypesList, int totalPermutations): SampleGeneticCounts<HaplotypeSampleTUCounts> (NULL, 0, hapExtractionConfiguration, haplotypeCountsVector, totalPermutations)"); throw;};

}

/*_________________________________________________________________*/
/*
SampleTUCounts::SampleTUCounts(SampleTUCounts& tu): SampleGeneticCounts ((SampleGeneticCounts&)tu)
{
this->copyHaplotypeSampleTUCountsVector=NULL;
treeEmtpyNodes=NULL;
this->parentalGenotypes=tu.parentalGenotypes->clone();
this->parentalHaplotypesList=new VectorOfParentalHaplotypes(*tu.parentalHaplotypesList);
if (tu.treeEmtpyNodes!=NULL) treeEmtpyNodes=new HaplotypeSampleTUCountsVector(*tu.treeEmtpyNodes);
this->haplotypeCountsVector=((HaplotypeSampleTUCountsVector*)tu.haplotypeCountsVector)->clone();
}
/*____________________________________________________________ */

VectorOfParentalGenotypes* SampleTUCounts::getParentalGenotypes()
{
return parentalGenotypes;
}



			/*_________________________________________________________________*/

int SampleTUCounts::size()
{
return getParentalGenotypes()->size();
}


/*_________________________________________________________________*/

AssociationTable* SampleTUCounts::createBasicAssociationTable(TUMeasure*g)
{
return new TDTtable(this->getCountsVector(), g->minFreq);
}	



/*_________________________________________________________________*/

AssociationTable* SampleTUCounts::createComposedAssociationTable(GeneticUnitCountsSample * p)
{
return new TDTtable(p);
}	
/*_________________________________________________________________*/
/*
AssociationTable* SampleTUCounts::createAssociationTable(TUMeasure*g)
{
//		cout << "before in s\n";	
AssociationTable* a= new TDTtable(this->getCountsVector(), g->minFreq), *result=NULL;
			double totalFirst=a->getTotalFirstRow(), totalSecond=a->getTotalSecondRow();

//cout <<"basictable:" << *a <<"\n";
   zap(a);
GeneticUnitCountsSample * p=g->getPartition(getCountsVector(), totalFirst, totalSecond);
//cout <<"partition is: " << *p <<"\n";
//cout <<"after fil\n";
//cout <<"remove p\n";
//cout << "totalelement in first:" << p->getElement(0)->size() <<"\n";
//cout << "totalelement in second:" << p->getElement(1)->size() <<"\n";
//zap( p->getElement(0));
//zap( p->getElement(1));
//			zap ( p );
			if ( p->getElement ( 0 )->size() >0 && p->getElement ( 1 )->size() >0 )
				result=new TDTtable( p );
//cout <<"newtable:" << *result <<"\n";

			zap ( p );
			return result;
}

/*_________________________________________________________________*/

AssociationTable* SampleTUCounts::createAssociationTable(Vector<GeneticUnitCounts*>::Class*g)
{
return new TDTtable(g);
}

/*_________________________________________________________________*/

SampleTUCounts::~SampleTUCounts ()
{
empty();
}

/*_________________________________________________________________*/

void SampleTUCounts::empty ()
{
zap(parentalHaplotypesList);
zap(parentalGenotypes);
//zap(hapExtractionConfiguration);

}



/*_________________________________________________________________*/

SampleTUCounts::SampleTUCounts():SampleHaplotypeCounts ()
{
parentalHaplotypesList=NULL;
parentalGenotypes=NULL;
}
/*_________________________________________________________________*/
/*
void SampleTUCounts::divideSample()
{
genericSample=new TrioSample(filename);
}




/*_________________________________________________________________*/
/*
int SampleTUCounts::getTotalPermutations ()
{
if (permutations==NULL) setPermutations();
return totalPermutations;
}

/*_________________________________________________________________*/

void SampleTUCounts::print(ostream& out)
       {
try
{
SampleHaplotypeCounts::print(out);
if (hapExtractionConfiguration==NULL) throw NullValue(" SampleTUCounts::print(ostream& out)");
out << *hapExtractionConfiguration << endl;
out <<*getParentalGenotypes() <<"\n";
out <<*parentalHaplotypesList <<"\n";
//if (countsVector!=NULL)
//   out << *countsVector << "\n";
//cout << "no problem\n";
if (getPermutations()!=NULL) 
{
cout << "perm is not null\n";
out <<"\nTotal permutations generated:\t" << getTotalPermutations() <<"\n";
}
	}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from void SampleTUCounts::print(ostream& out)" ); throw;};
};
/*_________________________________________________________________*/

VectorOfParentalHaplotypes* SampleTUCounts::getParentalHaplotypesList()
{
return parentalHaplotypesList;
}

/*_________________________________________________________________*/

void SampleTUCounts::setPermutations ()
{
if (permutations!=NULL) return;
permutations=new SampleGenericCounts*[totalPermutations];
VectorOfParentalGenotypes* genotypePermutation;
//if (parentalGenotypes->getTotalPositions()<200 && parentalGenotypes->getPermutations()==NULL)
// parentalGenotypes->setPermutations(totalPermutations);
//else 
srand(1000); // this way permutations of the genotpyes will be always the same for each window
if (hapExtractionConfiguration->alleleOrderType!=LeftRight) 
{
cout <<"allele order type is not Left Right, is: " << *hapExtractionConfiguration;
throw
NonImplemented("SampleTUCounts::setPermutations");
}
int* relativePositions=new int[getTotalPos()], *sequencedPositions=NULL;
//if (parentalGenotypes->getTotalPositions()>=200) 

// sequencedPositions=initializeFrom(0, getTotalPos());

for (int j=0; j<getTotalPos(); j++)
relativePositions[j]=parentalHaplotypesList->getPositions()[j];
//cout <<"\nrelpos at " << j <<": " << relativePositions[j] <<"\n";
for (int i=0; i<totalPermutations; i++)
{
//if (parentalGenotypes->getTotalPositions()>=200) 
genotypePermutation=parentalGenotypes->getOnePermutation(relativePositions, getTotalPos());
sequencedPositions=initializeFrom(0, getTotalPos());
permutations[i]=genotypePermutation->getSampleTUCounts(hapExtractionConfiguration, 0, sequencedPositions, getTotalPos());
zap(genotypePermutation);
zap(sequencedPositions);
//else permutations[i]=parentalGenotypes->getPermutations()[i]->getSampleTUCounts(hapExtractionConfiguration, 0, relativePositions, getTotalPos());
}
zaparr(relativePositions);
//zaparr(sequencedPositions);
}

/*_________________________________________________________________*/

HapExtractionConfiguration* SampleTUCounts::getHapExtractionConfiguration()
{
return hapExtractionConfiguration;
}



};  // End of Namespace

#endif

/* End of file: MultimarkerMeasure.h */

//stringList * BIOS::SampleTUCounts::getTDTFreqsResults(SNPPos snpPos)
//{
//}






