/* File: PhylogeneticDistance.h */

#ifndef __SampleTUCounts_h__
#define __SampleTUCounts_h__

//using namespace stats;

namespace BIOS {


/************************/
/* SNP'S MultimarkerMeasure DEFINITION */
/************************/


/**
        @memo TUCounters for a given window in a TrioSample

	@doc
        Definition:

       Class used mainly to compute multimarker TU measures. In order to similarity measures to can be applied, haplotype counters (or freqs if EM-freq is used) for each couple must be independently kept 

       With this purpose, the data structures required is:
 
       Container<vector, ParentalHaplotypes> *parentalHaps   

        @author Maria M. Abad
	@version 1.0
*/

//typedef SampleGeneticCounts<HaplotypeTUCounts> SampleGeneticCountsOfTU;
//typedef SampleGeneticCounts<HaplotypeTUCountsVector> SampleTUCounts;

typedef Vector<HaplotypeTUCounts*>::Class HaplotypeTUCountsList;



class HaplotypeTUCountsVector;
 
class	SampleTUCounts: public SampleHaplotypeCounts {

private:

HapExtractionConfiguration* hapExtractionConfiguration;//how haps were extracted from genotytpes
VectorOfParentalGenotypes* parentalGenotypes; // genotype counters, required to compute permutations



public:


//HaplotypeTUCountsVector* haplotypeTUCountsVector; 

// ***** FOR treedtmeasure
//! Vector of haplotypes vector with repetitions and freq=1 per haplotype
typedef Vector<HaplotypeTUCounts*>::Class* expandedHaplotypeVector;

//! Copy used for permutations
HaplotypeTUCountsList* copyHaplotypeTUCountsVector;

//! to keep track of the inner nodes created 
//HaplotypeTUCountsList* treeEmtpyNodes;
		
// *** end treedtmeasure
		
VectorOfParentalHaplotypes* parentalHaplotypesList; // used for some algorithms that require to know the combination of haplotypes that each family has



/*********************************************************************/
/***     ASSOCIATED FUNCTIONS     ***/
/*********************************************************************/

private:


//void set(SNPPos Pos[], SNPPos totalPos, TrioSample * samp, HapExtractionConfiguration* hapExtractionConfiguration, int totalPermutations);  



      public:

SampleTUCounts();

//	TUCounts(SNPPos Pos[], SNPPos totalPos, TrioSample * samp, AlleleOrderType alleleOrderType=LeftRight, PhaseAlg=weighted, EMDistributions emDistributions=UTDistributions, EMRestriction emRestriction=triosBasedRestriction, int totalPermutations=100);

SampleTUCounts(VectorOfParentalGenotypes* parentalGenotypes, HapExtractionConfiguration* hapExtractionConfiguration, GeneticUnitCountsList* haplotypeTUCountsList, VectorOfParentalHaplotypes* parentalHaplotypesList, int totalPermutations=100);

//TUCounts* filter(int pos, int length, bool allowUnphased);

//TUCounts(char* filename, HapExtractionConfiguration* hapExtractionConfiguration, int totalPermutations);
	
 SampleTUCounts(SampleTUCounts& source);
 

 virtual SampleGeneticCounts* clone();

virtual ~SampleTUCounts();

virtual void empty();

virtual VectorOfParentalGenotypes* getParentalGenotypes();


//virtual AssociationTable* createAssociationTable(TUMeasure*g);

virtual void setPermutations ();

virtual int size();

virtual VectorOfParentalHaplotypes* getParentalHaplotypesList();


virtual AssociationTable* createAssociationTable(Vector<GeneticUnitCounts*>::Class*g);

virtual AssociationTable* createBasicAssociationTable(TUMeasure*g);

virtual AssociationTable* createComposedAssociationTable(GeneticUnitCountsSample * p);

/**
 * Creates a new SampleTUCounts with the left half positions, inverting the order.
 * For example, given a SampleTUCounts with haplotypeTUCountsVector of 10 positions {0,1,...,9}
 * the returned haplotypeTUCountsVector will have positions {4,3,2,1,0}
 * @return The new created SampleTUCounts
 */


/**
 * Creates a new SampleTUCounts with the right half positions.
 * For example, given a SampleTUCounts with haplotypeTUCountsVector of 10 positions {0,1,...,9}
 * the returned haplotypeTUCountsVector will have positions {5,6,7,8,9}
 * @return The new created SampleTUCounts
 */
//TUCounts* filterRightHalf(bool allowUnphased);

HapExtractionConfiguration* getHapExtractionConfiguration();

virtual void print(ostream&);

};  // End of class SampleTUCounts








};  // End of Namespace

#endif

/* End of file: MultimarkerMeasure.h */




