#ifndef __TDTtable_cpp__
#define __TDTtable_cpp__




/*_____________________________________________________________*/
/*
void print ( BIOS::TDTtable *t )
{
	cout << *t << endl;
}


/*_____________________________________________________________*/


namespace BIOS
{

/*_____________________________________________________________________________________________________________*/


	void	TDTtable::addDimension()
	{
		if ( partition!=NULL ) throw BadFormat ( "void	TDTtable<HaplotypeTUCountsVector>::addDimension()" );
		reset ( 3, getYDim() );
	}
/*_____________________________________________________________________________________________________________*/




	TDTtable::TDTtable ( int cols, double minFreq, bool HWE ) :HaplotypeTable (cols, minFreq )
	{
		this->HWE=HWE;
// the third row is to store homozygous haplotype counts 
		addDimension();

	};
	

	/*_____________________________________________________________________________________________________________*/


	TDTtable::TDTtable ( const TDTtable& other ):HaplotypeTable ( other )
	{
		this->HWE=other.HWE;
	};

/*_____________________________________________________________________________________________________________*/


	AssociationTable* TDTtable::createEmptyTable(int totalColumns)
	{
return new TDTtable(totalColumns, minFreq, HWE);
	}

	/*_____________________________________________________________________________________________________________*/


	AssociationTable* TDTtable::clone()
	{
		return new TDTtable ( *this );
	}

	/*_____________________________________________________________________________________________________________*/



	TDTtable::TDTtable (VectorSample<GeneticUnitCounts*>::Class * partition, double minFreq, bool HWE ):HaplotypeTable ( partition, 3, minFreq, HWE ) 
	{
filter();	};




	/*_____________________________________________________________________________________________________________*/


	TDTtable::TDTtable (Vector<GeneticUnitCounts*>::Class * p, double minFreq, bool HWE )
			:HaplotypeTable (p, 3, minFreq, HWE )
	{

filter();
	};



	/*______________________________________________________________________________________________*/
/*

			TDTtable* TDTtable::getFilteredTable()
	{
// for !HWE it removes those columns that does not have any T or U transmission at all or is under minFreq
		try
		{
			int totalHaps=this->getYDim();

			for ( int i=0; i<this->getYDim(); i++ )
				if ( ( !HWE && ( getHeteroHapCount ( i ) ==0 || getHeteroHapCount ( i ) <minFreq ) ) || ( HWE && ( getValue ( 2,i ) ==0 || getValue ( 2,i ) <minFreq ) ) )
					totalHaps--;
			if ( totalHaps==0 ) return NULL;
			if ( totalHaps<0 ) throw OutOfRange<int> ( totalHaps, "TDTtable* TDTtable::getFilteredTable()" );
//return NULL;
			TDTtable* result=new TDTtable ( totalHaps );

			result->partition=new PartitionAsVectorSampleOfHaplotypes ( '\t', '[',']' );
			int pos=0;
			for ( int j=0; j<getYDim(); j++ )
				if ( ( !HWE && getHeteroHapCount ( j ) >0 && getHeteroHapCount ( j ) >=minFreq ) || ( HWE && ( getValue ( 2,j ) >0 && getValue ( 2,j ) >=minFreq ) ) )
				{
					result->partition->insertHardElement ( this->partition->getElement ( j ) );
					for ( int i=0; i<getXDim(); i++ )
						result->setValue ( i, pos, getValue ( i, j ) );
					pos++;
				}
			if ( pos!=totalHaps ) throw OutOfBounds ( totalHaps, pos, "TDTtable::getFilteredTable(int minFreq, bool HWE)" );
			return result;
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from TDTtable* TDTtable::getFilteredTable()) " ); throw;};
	};




	  
		  
	  
	  /*_____________________________________________________________*/
/*
			TDTtable * TDTtable::newFromTree ( HaplotypeTUCountsTree *tree )
	{

		PartitionHaplotypeTUCountsVector * p = tree->getBestLeaves(); // p contains groups of leaves
		this->copyFrequenciesTo ( p ); // update p frequencies with values in table
		TDTtable *t = new TDTtable ( p, 0, false ); // create a new table with the groups in p
		zap ( p );

		return t;

	}

	
		/*_____________________________________________________________*/

/*
	void TDTtable::update ( SampleGeneticCounts* hapCounts, bool useDistances, bool treeDT, int position, bool toLeft )
	{
		try
		{
	throw NonImplemented("void TDTtable::update ( SampleGeneticCounts* hapCounts, bool useDistances, bool treeDT, int position, bool toLeft )");
			//update2 ( ( ( SampleTUCounts* ) hapCounts )->parentalHaplotypesList, useDistances, treeDT, position, toLeft );
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from  void TDTtable::update ( SampleTUCounts* hapCounts, bool useDistances, bool treeDT, int position, bool toLeft )" ); throw;};
	}

	/*_____________________________________________________________*/
/*
	void TDTtable::keepOnlyBothInFirstColumn ( SampleGeneticCounts* hapCounts )
	{
// it keeps in first column (high risk haplotype) only those counts from individuals with both haplotypes being high risk haplotypes and all the other counts are moved to the second column
//cout << "current tdttable:" << *this <<"\n";
		GenotypeList* caseGenotypes= ( ( SampleCaseControlCounts* ) hapCounts )->getCaseGenotypes();
		GenotypeList* controlGenotypes= ( ( SampleCaseControlCounts* ) hapCounts )->getControlGenotypes();
		GenotypeList* list=caseGenotypes;
		Haplotype* left, *right;
		PartitionAsVectorSampleOfHaplotypes::iterator posT, posU;
		int row=0;
		for ( int i=0; i<2; i++ )
		{
			if ( i==1 ) {list=controlGenotypes; row=1;}
			for ( GenotypeList::iterator it=list->begin(); it<list->end(); it++ )
			{
				left=list->getElement(it)->getLeftHaplotype();
				right=list->getElement(it)->getRightHaplotype();
				posT=partition->findElementContainingInternalElement ( left );
				posU=partition->findElementContainingInternalElement ( right );
				if ( posT!=posU && (posT==partition->begin() || posU==partition->begin())) 
				{
//cout << " row : " << row <<", posT:" << partition->getPosition ( posT ) <<" , posU:" << partition->getPosition ( posU ) <<"\n";
					setValue ( row, 0, getValue ( row, 0)-1 );
					addValue ( row, 1, 1 );
				}
   zap(left);
   zap(right);
			}
		}
//cout << "afterkepponlyfirstL:" << *this <<"\n";
	}


	

		/*_____________________________________________________________*/


			void TDTtable::update (  SampleGeneticCounts* sampleCounts, bool useDistances, bool treeDT, int position, bool toLeft )
	{
		try
		{
int currentYDim=getYDim();
			//BIOS::print (parentalHaplotypesList->getPositions(), parentalHaplotypesList->getLength());
			//exit(0);
			AssociationTable* oldData=this->clone();
			initialize(); // set table counts to 0
			double minDistance=-1, tempMin;
			int selectedPosT, selectedPosU;
			intSet* minPosT, *minPosU, *minPosT2, *minPosU2;
			Haplotype* ht, *hu, *closestHt, *closestHu;
			ParentalHaplotypesUsingPointers* element;
				BidimensionalTable<double>::empty(); // zaparr(table);
				MultidimensionalTable<double>::set(); // create an empty table
			//oldData->partition->print();
			//PartitionAsSetSampleOfHaplotypes::iterator posT, posU;
//cout <<"list:" << *parentalHaplotypesList <<"\n";
VectorOfParentalHaplotypes*parentalHaplotypesList= (( SampleTUCounts* ) sampleCounts )->parentalHaplotypesList;
if (parentalHaplotypesList==NULL) throw NullValue("TDTtable::update ");
			for ( VectorOfParentalHaplotypes::iterator it=parentalHaplotypesList->begin(); it!=parentalHaplotypesList->end(); it++ )
			{
				element=parentalHaplotypesList->getElement ( it );
				for ( int parent=0; parent<2;parent++ )
				{
					ht=element->getHap ( parent, t );
					hu=element->getHap ( parent, u );
					if ( ht!=NULL && hu!=NULL )
					{
						minPosT=oldData->partition->getPositionsWithInternalMinDistance ( ht, position, toLeft );
//cout << "haploT: " << * ht << " is closest to one in partitions: " << *minPosT <<"\n";
						minPosU=oldData->partition->getPositionsWithInternalMinDistance ( hu, position, toLeft );
//cout << "haploU: " << * hu << " is closest to one in partitions: " << *minPosU <<"\n";

						selectedPosT=minPosT->getElement ( rand() %minPosT->size() );
			   selectedPosU=minPosU->getElement ( rand() %minPosU->size() );
						//selectedPosT=minPosT->getElement( 0 );
						//selectedPosU=minPosU->getElement( 0 );
						if ( !useDistances || treeDT )
						{
							minPosT2=oldData->partition->getElement ( selectedPosT )->getPositionsWithMinDistance ( ht , position, toLeft );
							minPosU2=oldData->partition->getElement ( selectedPosU )->getPositionsWithMinDistance ( hu , position, toLeft );
							closestHt=(Haplotype*)oldData->partition->getElement ( selectedPosT )->getElement ( minPosT2->getElement ( 0 ) );
							closestHu=(Haplotype*)oldData->partition->getElement ( selectedPosU )->getElement ( minPosU2->getElement ( 0 ) );
							if ( !useDistances )
							{
								if ( ht->getDistance ( closestHt, -1 ) !=0 )
									selectedPosT=rand() %oldData->partition->size(); // not exactly the same haplotype
								if ( hu->getDistance ( closestHu, -1 ) !=0 )
									selectedPosU=rand() %oldData->partition->size(); // not exactly the same haplotype
							}
							zap ( minPosT2 );
							zap ( minPosU2 );
						}
						if ( ( minPosT->size() ==1 && minPosU->size() ==1 && selectedPosT !=selectedPosU ) || ( treeDT && closestHt!=closestHu ) ) // only hetero
						{
							addValue ( 0, selectedPosT, 1 );
							addValue ( 1, selectedPosU, 1 );
						}
						else addValue ( 2, selectedPosT, 2 );

//cout << *this <<"\n";
						zap ( minPosT ); zap ( minPosU );
					}
					//else cout << "null haps for element: " << *element <<"  \n";
				}
			}
			delete oldData;
			//filter();// those partitions with no hetero genotypes will be removed
if (getYDim()!=currentYDim)  throw OutOfBounds ( getYDim(), currentYDim, "TDTtable::update2* weights)" );

		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from  void TDTtable::update (VectorOfParentalHaplotypes* parentalHaplotypesList)" ); throw;};
	}
	/*_____________________________________________________________*/

	/*
	template<>		void TDTtable<HaplotypeCaseControlCountsVector>::update2 (HaplotypeCaseControlCountsVector* hapCounts, bool useDistances, bool treeDT, int position, bool toLeft )
		{
			try
			{
				TDTtable* oldData=this->clone();
				BidimensionalTable<double>::empty(); // zaparr(table);
				MultidimensionalTable<double>::set(); // create an empty table
				double minDistance=-1, tempMin;
				int selectedPosT, selectedPosU;
				intSet* minPos, *minPos2;
				Haplotype* h, *closestH;
	   double cases, controls;
				HaplotypeCaseControlCounts* element;
				for ( HaplotypeCaseControlCountsVector::iterator it=hapCounts->begin(); it!=hapCounts->end(); it++ )
				{
					element=hapCounts->getElement ( it );
						h=element->getHaplotype ();
	     cases=element->getFirstFrequency();
						controls=element->getSecondFrequency();
						if ( h!=NULL )
						{
							minPos=oldData->partition->getPositionsWithInternalMinDistance ( h, position, toLeft );
							selectedPos=minPos->getElement ( rand() %minPos->size() );
							if ( !useDistances || treeDT )
							{
								minPos2=oldData->partition->getElement ( selectedPos )->getPositionsWithMinDistance ( h , position, toLeft );
								closestH=oldData->partition->getElement ( selectedPos )->getElement ( minPos2->getElement ( 0 ) );
								if ( !useDistances )
									if ( h->getDistance ( closestH, -1 ) !=0 )
										selectedPos=rand() %oldData->partition->size(); // not exactly the same haplotype
								zap ( minPos2 );
							}
								addValue ( 0, selectedPos, cases );
								addValue ( 1, selectedPos, controls );
							zap ( minPos );
						}
					}
				delete oldData;
				//filter();// those partitions with no hetero genotypes will be removed
			}
			catch ( BasicException& be ) {be.addMessage ( "\ncalled from  void TDTtable::update (VectorOfParentalHaplotypes* parentalHaplotypesList)" ); throw;};
		}

		/*________________________________________________________________________________________________*/

	/*
			void TDTtable::Fill(PartitionHaplotypeTUCountsVector * p)
			{
				if ( getYDim() != p->size() ){
					cerr << "TDTtable: The table could not be filled. The number of columns and the number of subsets does not match " << endl;
					return;
				}
				//
				// Fill table
				//
				double t_freq, u_freq;

				// Fill each column
				for (int i=0; i < p->size(); i++){

					t_freq = (*p)[i]->getTransmittedFreqSum();
					u_freq =  (*p)[i]->getFreqSum() - t_freq;
					this->setValue(0,i, t_freq);
					this->setValue(1,i, u_freq);

				}
				partition = NULL;

			};

	/*___________________________________________________________________________________________*/



	double TDTtable::getStatistic ( bool HWE )
	{
		double sum=0;
		for ( int i=0; i<getYDim();i++ )
		{
			double b, c;
			if ( !HWE )
			{
				b = getValue ( 0,i );
				c = getValue ( 1,i );
			}
			else
			{
				b = getValue ( 2,i ) /2;
				c = getValue ( 0,i ) +getValue ( 1,i );
			}
			if ( ( b+c ) >0 ) sum += std::pow ( b-c , ( double ) 2 ) / ( double ) ( b+c );
		}
		if ( HWE ) return sum;
		else return sum* ( getYDim()-1 ) / ( double ) getYDim();
	};

	

	/*__________________________________________________________________________________*/


	double TDTtable::getStatisticZforColumn ( int i , double wholeSampleT, double wholeSampleU )
	{
		/*
		double p = 0.5; // proportion

		double a; // number of disease-associated haplotypes (sum of T frequencies)
		double n; // the total number of haplotypes (sum of frequencies)
		double z;

		// Calculate a
		a = getValue ( 0,i );

		// Calculate n
		n= a + getValue ( 1,i );

		// Calculate z statistic
		if ( n == 1 )
			z = 0;
		else
			z = ( a - n*p ) / ( sqrt ( n*p* ( 1.0-p ) ) ) ;

		return z;
		*/

		double a = getValue ( 0,i );

		// Calculate n
		double c = getValue ( 1,i );

		double nchromoF = wholeSampleT + wholeSampleU;
		float na = wholeSampleT;
		float nc = wholeSampleU;

		double p = ( a + c ) / ( double ) nchromoF, pa = na / ( double ) nchromoF;
		double ea = na * p, ec = nc * p;
		double x = ( a - ea ) / sqrt ( ( a + c ) * pa * ( 1 - pa ) );
		return x;



	}

	/*_____________________________________________________________*/

	double TDTtable::getStatisticZ ( double wholeSampleT, double wholeSampleU )
	{
		double z=0;
		double z_i=0;


		// For each column, calculate z statistic
		for ( int i=0; i<getYDim();i++ )   //i is the column index
		{
			z_i = getStatisticZforColumn ( i , wholeSampleT, wholeSampleU );
			//if ( z_i > 0 )
			z += z_i;
		}
		return z;
	}

	/*_____________________________________________________________*/


	double TDTtable::getStatisticZ2 ( double wholeSampleT, double wholeSampleU )
	{
		double z=0;
		double z_i=0;


		// For each column, calculate z statistic
		for ( int i=0; i<getYDim();i++ )   //i is the column index
		{
			z_i = getStatisticZforColumn ( i , wholeSampleT, wholeSampleU );
			z += z_i*z_i;
		}
		return z;
	}

	/*_____________________________________________________________*/

	double TDTtable::getWeightedStatistic ( doubleList* weights )
	{
		if ( weights->size() != getYDim() ) throw OutOfBounds ( weights->size(), getYDim(), "TDTtable::getWeightedStatistic(doubleList* weights)" );
		double sum=0;

		for ( int i=0; i<getYDim();i++ )
		{
			double b, c;
			b = getValue ( 0,i );
			c = getValue ( 1,i );
			if ( ( b+c ) >0 ) sum += weights->getElement ( i ) *std::pow ( b-c , ( double ) 2 ) / ( double ) ( b+c );
		}
		return sum;
		//return sum*(getYDim()-1)/(double)getYDim();
	};

	

/*_____________________________________________________________*/


	 double TDTtable::getHeteroHapCount ( int hapPos, Transmission trans )
	{
		if ( trans==ut ) return getColumnCount ( hapPos, 2 );
		else return getColumnCount ( hapPos, trans-1 );
	}

	


	/*_____________________________________________________________*/


	double TDTtable::getHomoHapCount ( int hapPos )
	{
		return getValue ( 2, hapPos );
	}


	/*_____________________________________________________________*/

	void TDTtable::removeSemiHomo ( SampleGeneticCounts* counts )
	{

		try
		{
	SampleTUCounts* hapCounts=(SampleTUCounts*) counts;
//cout << "before removing:" << *this <<"\n";
//removeSemiHomo2(((TUCounts*)hapCounts)->parentalHaplotypesList);
			VectorOfParentalHaplotypes* parentalHaplotypesList= ( ( SampleTUCounts* ) hapCounts )->parentalHaplotypesList;
			//   cout <<"before is:" << *this <<"\n";
			Haplotype* ht, *hu;
			ParentalHaplotypesUsingPointers* element;
			VectorSample<GeneticUnit*>::Class::iterator posT, posU;
			for ( VectorOfParentalHaplotypes::iterator it=parentalHaplotypesList->begin(); it!=parentalHaplotypesList->end(); it++ )
			{
				element=parentalHaplotypesList->getElement ( it );
				for ( int parent=0; parent<2;parent++ )
				{
					ht=element->getHap ( parent, t );
					hu=element->getHap ( parent, u );
					if ( *ht!=*hu )
					{
						posT=partition->findElementContainingInternalElement ( ht );
						posU=partition->findElementContainingInternalElement ( hu );
						if ( posT==posU && posT!=partition->end() )
						{
							// cout << "haps: " << *ht << " and " << *hu << " belongs both to group " << partition->getPosition (posT) << "\n";

							setValue ( 0, partition->getPosition ( posT ), getValue ( 0, partition->getPosition ( posT ) )-1 );
							setValue ( 1, partition->getPosition ( posT ), getValue ( 1, partition->getPosition ( posT ) )-1 );
							addValue ( 2, partition->getPosition ( posT ), 2 );
							if ( getValue ( 0, partition->getPosition ( posT ) ) <0 || getValue ( 1, partition->getPosition ( posT ) ) <0 )
							{
								cout <<"current is:" << *this <<"\n";
								throw ZeroValue ( "void TDTtable::removeSemiHomo (VectorOfParentalHaplotypes* parentalHaplotypesList)" );
							}
						}
					}
				}
			}
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from  void TDTtable::removeSemiHomo (VectorOfParentalHaplotypes* parentalHaplotypesList)" ); throw;};

	}


	

	/*_____________________________________________________________*/


		double TDTtable::getTotalTransmissionCount ( Transmission trans )
	{
		if ( trans==ut ) return getTotalRowCount ( 2 );
		else return getTotalRowCount ( trans-1 );
	}

	

	/*_____________________________________________________________*/


			double TDTtable::getTotalHeteroGenotypes()
	{
		return getTotalTransmissionCount ( ut ) / ( double ) 2;
	}

	
		/*_____________________________________________________________*/


			double TDTtable::getTotalUsedGenotypes()
	{
		return getTotalHeteroGenotypes();
	}
	/*_____________________________________________________________*/


			double TDTtable::getTotalHomoGenotypes()
	{
		return ( getTotalCounts()-getTotalTransmissionCount ( ut ) ) /2;
	}



	/*_____________________________________________________________*/


			doubleList* TDTtable::getTransmissionCounts ( Transmission trans )
	{
			switch ( trans )
			{
			case t: case u: return getCounts(trans-1);break;
				case ut: return getCounts(2); break;
			}
return NULL;
	}
/*_____________________________________________________________*/

			doubleList* TDTtable::getHapFreqs(Transmission trans)
	{
switch ( trans )
			{
			case t: case u: return getFreqs(trans-1);break;
				case ut: return getFreqs(2); break;
			}
				return NULL;
	}

	/*_____________________________________________________________*/


			doubleList* TDTtable::getHomoCounts ()
	{
		doubleList* results=new doubleList();
		for ( int i=0; i<getYDim(); i++ )
			results->insertElement ( getValue ( 2,i ) );
		return results;
	}





	/*_____________________________________________________________*/

	
		double TDTtable::getPVal()
	  {
	//cout <<"dinn\n";
	//cout <<"st:" << getStatistic() <<"\n";
	  return pdfTestChiSquare(getStatistic(),getYDim()-1);
	  }

	/*_____________________________________________________________*/

	/*
		double TDTtable::getWeightedPVal(doubleList* weights)
	  {
	  double result=pdfTestWeightedChiSquareTDT(getWeightedStatistic(weights), weights);
	  return result;
	  }
	*/

	

};

#endif
