#ifndef __TDTtable_h__
#define __TDTtable_h__

namespace BIOS {
	
  /**
     @memo TDTtable
     @doc
     Definition:
	It adds a row to AssociationTable with homo frequencies and implements specific methods for TU tables used by TDT methods

     @author José Moreno, María M. Abad Grau
     @version 1.0
	
	*/	







class VectorOfParentalHaplotypes;
class AssociationTable;
class HaplotypeTable;
// typedef SingleAncestorGraph<DirectedArc, HaplotypeTUCounts*, void> TreeOfHaplotypeTUCounts;

class TDTtable: public  HaplotypeTable {
    
  
  private:
  


		public:
		

		/**
		*	Constructor
		*/		
		TDTtable(int cols, double minFreq=0, bool HWE=false);

		/**
		*	Destructor
		*/		
	virtual	~TDTtable() {};

    static TDTtable* fromString(string s){throw NonImplemented("static TDTtable* fromString(string s)");};


		/**
		*	Constructor from a partition
		* 	Creates a table from the T/U data in a partition
		*	The number of columns in the table will be the number of vectors (subsets) in countPartitions.
		*	The number of rows will be two or three, depending on T class. The first for the Transmitted/case haplotypes/genotypes. The second for the Non transmitted/control haplotypes/genotypes.
		*	@param p Partition from which to fill the table
		*/		
	TDTtable(GeneticUnitCountsSample* countPartitions, double minFreq=0, bool HWE=false);

//TDTtable(PartitionHaplotypeTUCountsVector* hapCounts, double minFreq=0, bool HWE=false); is it really needed
		//PartitionHaplotypeTUCountsVector
		TDTtable(const TDTtable& other);

 		/*	Constructor from a partition
		* 	Creates a table from the genetic unit data in a partition
		*	The number of columns in the table will be the number of vectors (subsets) in countPartitions.
		*	The number of rows will be two or three. The first for the Transmitted/case haplotypes/genotypes. The second for the Non transmitted/control haplotypes/genotypes and the third for homozygous transmissions in TU data sets.
		*	@param p Partition from which to fill the table
		*/		
			TDTtable(Vector<GeneticUnitCounts*>::Class * countsVector, double minFreq=0, bool HWE=0);
	//TDTtable(HaplotypeCaseControlCountsVector* hapCounts, int* positions=NULL, int length=-1, double minFreq=0, bool HWE=false);

  virtual AssociationTable* clone();


		

	 /**
	 * Creates a tdttable from this and the given tree.
	 * Uses the best nodes of the tree to restrict the columns of this table.
	 * The nodes of the tree must be present in the table
	 * @param tree Tree of haplotypes used to restrict the columns in this table.
	 * @return A new table.
	 */
	 TDTtable * newFromTree(HaplotypeTUCountsTree *tree);		
// 	 TDTtable * newFromTree(TreeOfHaplotypeTUCounts *tree);


virtual AssociationTable* createEmptyTable(int totalColumns);		


  doubleList* getHapFreqs(Transmission trans);
  
 // void update2(VectorOfParentalHaplotypes* parentalHaplotypesList, bool useDistances=true, bool treeDT=false, int position=-1, bool toLeft=false);

virtual void update(SampleGeneticCounts* hapCounts, bool useDistances=true, bool treeDT=false, int position=-1, bool toLeft=false);
  
//	void update(HaplotypeTUCountsVector* hapCounts, int iniPos, int length, bool left);

  double getStatistic(bool HWE=false);

	void addDimension();
  /**
   * Statistic for TreeDT
   * @return 
   */
  double getStatisticZ(double wholeSampleT=0, double wholeSampleU=0);
  double getStatisticZ2(double wholeSampleT=0, double wholeSampleU=0);
  double getStatisticZforColumn(int i, double wholeSampleT, double wholeSampleU);

  double getWeightedStatistic(doubleList* weights);

virtual  double getPVal();

//  double getWeightedPVal(doubleList* weights);

  doubleList* getTransmissionCounts(Transmission transmission);

	doubleList* getHomoCounts ();

double getTotalHomoGenotypes();

double getTotalHeteroGenotypes();

 double getHomoHapCount (int hapPos);


	double getTotalTransmissionCount(Transmission trans);

virtual double getTotalUsedGenotypes();

	double getHeteroHapCount(int hapPos, Transmission trans=ut);
	
virtual void removeSemiHomo(SampleGeneticCounts* hapCounts);

void keepOnlyBothInFirstColumn(SampleGeneticCounts* hapCounts);

//void removeSemiHomo2(VectorOfParentalHaplotypes* parentalHaplotypesList);
	
//void print();

bool operator==(AssociationTable& other) {throw NonImplemented("TDTtable::operator==(TDTtable& other)");};


virtual string firstHeading(){return string("T");};

virtual string secondHeading(){return string("U");};

virtual string thirdHeading(){return string("H");};

//void update2 (T* hapCounts, bool useDistances, bool treeDT, int position, bool toLeft );
	};
	
	





};

#endif
