/* File: MultimarkerMeasure.h */


#ifndef __TUCounts_cpp__
#define __TUCounts_cpp__





//using namespace stats;

namespace BIOS {


/**********************************/
/* DEFINITIONS OF THE FUNCTIONS */
/**********************************/



///////////////////
//// public ////////
///////////////////

/*____________________________________________________________ */

TUCounts* TUCounts::clone()
{
return new TUCounts(*this);
} 


/*_________________________________________________________________*/

TUCounts::TUCounts(VectorOfParentalGenotypes* parentalGenotypes, HapExtractionConfiguration* hapExtractionConfiguration, HaplotypeTUCountsVector* haplotypeTUCountsVector, VectorOfParentalHaplotypes* parentalHaplotypesList, int totalPermutations): GeneticCounts(NULL, 0, hapExtractionConfiguration, totalPermutations)
{


this->parentalGenotypes=parentalGenotypes;
this->haplotypeTUCountsVector=haplotypeTUCountsVector->clone();
length=0;
this->parentalHaplotypesList=parentalHaplotypesList;
this->expandedHaplotypeVector=NULL;
this->copyHaplotypeTUCountsVector=NULL;
treeEmtpyNodes=NULL;
if (parentalGenotypes!=NULL && parentalHaplotypesList !=NULL)
{
length=parentalHaplotypesList->getLength();
pos=new int[getTotalPos()];
for (int i=0; i<getTotalPos(); i++)
 pos[i]=parentalGenotypes->getPositions()[parentalHaplotypesList->getPositions()[i]];
}
else pos=NULL;
}

/*_________________________________________________________________*/

TUCounts::TUCounts(TUCounts& tu): GeneticCounts((GeneticCounts&)tu)
{
this->expandedHaplotypeVector=NULL;
this->copyHaplotypeTUCountsVector=NULL;
treeEmtpyNodes=NULL;
this->parentalGenotypes=tu.parentalGenotypes;
this->parentalHaplotypesList=new VectorOfParentalHaplotypes(*tu.parentalHaplotypesList);
if (tu.treeEmtpyNodes!=NULL) treeEmtpyNodes=new HaplotypeTUCountsVector(*tu.treeEmtpyNodes);
this->haplotypeTUCountsVector=tu.haplotypeTUCountsVector->clone();
}
/*____________________________________________________________ */

VectorOfParentalGenotypes* TUCounts::getParentalGenotypes()
{
return parentalGenotypes;
}
/*____________________________________________________________ */

TUCounts* TUCounts::filter(int *relativePositions, int size)
{
try
{
//TUCounts* results=parentalGenotypes->getTUCounts(this->hapExtractionConfiguration, this->totalPermutations, relativePositions, size);
TUCounts* results=new TUCounts();
results->hapExtractionConfiguration=hapExtractionConfiguration;
results->parentalGenotypes=parentalGenotypes;
//results->totalPos=size;
if (permutations!=NULL) throw BadFormat("TUCounts* TUCounts::filter(int *relativePositions, int size)");
results->permutations=NULL;
results->totalPermutations=totalPermutations;
/*
if (results->totalPermutations>0 && this->permutations!=NULL)
 {
 results->permutations=new TUCounts*[totalPermutations];
 for (int i=0; i<totalPermutations; i++)
  results->permutations[i]=this->permutations[i]->filter(relativePositions, size);
 }
 */
if (this->pos==NULL) throw NullValue("TUCounts* TUCounts::filter(int *relativePositions, int size)");
 //if (this->pos!=NULL) 
 {
 if (size>this->getTotalPos()) throw OutOfBounds(size, getTotalPos(), "TUCounts* TUCounts::filter(int *relativePositions, int size)");
 results->pos=new int[size];
 for (int i=0; i<size;i++)
 results->pos[i]=this->pos[relativePositions[i]];
 }
//else results->pos=NULL;
if (this->parentalGenotypes==NULL) throw NullValue("TUCounts* TUCounts::filter(int *relativePositions, int size):2");
results->parentalHaplotypesList=this->parentalGenotypes->getParentalHaplotypesList(relativePositions, size);
results->haplotypeTUCountsVector=results->parentalHaplotypesList->getHaplotypeCountsVector(); 
return results;
}
catch (BasicException& be){be.addMessage("\ncalled from TUCounts* TUCounts::filter(int *relativePositions, int size)"); throw;};
}
 
/*____________________________________________________________ */


TUCounts* TUCounts::filterLeftHalf()
{
	TUCounts * left;

	int tuLength = this->getTotalPos();
	int left_length = tuLength/2;
	int *left_positions = new int[left_length];
	for(int i=0; i<left_length; i++){
		left_positions[i] =  this->getPositions()[ left_length-1-i ];
		//left_positions[i] =  left_length-1-i ;
		//cout << " position " << i << " = " << left_positions[i] << endl;
	}
	left =  this->filter(left_positions, left_length) ;
	delete [] left_positions;

	return left;

};

/*____________________________________________________________ */

TUCounts* TUCounts::filterRightHalf()
{
	TUCounts * right;
		int tuLength = this->getTotalPos();
		int left_length = tuLength/2;
		
		int right_length = tuLength - left_length;
		int *right_positions = new int[right_length];		
		for(int i=0; i<right_length; i++){
			//right_positions[i] =  left_length+i ;
			right_positions[i] =  this->getPositions()[left_length+i] ;
			//cout << " position " << i << " = " << right_positions[i] << endl;
		}
		right =  this->filter(right_positions, right_length) ;
		delete [] right_positions;

		return right;

};

/*_________________________________________________________________*/

TUCounts::~TUCounts ()
{
empty();
}

/*_________________________________________________________________*/

void TUCounts::empty ()
{
zap(parentalHaplotypesList);
zap(haplotypeTUCountsVector);
zap(expandedHaplotypeVector);

zap(copyHaplotypeTUCountsVector);

zap(treeEmtpyNodes);
}



/*_________________________________________________________________*/

TUCounts::TUCounts():GeneticCounts()
{
permutations=NULL;
parentalGenotypes=NULL;
parentalHaplotypesList=NULL;
haplotypeTUCountsVector=NULL;
expandedHaplotypeVector=NULL;
this->copyHaplotypeTUCountsVector=NULL;
treeEmtpyNodes=NULL;
}
/*_________________________________________________________________*/
/*
void TUCounts::divideSample()
{
genericSample=new TrioSample(filename);
}




/*_________________________________________________________________*/
/*
int TUCounts::getTotalPermutations ()
{
if (permutations==NULL) setPermutations();
return totalPermutations;
}

/*_________________________________________________________________*/

void TUCounts::print(ostream& out)
       {
GeneticCounts::print(out);
          
out <<*getParentalGenotypes() <<"\n";
out <<*parentalHaplotypesList <<"\n";
if (haplotypeTUCountsVector!=NULL)
   out << *haplotypeTUCountsVector << "\n";
if (getPermutations()!=NULL) out <<"\nTotal permutations generated:\t" << getTotalPermutations() <<"\n";
};
/*_________________________________________________________________*/

VectorOfParentalHaplotypes* TUCounts::getParentalHaplotypesList()
{
return parentalHaplotypesList;
}

/*_________________________________________________________________*/

void TUCounts::setPermutations ()
{
if (permutations!=NULL) return;
permutations=new GenericCounts*[totalPermutations];
VectorOfParentalGenotypes* genotypePermutation;
//if (parentalGenotypes->getTotalPositions()<200 && parentalGenotypes->getPermutations()==NULL)
// parentalGenotypes->setPermutations(totalPermutations);
//else 
srand(1000); // this way permutations of the genotpyes will be always the same for each window
if (hapExtractionConfiguration->alleleOrderType!=LeftRight) throw
NonImplemented("TUCounts::setPermutations");
int* relativePositions=new int[getTotalPos()], *sequencedPositions=NULL;
//if (parentalGenotypes->getTotalPositions()>=200) 

// sequencedPositions=initializeFrom(0, getTotalPos());

for (int j=0; j<getTotalPos(); j++)
relativePositions[j]=parentalHaplotypesList->getPositions()[j];
//cout <<"\nrelpos at " << j <<": " << relativePositions[j] <<"\n";
for (int i=0; i<totalPermutations; i++)
{
//if (parentalGenotypes->getTotalPositions()>=200) 
genotypePermutation=parentalGenotypes->getOnePermutation(relativePositions, getTotalPos());
sequencedPositions=initializeFrom(0, getTotalPos());
permutations[i]=genotypePermutation->getTUCounts(hapExtractionConfiguration, 0, sequencedPositions, getTotalPos());
zap(genotypePermutation);
zap(sequencedPositions);
//else permutations[i]=parentalGenotypes->getPermutations()[i]->getTUCounts(hapExtractionConfiguration, 0, relativePositions, getTotalPos());
}
zaparr(relativePositions);
//zaparr(sequencedPositions);
}





};  // End of Namespace

#endif

/* End of file: MultimarkerMeasure.h */

//stringList * BIOS::TUCounts::getTDTFreqsResults(SNPPos snpPos)
//{
//}






