/* File: PhylogeneticDistance.h */

#ifndef __TUCounts_h__
#define __TUCounts_h__

//using namespace stats;

namespace BIOS {


/************************/
/* SNP'S MultimarkerMeasure DEFINITION */
/************************/


/**
        @memo TUCounters for a given window in a TrioSample

	@doc
        Definition:

       Class used mainly to compute multimarker TU measures. In order to similarity measures to can be applied, haplotype counters (or freqs if EM-freq is used) for each couple must be independently kept 

       With this purpose, the data structures required is:
 
       Container<vector, ParentalHaplotypes> *parentalHaps   

        @author Maria M. Abad
	@version 1.0
*/


 
class	TUCounts: public GeneticCounts {

private:

//HapExtractionConfiguration* hapExtractionConfiguration;//how haps were extracted from genotytpes
VectorOfParentalGenotypes* parentalGenotypes; // genotype counters, required to compute permutations



public:


HaplotypeTUCountsVector* haplotypeTUCountsVector; 

// ***** FOR treedtmeasure
//! Vector of haplotypes vector with repetitions and freq=1 per haplotype
HaplotypeTUCountsVector* expandedHaplotypeVector;

//! Copy used for permutations
HaplotypeTUCountsVector* copyHaplotypeTUCountsVector;

//! to keep track of the inner nodes created 
HaplotypeTUCountsVector* treeEmtpyNodes;
		
// *** end treedtmeasure
		
VectorOfParentalHaplotypes* parentalHaplotypesList; // used for some algorithms that require to know the combination of haplotypes that each family has



/*********************************************************************/
/***     ASSOCIATED FUNCTIONS     ***/
/*********************************************************************/

private:


//void set(SNPPos Pos[], SNPPos totalPos, TrioSample * samp, HapExtractionConfiguration* hapExtractionConfiguration, int totalPermutations);  



      public:

TUCounts();

//	TUCounts(SNPPos Pos[], SNPPos totalPos, TrioSample * samp, AlleleOrderType alleleOrderType=LeftRight, PhaseAlg=weighted, EMDistributions emDistributions=UTDistributions, EMRestriction emRestriction=triosBasedRestriction, int totalPermutations=100);

TUCounts(VectorOfParentalGenotypes* parentalGenotypes, HapExtractionConfiguration* hapExtractionConfiguration, HaplotypeTUCountsVector* haplotypeTUCountsVector, VectorOfParentalHaplotypes* parentalHaplotypesList, int totalPermutations=100);
TUCounts* filter(int pos, int length);

//TUCounts(char* filename, HapExtractionConfiguration* hapExtractionConfiguration, int totalPermutations);
	
 TUCounts(TUCounts& source);
 

 virtual TUCounts* clone();

virtual ~TUCounts();

virtual void empty();

virtual VectorOfParentalGenotypes* getParentalGenotypes();


//TUCounts** getPermutations();

void setPermutations ();

//int  getTotalPermutations ();

TUCounts* filter(int *relativePositions, int size);

virtual VectorOfParentalHaplotypes* getParentalHaplotypesList();

/**
 * Creates a new TUCounts with the left half positions, inverting the order.
 * For example, given a TUCounts with haplotypeTUCountsVector of 10 positions {0,1,...,9}
 * the returned haplotypeTUCountsVector will have positions {4,3,2,1,0}
 * @return The new created TUCounts
 */
TUCounts* filterLeftHalf();

/**
 * Creates a new TUCounts with the right half positions.
 * For example, given a TUCounts with haplotypeTUCountsVector of 10 positions {0,1,...,9}
 * the returned haplotypeTUCountsVector will have positions {5,6,7,8,9}
 * @return The new created TUCounts
 */
TUCounts* filterRightHalf();



virtual void print(ostream&);

};  // End of class TUCounts








};  // End of Namespace

#endif

/* End of file: MultimarkerMeasure.h */




