#ifndef TUMLTest_cpp//
#define TUMLTest_cpp//






//using namespace UTILS;

namespace BIOS
{

  TUMLTest::TUMLTest (char* fileSample, TestModeClass *internalTestMod, TestModeClass *externalTestMod, HapExtractionConfiguration* hapExtractionConfiguration, int totalPermutations, bool useOnlyHetero, int verbose) :HaplotypeMLTest (fileSample, internalTestMod, externalTestMod, hapExtractionConfiguration, totalPermutations, 3, verbose) // 3 is to say that information in each sample file has to be split together in trios (trio samples)
  {
  try
  {
    this->useOnlyHetero=useOnlyHetero;
checkOrder(fileSample);
    }
catch (BasicException & be){be.addMessage("\ncalled from TUMLTest::TUMLTest (char* fileSample, TestModeClass *testMod, HapExtractionConfiguration* hapExtractionConfiguration, int totalPermutations, bool useOnlyHetero)"); throw;};
  }
  
    /*___________________________________________________________ */
  

  
   void  TUMLTest::checkOrder(char*fileSample)
    {
      TrioSample* ts=new TrioSample (fileSample, NULL, 0, hapExtractionConfiguration->alleleOrderType);
if (!ts->groupedFamilies())
{
cout << "some families are not written in consecutive lines at file " << fileSample << "\n";
//throw BadFormat("TUMLTest::TUMLTest (char* fileSample, TestModeClass *internalTestMod, TestModeClass *externalTestMod, HapExtractionConfiguration* hapExtractionConfiguration, int totalPermutations, bool useOnlyHetero)");
//exit(0);
zap(ts);
exit(0);
}
zap(ts);
    }

  /*___________________________________________________________ */
  
    TUMLTest::TUMLTest (char* fileSample,char* secondFileSample, HapExtractionConfiguration* hapExtractionConfiguration, int totalPermutations, bool useOnlyHetero, int verbose) :HaplotypeMLTest (fileSample, secondFileSample, hapExtractionConfiguration, totalPermutations, 3, verbose) // 3 is to say that information in each sample file has to be split together in trios (trio samples)
  {
  try
  {
this->useOnlyHetero=useOnlyHetero;
checkOrder(fileSample);
checkOrder(secondFileSample);

     


  }
catch (BasicException & be){be.addMessage("\ncalled from  TUMLTest::TUMLTest (char* fileSample,char* secondFileSample, HapExtractionConfiguration* hapExtractionConfiguration, int totalPermutations, bool useOnlyHetero)"); be.PrintMessage(); throw;};
  }

  /*___________________________________________________________ */


  TUMLTest::~TUMLTest()
  {
  }
  
  /*___________________________________________________________ */

GenericSample*  TUMLTest::mergeSamples (GenericSample* first, GenericSample* second) //char* file, int*pos, int length)
{
    try
    {
       VectorOfParentalGenotypes* result=(VectorOfParentalGenotypes*) GenericMLTest::mergeSamples(first, second);
       
	ParentalGenotypesUsingPointers* element;
	int i=first->size();
	for (VectorOfParentalGenotypes::iterator it=result->getNode(first->size()); it<result->end(); it++)
	{
	  element=*it;
	  element->trioCount=i;
	  i++;
	}
	
        return result;
    }
    catch (BasicException& be) {
        be.addMessage ("\ncalled from GenericSample*  GenericMLTest::mergeSamples (GenericSample* first, GenericSample* second)  ");
        throw;
    };
}

  /*___________________________________________________________ */

  GenericSample*  TUMLTest::getSample (char* file, int*pos, int length)
  {
    try
    {
       TrioSample *hapSample=NULL;
      bool completeMis=true, allowRecombination=false, solveMIUsingChildren=false, completeFamily=true, exitWhenIncompleteFamily=true;
    //   int sizeInPhase=7;//maxi(7,length);
//cout <<"length is:" << length <<" and size is:" << sizeInPhase <<"\n";
//cout << "getting sample from file " << file <<"\n";
      TrioSample* ts=new TrioSample (file, NULL, 0, hapExtractionConfiguration->alleleOrderType, completeMis, allowRecombination, solveMIUsingChildren, completeFamily, exitWhenIncompleteFamily, verbose);
//cout <<"now\n";
/*
      if (hapExtractionConfiguration->alleleOrderType==LeftRightUsingTrios && hapExtractionConfiguration->phaseAlg==maxFreq)
      {
      hapSample=ts->solvePhase (hapExtractionConfiguration->emDistributions, hapExtractionConfiguration->emRestriction, sizeInPhase );
      zap(ts);
      ts=hapSample;
}
 if (hapExtractionConfiguration->alleleOrderType==LeftRightUsingTrios)
      hapExtractionConfiguration2->alleleOrderType=LeftRight;
*/
//BIOS::print(pos, length, cout);
      VectorOfParentalGenotypes* result=ts->getGenotypeCounts (pos, length, hapExtractionConfiguration, true);// it only works for left/right and incomplete left/right so far

       // exit(0);
//cout <<"gen\n";
     zap (ts);
     return  result;
    }
    catch (BasicException& be) {be.addMessage ("\ncalled from GenericSample*  TUMLTest::getSample(char* file, int* pos, int size) "); throw;};
  }



  /*___________________________________________________________ */

  SampleGenericCounts*  TUMLTest::getCounts (GenericSample* ts, int* pos, int windowSize)
  {
    try
    {
bool includeMissing=true; // if false almost all haplotypes are lost when working with sliding windows

//BIOS::print(pos, windowSize, cout);
//cout << "inside getcounts\n";
      SampleTUCounts* results= (SampleTUCounts*)( (VectorOfParentalGenotypes*) ts)->getSampleTUCounts (hapExtractionConfiguration2, totalPermutations, pos, windowSize, includeMissing);
if (verbose>0) cout << "total size in each window/chunk: " << results->getTotalPos() <<"\n";
if (verbose>0) cout << "total size in each parental genotype:" << results->getParentalGenotypes()->getTotalPositions() <<"\n";
if (1==0)
if (windowSize>10)
{
cout <<"tucounts:" << *results;
exit(0);
}
      return results;
    }
    catch (BasicException& be) {be.addMessage ("\ncalled from  SampleGenericCounts*  TUMLTest::getCounts(char* file, int* pos, int size)"); throw;};
  }
} // end namespace
#endif
