#ifndef __Chi2TDTMeasure_h__
#define __Chi2TDTMeasure_h__

namespace BIOS {
	
  /**
     @memo Chi2TDTMeasure
     @doc
     Definition:
	  Abstract class generalizing all Chi2-based TDT measures

     @author María del Mar Abad Grau
     @version 1.0
	
	*/	
class Chi2TDTMeasure: public SimpleTUMeasure {
    
protected:
  
  AssociationTable* tdtTable;

  //int minFreq;
  

		public:
	

		/**
		*	Constructor
		*/		
	//	Chi2TDTMeasure(bool permutations=false);

		/**
		*	Destructor
		*/		
	virtual	~Chi2TDTMeasure();

 // virtual GenericMeasure* getNewMeasure(TUCounts* tuCounts)=0;


		/**
		*	Constructor 
		*	@param tuCounts Hapcounts to be used
		*/		
Chi2TDTMeasure(SampleGeneticCounts* tuCounts, double minFreq=0, bool permutations=false, bool left=true);

		Chi2TDTMeasure(double minFreq=0, bool permutations=false, bool left=true);
		
		//virtual Chi2TDTMeasure* getNewMeasure(TUCounts* tuCounts)=0;

	virtual Chi2TDTMeasure* inferMeasure(SampleGeneticCounts* tuCounts);

virtual 	void update ( AssociationTable* aTdtTable, SampleGeneticCounts* hapCounts, bool useDistances=true, bool treeDT=false, int position=0, bool toLeft=false );

		Chi2TDTMeasure(Chi2TDTMeasure& other);

virtual Chi2TDTMeasure* clone()=0;

		/**
		*	Calculate statistic from the tables 
		*/



  //virtual stringList* getFreqsResults();

//virtual string getName();

	virtual double getStatistic();

	double getWeightedStatistic(doubleList* weights);

	doubleList* getFreqs();

// virtual double getPValWithPermutations();

 virtual double getPVal();

virtual int getTestMode(){throw BadFormat("Chi2TDT::getTestMode() should not be called");};

virtual void setTestMode(int testMode){throw BadFormat("Chi2TDT::setTestMode(int testMode) should not be called");};

AssociationTable* getTDTtable();

//virtual stringList* getFreqsResults();

virtual stringList*  getHeadFile();


//friend ostream& operator<<(ostream& out, Chi2TDTMeasure& l);

virtual void print( ostream&);

//virtual void Chi2TDTMeasure::onePrint(ostream& out, SampleTUCounts* aTuCounts, TDTtable* aTDTtable);

};
/*{
out << (TUMeasure&)l <<"\n";

out << *l.getTDTtable() <<"\n";
}
*/

};

#endif
