#ifndef __CompositeTUMeasure_cpp__
#define __CompositeTUMeasure_cpp__


namespace BIOS {

CompositeTUMeasure::CompositeTUMeasure(CompositeTUMeasure & other)
	{
		this->measureLeft = other.measureLeft->clone();		
		this->measureRight = other.measureRight->clone();	

		this->measureLeft->setCounts(other.measureLeft->getCounts()->clone());
		this->measureRight->setCounts(other.measureRight->getCounts()->clone());
	}

/*______________________________________________________________________________________________________________*/

	CompositeTUMeasure::CompositeTUMeasure(TUMeasure *  measureLeft, TUMeasure *measureRight,  double minFreq)
	{
		this->measureLeft = measureLeft;
		this->measureRight = measureRight;
	};

/*______________________________________________________________________________________________________________*/

	CompositeTUMeasure::CompositeTUMeasure(SampleGeneticCounts* geneticCounts, TUMeasure *  measureLeft, TUMeasure *measureRight,  double minFreq):TUMeasure(geneticCounts)
	{

		if ( geneticCounts == NULL) 
			throw null_tuCounts;

		this->setCounts(geneticCounts);

		this->measureLeft = measureLeft;
		this->measureRight = measureRight;

		this->measureLeft->setCounts( geneticCounts->filterLeftHalf() );
		this->measureRight->setCounts( geneticCounts->filterRightHalf() );

	};

/*______________________________________________________________________________________________________________*/

CompositeTUMeasure::~CompositeTUMeasure()
	{
		if (measureLeft->getCounts() != NULL)
			delete measureLeft->getCounts();
		if (measureRight->getCounts() != NULL)
			delete measureRight->getCounts();
		delete measureLeft;
		delete measureRight;
		
	}
/*______________________________________________________________________________________________________________*/

double CompositeTUMeasure::getPVal()
	{
		double p_right, p_left;
		
		p_right = measureRight->getPVal();
		p_left = measureLeft->getPVal();

		return p_right * p_left;


	}

/*______________________________________________________________________________________________________________*/

string CompositeTUMeasure::getName(){
		return string("TDTComposite("  + measureLeft->getName() + ", " + measureRight->getName() + ")" );
	};

/*______________________________________________________________________________________________________________*/
	
CompositeTUMeasure* CompositeTUMeasure::clone(){
 		return new CompositeTUMeasure(*this);
	};

/*______________________________________________________________________________________________________________*/

CompositeTUMeasure* CompositeTUMeasure::getNewMeasure(SampleGenericCounts* geneticCounts, SampleGenericCounts** training, SampleGenericCounts** test)
	{
		return new CompositeTUMeasure((SampleGeneticCounts*)geneticCounts, measureLeft, measureRight, this->minFreq);
	};

/*______________________________________________________________________________________________________________*/

CompositeTUMeasure* CompositeTUMeasure::inferMeasure(SampleGeneticCounts* genericCounts)
	{
		SampleGenericCounts * tuLeft = genericCounts->filterLeftHalf();
		SampleGenericCounts * tuRight = genericCounts->filterRightHalf();

		CompositeTUMeasure * compositeMeasure = new CompositeTUMeasure(measureLeft->inferMeasure((TUCounts*)tuLeft), measureRight->inferMeasure((SampleGeneticCounts*)tuRight), this->minFreq);
		compositeMeasure->counts = genericCounts;

		return compositeMeasure;
		
	};
	
};

#endif
