#ifndef __CompositeTUMeasure_h__
#define __CompositeTUMeasure_h__

namespace BIOS {
	
	/**
		@memo CompositeTUMeasure
		@doc
		Definition:

		TreeDT algorithm inspired in Sevon et al. "TreeDT: Tree Pattern Mining for Gene Mapping" (2006)

		@author Jose J. Moreno
		@version 1.0
	*/	
	


class CompositeTUMeasure: public TUMeasure{

	  protected:
		//TUCounts* tuCounts;
		//! haplotype vector extracted from tuCounts
		//HaplotypeTUCountsVector* v;

		//! Measure applied to the left side
		TUMeasure *measureLeft;


		//! Measure applied to the right side
		TUMeasure *measureRight;



		public:

		/**
		 * Copy constructor
		 * @param other Measure to clone
		 */
		CompositeTUMeasure(CompositeTUMeasure & other);

		/**
		 * Creates a new composite measure
		 * @param tuCounts Trio data information
		 * @param measureLeft Left measure
		 * @param measureRight Right measure
		 * @param minFreq 
		 */
		CompositeTUMeasure(SampleGeneticCounts* tuCounts, TUMeasure * measureLeft, TUMeasure * measureRight, double minFreq=10);

		/**
		 * Creates a new composite measure		 
		 * @param measureLeft Left measure
		 * @param measureRight Right measure
		 * @param minFreq 
		 */
		CompositeTUMeasure(TUMeasure * measureLeft, TUMeasure * measureRight, double minFreq=10);

		~CompositeTUMeasure();

		/**
		*	Calculates the p-value of the sample set as the minimum p_k. 
		*	A p_k value is calculated for each k.
		*	@see getPvalueForK()
		*	@return p-value		
		*/

		virtual double getPVal();

		
		virtual double getStatistic(){};
		
		virtual string getName();
		
		virtual CompositeTUMeasure* clone();
		virtual stringList* getHeadFile(){};
		virtual void print(ostream&){};
		virtual CompositeTUMeasure* getNewMeasure(SampleGenericCounts* tuCounts, SampleGenericCounts** training=NULL, SampleGenericCounts** test=NULL);
		virtual CompositeTUMeasure* inferMeasure(SampleGeneticCounts* tuCounts);

	};

	class NULL_TUCOUNTS_CompositeTUMeasure: public exception
	{
	virtual const char* what() const throw()
	{
		return "tuCounts cannot be NULL in CompositeTUMeasure";
	}
	} null_tuCounts;

};

#endif
