#ifndef __EntropyTDTMeasure_cpp__
#define __EntropyTDTMeasure_cpp__

#include "EntropyTDTMeasure.h"



namespace BIOS {

		EntropyTDTMeasure::EntropyTDTMeasure(SampleGeneticCounts* tuCounts, double minFreq, bool permutations, bool left):Chi2TDTMeasure(tuCounts, minFreq, permutations, left)
{
		};

/*_________________________________________________________________*/

				EntropyTDTMeasure::EntropyTDTMeasure(double minFreq, bool permutations, bool left):Chi2TDTMeasure(minFreq, permutations, left)
{
		};

/*_________________________________________________________________*/

				EntropyTDTMeasure::EntropyTDTMeasure(EntropyTDTMeasure& other):Chi2TDTMeasure(other)
{
		};

/*_________________________________________________________________*/

				EntropyTDTMeasure::~EntropyTDTMeasure(){
		};
		
			/*___________________________________________________________________________________*/
 
 
		 string EntropyTDTMeasure::getName()
 {
 string result=string("EntropyTDT");
 if (this->minFreq!=0) result=result+string("_minFreq")+tos(this->minFreq);
 if (this->permutations) result=result+this->addPermutationsInName();
 return result;
 };

/*_________________________________________________________________*/

		  EntropyTDTMeasure* EntropyTDTMeasure::getNewMeasure(SampleGenericCounts* tuCounts, SampleGenericCounts** training, SampleGenericCounts** test)
{
return new EntropyTDTMeasure((SampleGeneticCounts*)tuCounts, this->minFreq, this->permutations);
}

/*_________________________________________________________________*/

				EntropyTDTMeasure* EntropyTDTMeasure::clone(){
  return new EntropyTDTMeasure(*this);
		};


/*_______________________________________________________________________________*/


				double EntropyTDTMeasure::getStatistic()
		{
double condT, condU, tCounts, uCounts, ni, result=0;
if (this->tdtTable==NULL) return 0;
for (int i=0; i<this->tdtTable->getYDim(); i++)
{
tCounts=this->tdtTable->getValue(0,i);
uCounts=this->tdtTable->getValue(1,i);
ni=tCounts+uCounts; 
condT=tCounts/(double)ni; 
condU=uCounts/(double)ni;  
if (condT!=0 && condU!=0)
result+=ni*std::pow(condT*log(condT)-condU*log(condU), 2)/(condT*condU*std::pow(2+log(condT)+log(condU),2)); 
else  result+ni;
}
return result*(this->tdtTable->getYDim()-1)/(double)this->tdtTable->getYDim();
		};

/*_____________________________________________________________________________________________________________*/






/*_____________________________________________________________*/

			double EntropyTDTMeasure::getPVal()
  {
if (!this->permutations) 
if (this->tdtTable!=NULL) return pdfTestChiSquare(getStatistic(),this->tdtTable->getYDim()-1);
else return 1;
else return SimpleTUMeasure::getPVal(); 
  }


};

#endif
