#ifndef __EntropyTDTMeasure_h__
#define __EntropyTDTMeasure_h__

namespace BIOS {
	
  /**
     @memo EntropyTDTMeasure
     @doc
     Definition:
	 Class to compute TDTP statistic, which weighs each summand in the mTDT by haplotype frequencies and its null distribution is a weighted chi2

     @author María del Mar Abad Grau
     @version 1.0
	
	*/	
 class EntropyTDTMeasure: public Chi2TDTMeasure {
    


		public:
	

		/**
		*	Constructor
		*/		
//		EntropyTDTMeasure();

		/**
		*	Destructor
		*/		
	virtual ~EntropyTDTMeasure();

  virtual EntropyTDTMeasure* getNewMeasure(SampleGenericCounts* tuCounts, SampleGenericCounts** training=NULL, SampleGenericCounts** test=NULL);


		/**
		*	Constructor 
		*	@param p 
		*/		
		EntropyTDTMeasure(SampleGeneticCounts* tuCounts, double minFreq=10, bool permutations=true, bool left=true);

		EntropyTDTMeasure(double minFreq=10, bool permutations=true, bool left=true);

		EntropyTDTMeasure(EntropyTDTMeasure& other);

EntropyTDTMeasure* clone();


virtual string getName();//{return string("mTDTP");};

		/**
		*	Calculate statistic from the tables 
		*/

	double getStatistic();

	//doubleList* getHapFreqs();


	double getPVal();


//virtual ostream& print( ostream&);

//friend ostream& operator<<(ostream& out, EntropyTDTMeasure& l)
//{
//out << (Chi2TDTMeasure&)l <<"\n";

//}

	};




};

#endif
