#ifndef __G2Measure_cpp__
#define __G2Measure_cpp__




/*_____________________________________________________________*/
/*
void print ( BIOS::G2Measure *t )
{
	cout << *t << endl;
}


/*_____________________________________________________________*/


namespace BIOS
{

	G2Measure::G2Measure ( SampleGeneticCounts* tuCounts, double minFreq, int testMode, SampleGeneticCounts** partialTuCountsTraning, SampleGeneticCounts** partialTuCountsTest, bool useDistances, bool lengthDistance ) :GroupBasedTDTMeasure ( tuCounts, minFreq, testMode, partialTuCountsTraning, partialTuCountsTest, false, useDistances, lengthDistance )
	{
		try
		{
			this->totalMultipleTest=0;
			if ( this->testMode==-1 && this->tdtTable!=NULL && this->tdtTable->partition!=NULL ) this->totalMultipleTest=std::pow ( 2, ( double ) this->tdtTable->partition->size()-1 )-1;//Bonferroni
			this->setAll();
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from G2Measure::G2Measure(SampleGeneticCounts* tuCounts, double minFreq, bool left)" ); throw;};
	};

	/*_____________________________________________________________*/
/*
AssociationTable* G2Measure::set ( SampleGeneticCounts* aTUCounts )
	{
// It creates and return a new TDTtable with only two columns, one for each group in 2G algorithm
// T will be HaplotypeTUCountsVector, which inherits from HaplotypeTUCountsList, or HaplotypeCaseControlCountsList
// so both T inherits from HaplotypeCountsList
		try
		{
			if ( aTUCounts==NULL ) return NULL;

			return aTUCounts->createAssociationTable(this->minFreq);


		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from G2Measure::set()" ); throw;};
	}

			/*_____________________________________________________________*/

	GeneticUnitCountsSample* G2Measure::getPartition (GeneticUnitCountsVector* hapCountsVector, double totalFirst, double totalSecond)
	{
GeneticUnitCountsSample * p=new GeneticUnitCountsSample();
			p->insertElement ( new GeneticUnitCountsVector() );
			p->insertElement ( new GeneticUnitCountsVector() );
		//	HaplotypeCounts* h;
		double estimationFirst, estimationSecond;
		for ( GeneticUnitCountsVector::iterator it=hapCountsVector->begin(); it!=hapCountsVector->end();it++ )
		{
// for each haplotypeTUCounts
			//		h=hapCountsVector->getElement ( it );
			if ( hapCountsVector->getElement ( it ) !=NULL) // && !hapCountsVector->getElement ( it )->getHaplotype()->hasAMissingPosition() )
				if ( ( ( hapCountsVector->getElement ( it )->getFirstFrequency() +hapCountsVector->getElement ( it )->getSecondFrequency() ) ) >=minFreq )
				{
					estimationFirst=hapCountsVector->getElement ( it )->getFirstFrequency() /totalFirst;
					estimationSecond=hapCountsVector->getElement ( it )->getSecondFrequency() / totalSecond;
					if ( estimationFirst>estimationSecond ) 
p->getElement ( 0 )->insertHardElement ( hapCountsVector->getElement ( it ) );
					if ( estimationFirst<estimationSecond) {p->getElement ( 1 )->insertHardElement ( hapCountsVector->getElement ( it ) );}
				}
		}
return p;
	}


	/*_____________________________________________________________*/

G2Measure::G2Measure ( double minFreq, int testMode, bool useDistances, bool lengthDistance ) :GroupBasedTDTMeasure( minFreq, testMode, false, useDistances, lengthDistance )
	{
		this->totalMultipleTest=0;
	}


	/*_____________________________________________________________*/

G2Measure::G2Measure ( G2Measure& other ) :GroupBasedTDTMeasure ( other )
	{
		this->totalMultipleTest=other.totalMultipleTest;
	}

	
	/*_________________________________________________________________*/

G2Measure* G2Measure::getNewMeasure ( SampleGenericCounts* tuCounts, SampleGenericCounts** training, SampleGenericCounts** test )
	{
		try
		{
			return new G2Measure ( (SampleGeneticCounts*)tuCounts, this->minFreq, this->testMode, (SampleGeneticCounts**)training, (SampleGeneticCounts**)test, this->useDistances, this->lengthDistance );
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from G2Measure* G2Measure::getNewMeasure(TUCounts* tuCounts, SampleTUCounts** training, SampleTUCounts** test)" ); throw;};
	}

	/*____________________________________________________________________________*/


G2Measure::~G2Measure()
	{
	};

	/*____________________________________________________________________________*/


G2Measure*	G2Measure::clone()
	{
		return new G2Measure ( *this );
	};

	/*____________________________________________________________________________*/

string G2Measure::getName()
	{
		string result=string ( "mTDT2G" );
		if ( this->testMode==0 ) result=result+string ( "_noCorrection" );
		if ( this->testMode==-1 ) result=result+string ( "_Bonferroni" );
		if ( this->testMode>=2 ) result=result+string ( "_cv" ) +tos ( this->testMode );
		if ( this->testMode==1 ) result=result+string ( "_holdout" );
		if ( this->useDistances ) 
  if (this->lengthDistance) result=result+string ( "_useLengthDistances" );
  else result=result+string ( "_useBiosDistances" );
		if ( this->minFreq!=0 ) result=result+string ( "_minFreq" ) +tos ( this->minFreq );
//if (permutations) result=result+string("_")+tos(tuCounts->getTotalPermutations())+string("permutations");
		return result;
	}
	/*_________________________________________________________________*/

stringList*  G2Measure::getHeadFile()
	{
		stringList *result=new stringList();
		result->insertElement ( string ( "FirstSNP" ) );
		result->insertElement ( string ( "pVal " ) );
		result->insertElement ( string ( "TotalUsedDifferentHaplotypesInG1 // " ) );
		result->insertElement ( string ( "T/U G1 // " ) );
		result->insertElement ( string ( "TotalUsedDifferentHaplotypesInG2 //" ) );
		result->insertElement ( string ( "T/U G2" ) );
		return result;
	};

	/*_____________________________________________________________*/

	
double G2Measure::getOR()
	  {
	  try
	{
double result=0; 
if (this->partialTdtTables==NULL  || this->partialTdtTables->size()==0) return this->tdtTable->getValue ( 0,0 )/(double)this->tdtTable->getValue(1,0);
for (Vector<AssociationTable*>::Class::iterator it=this->partialTdtTables->begin(); it<this->partialTdtTables->end(); it++)
{
if (this->partialTdtTables->getElement(it)!=NULL)
result=result+this->partialTdtTables->getElement(it)->getValue(0,0)/(double)this->partialTdtTables->getElement(it)->getValue(1,0);
}
return result;
}
	catch (BasicException& be) {be.addMessage ("\ncalled from GroupBasedTDTMeasure::getPVal()"); throw;};

	  }


	/*____________________________________________________________________________________________*/

bool G2Measure::getOneSide()
	{
		return false;
	}

/*_____________________________________________________________________________________________________________*/



/*_____________________________________________________________________________________________________________*/


void G2Measure::posPrinting ( ostream& out, SampleGeneticCounts* aTuCounts)
	{
try
{
//BIOS::print(aTuCounts->getParentalGenotypes()->getPositions(), aTuCounts->getTotalPos(), cout);
//BIOS::print(aTuCounts->getPositions(), aTuCounts->getTotalPos(), cout);
out << (aTuCounts)->getAbsolutePositions() [0] <<"\t"; // before was: aTuCounts->getParentalGenotypes()->getPositions()
}
	catch ( BasicException& be ) {be.addMessage ( "\ncalled from 	void G2Measure::parentalPrinting ( ostream& out, SampleGeneticCounts* aTuCounts)" ); throw;};
}
	/*_____________________________________________________________________________________________________________*/


void G2Measure::onePrint ( ostream& out, SampleGeneticCounts* aTuCounts, AssociationTable* aTDTtable, int subsample, int position )
	{
try
{
//cout <<*aTDTtable <<"\n";
  if (aTuCounts==NULL)
  out << "no counts";
  else
  {
  posPrinting(out, aTuCounts); 
		if ( aTDTtable!=NULL )
		{
			for ( int i=1; i<3; i++ )
			{
				aTDTtable->partition->getElement ( i-1 )->setDelimiters ( '\0', '\0' );
//if (i==2) out <<"\n";
   out << this->getPVal(position, subsample) << "\t";
				out << "G" << i <<":\t" << *aTDTtable->partition->getElement ( i-1 );
				out <<"\tT:\t" << aTDTtable->getValue ( 0,i-1 ) << "\tU: \t" << aTDTtable->getValue ( 1,i-1 );
				if ( i==1 ) out <<"\t";
				aTDTtable->partition->getElement ( i-1 )->setDelimiters ( '[', ']' );
			}
		}
		else out <<"nullTable";
  }

	}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from void G2Measure::onePrint ( ostream& out, SampleGeneticCounts* aTuCounts, TDTtable* aTDTtable, int subsample, int position )" ); throw;};
//TDTtable * BIOS::G2Measure::set(SampleGeneticCounts< T > * aTUCounts)
	
};


}

#endif
