#ifndef __G2Measure_h__
#define __G2Measure_h__

namespace BIOS {
	
  /**
     @memo G2Measure
     @doc
     Definition:
	Table to store T/U frecuencies for the TDT algorithm

     @author María del Mar Abad Grau
     @version 1.0
	
	*/	
class G2Measure: public GroupBasedTDTMeasure {


    
		public:
	

		/**
		*	Constructor
		*/		
		G2Measure(SampleGeneticCounts* tuCounts, double minFreq=10, int testMode=2, SampleGeneticCounts** partialTuCountsTraining=NULL, SampleGeneticCounts** partialTuCountsTest=NULL, bool useDistance=true, bool lengthDistance=false);
		
		G2Measure(double minFreq, int testMode, bool useDistances=true, bool lengthDistance=false);

				G2Measure(G2Measure& other);

		/**
		*	Destructor
		*/		
virtual		~G2Measure();

//void setAll();

	// virtual	AssociationTable*  set(SampleGeneticCounts* aTUCounts=NULL);

//void set(TDTtable* aTDTtable);

virtual G2Measure* clone();

virtual  bool getOneSide();

//virtual double getStatistic();

  virtual G2Measure* getNewMeasure(SampleGenericCounts* tuCounts, SampleGenericCounts** training=NULL, SampleGenericCounts** test=NULL);
  
  	//	virtual G2Measure* inferMeasure(TUCounts* tuCounts);

 // virtual G2Measure* getNewMeasure(HapExtractionConfiguration* hapExtractionConfiguration, double minFreq=0, bool useModel=true);

		/**
		*	Calculate statistic from the tables 
		*/

//virtual double getPVal();	
	
virtual stringList* getHeadFile();

virtual GeneticUnitCountsSample* getPartition (GeneticUnitCountsVector* hapCountsVector, double totalFirst, double totalSecond);

virtual double getOR();

string getName();//{return string("mTDT2G");};

// stringList* getFreqsResults();

//friend ostream& operator<<(ostream& out, G2Measure& l);

void posPrinting ( ostream& out, SampleGeneticCounts* aTuCounts);

virtual void onePrint( ostream&, SampleGeneticCounts* aTuCounts, AssociationTable* aTDTtable, int subsample, int position=-1);

void parentalPrinting ( ostream& out, SampleGeneticCounts* aTuCounts);

	};




};

#endif
