#ifndef __G2TreeMeasure_cpp__
#define __G2TreeMeasure_cpp__




/*_____________________________________________________________*/
/*
void print ( BIOS::G2TreeMeasure *t )
{
	cout << *t << endl;
}


/*_____________________________________________________________*/


namespace BIOS
{

	G2TreeMeasure::G2TreeMeasure ( SampleGeneticCounts* tuCounts, double s, double minFreq, int testMode, SampleGeneticCounts** partialTuCountsTraning, SampleGeneticCounts** partialTuCountsTest, bool useDistances, bool lengthDistance ) :G2Measure( tuCounts, minFreq, testMode, partialTuCountsTraning, partialTuCountsTest, useDistances, lengthDistance )
	{
		try
		{
			//cout << "next G2tree constructor \n";
			this->s=s;
			if ( s<2 )
				throw BadFormat ( "G2TreeMeasure::G2TreeMeasure ( SampleTUCounts* tuCounts, double s, double minFreq, int testMode, SampleTUCounts** partialTuCountsTraning, SampleTUCounts** partialTuCountsTest, bool useDistances )" ); // Beta distribution may be sparsed
			zap ( this->tdtTable );
			zap ( this->partialTrainingTdtTables );
			zap ( this->partialTdtTables );
			this->setAll();
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from G2TreeMeasure::G2TreeMeasure(TUCounts* tuCounts, double minFreq, bool left)" ); throw;};
	};

	/*_____________________________________________________________*/



	double G2TreeMeasure::getWeightedTotalCounts (GeneticUnitVector * g, SampleGeneticCounts* aTUCounts, intSet* hapPos, doubleList* posteriors )
	{
		double totalCounts=0;
		HaplotypeCounts* h=NULL;
		Haplotype *hap=NULL;
		for (GeneticUnitCountsVector::iterator it=aTUCounts->countsVector->begin(); it!=aTUCounts->countsVector->end();it++ )
		{
			h= (HaplotypeCounts*)aTUCounts->countsVector->getElement ( it );
			hap=h->getHaplotype();
			for ( intSet::iterator it=hapPos->begin(); it!=hapPos->end(); it++ )
				if ( *g->getElement ( *it ) ==*hap ) {totalCounts=totalCounts+posteriors->getElement ( *it ) * ( h->getFirstFrequency() +h->getSecondFrequency() ); break;}
		}
		return totalCounts;
	}

	/*_____________________________________________________________*/



	double G2TreeMeasure::getTotalCounts ( GeneticUnitVector * g, GeneticUnitCountsVector* hapCountsVector, intSet* hapPos )
	{
		double totalCounts=0;
		HaplotypeCounts* h=NULL;
		Haplotype *hap=NULL;
		for ( GeneticUnitCountsVector::iterator it=hapCountsVector->begin(); it!=hapCountsVector->end();it++ )
		{
			h= (HaplotypeCounts*)hapCountsVector->getElement ( it );
			hap=h->getHaplotype();
			for ( intSet::iterator it=hapPos->begin(); it!=hapPos->end(); it++ )
				if ( *g->getElement ( *it ) ==*hap ) {totalCounts=totalCounts+h->getFirstFrequency() +h->getSecondFrequency(); break;}
		}
		return totalCounts;
	}

	/*_____________________________________________________________*/



	double G2TreeMeasure::getReliability ( GeneticUnitVector * g, GeneticUnitCountsVector* hapCountsVector, intSet* hapPos, doubleList* posteriors )
	{
		double reliability=0, totalDifferentHaps=0;
		GeneticUnitCounts* h=NULL;
		GeneticUnit *hap=NULL;
		for ( GeneticUnitCountsVector::iterator it=hapCountsVector->begin(); it!=hapCountsVector->end();it++ )
		{
			h= hapCountsVector->getElement ( it );
			hap=h->getGeneticElement();
			for ( intSet::iterator it=hapPos->begin(); it!=hapPos->end(); it++ )
				if ( *g->getElement ( *it ) ==*hap ) {totalDifferentHaps++; reliability=reliability+posteriors->getElement ( *it ) * ( h->getFirstFrequency() +h->getSecondFrequency() ); break;}
		}
		if ( totalDifferentHaps==0 ) throw DivisionByZero ( "G2TreeMeasure<T>::getReliability (	HaplotypeVector * g, SampleGeneticCounts<T>* aTUCounts, intSet* hapPos, doubleList* posteriors )" );
		return reliability/totalDifferentHaps;
	}


	/*_____________________________________________________________*/
	/*
		template<class T>		TDTtable<T>* G2TreeMeasure<T>::set ( SampleGeneticCounts<T>* aTUCounts )
		{
	// It creates and return a new TDTtable with only two columns, one for each group in 2GTree algorithm

			try
			{
				int position=0;
				if ( this->lengthDistance ) position=-1;
				Haplotype* hap=NULL;
				TDTtable<T>* result=NULL;
				if ( aTUCounts==NULL ) return NULL;
				double sumT1=0, sumT2=0, sumU1=0, sumU2=0, distanceG1, distanceG2, reliability=0;
				intSet* minPosT, *minPosU;
				FreqAndKeyVector* fk=new FreqAndKeyVector();
				FreqAndKey* element;
				int pos=0;
				doubleList* posteriors1=new doubleList(), *posteriors2=new doubleList();
				HaplotypeCounts* h;
	// it first create a vector fk with the haploypes in the data set ordered by frequencies
				for ( typename T::iterator it=aTUCounts->haplotypeCountsVector->begin(); it!=aTUCounts->haplotypeCountsVector->end();it++ )
				{
					h= aTUCounts->haplotypeCountsVector->getElement ( it );
					if ( h->getFirstFrequency() +h->getSecondFrequency() > 0 )
					{
						element=new FreqAndKey ( std::pow ( h->getFirstFrequency()-h->getSecondFrequency(),2 ) / ( double ) ( h->getFirstFrequency() +h->getSecondFrequency() ), pos );
		//element=new FreqAndKey ((  double ) ( h->getFirstFrequency() +h->getSecondFrequency() ), pos );
	//element=new FreqAndKey ( std::pow ( h->getFirstFrequency()-h->getSecondFrequency(),2 ), pos );
						fk->insertElement ( element );
					}
					pos++;
				}
	//cout << "end pos \n"; //is:" << (void*)fk->getLast();
				fk->sort ( false );

				// now it creates p, a vector with the high and low risk haplotypes (g1 and g2 respectively).

				TDTtable<T>*  basicTable=new TDTtable<T> ( (aTUCounts->getHaplotypeCountsVector() ), NULL, 0, this->minFreq );
		//		double totalFirst=basicTable->getTotalFirstRow(), totalSecond=basicTable->getTotalSecondRow();
				zap ( basicTable );

				Container<vector<T*>, T*> * p=new Container<vector<T*>, T*>();
				p->insertElement ( new T() );
				p->insertElement ( new T() );
				HaplotypeVector * g1=new HaplotypeVector(), *g2=new HaplotypeVector();
				double tFreq, uFreq, totalHaps1, totalHaps2, prior, posterior;
				for ( int i=0; i<fk->size(); i++ )
				{
					h=aTUCounts->haplotypeCountsVector->getElement ( fk->getElement ( i )->second() );
					if ( h!=NULL && !h->getHaplotype()->hasAMissingPosition() )
					{
						hap=h->getHaplotype()->clone();
	  					if ( g1->size() >0 && g2->size() >0 ) // in case there are at least one haplotype in each group already
						{
							minPosT=g1->getPositionsWithMinDistance ( hap,  position, false );
							distanceG1=hap->getDistance ( g1->getElement ( minPosT->getElement ( 0 ) ), position, false );
							minPosU=g2->getPositionsWithMinDistance ( hap, position, false );
							distanceG2=hap->getDistance ( g2->getElement ( minPosU->getElement ( 0 ) ), position, false );
							if ( distanceG1<distanceG2 ) prior=s*(3/4); // by default s=2 so alpha=2*reliability and then Beta(1.5*reliability,0.5*reliability))
							if ( distanceG1>distanceG2 ) prior=s*(1/4); // by default s=2 and then Beta(0.5*reliability,1.5*reliability)
							if ( distanceG1==distanceG2 )
							{
								totalHaps1=getTotalCounts ( g1, aTUCounts, minPosT);
								totalHaps2=getTotalCounts ( g2, aTUCounts, minPosU);
	 						prior=s*(1/4+(totalHaps1 / ( double ) ( totalHaps1 + totalHaps2 ))/2);//prior beta is Beta(0.5+p1,0.5+p2), being p1 and p2 the relative frequencies of haplotypes in g1 and g2 with the shortest distance to the current haplotype

				}
	 reliability=s*getWeightedTotalCounts ( g1, aTUCounts, minPosT, posteriors1);
	if (totalHaps2>totalHaps1)  reliability=getWeightedTotalCounts ( g2, aTUCounts, minPosU, posteriors2);
							zap ( minPosT );
							zap ( minPosU );
						}
	     else //  if ( g1->size() ==0 || g2->size()==0 )
	{
	     reliability=1; // it does not affect final output
	     prior=s/2; // Beta (s/2,s/2), by default is s=2 so Beta(1,1), a uniform distribution on [0,1]
	}
						tFreq=h->getFirstFrequency() +prior*reliability;
						uFreq=h->getSecondFrequency() +(s-prior)*reliability;
						posterior=(tFreq/(tFreq+uFreq));
						if ( ( ( h->getFirstFrequency() +h->getSecondFrequency() ) ) >=this->minFreq )
						{
							if ( tFreq > uFreq) { p->getElement ( 0 )->insertHardElement ( aTUCounts->haplotypeCountsVector->getElement ( fk->getElement ( i )->second() ) );g1->insertElement ( hap ); posteriors1->insertElement(posterior);}
							else
								if ( tFreq<uFreq) {p->getElement ( 1 )->insertHardElement ( aTUCounts->haplotypeCountsVector->getElement ( fk->getElement ( i )->second() ) );g2->insertElement ( hap ); posteriors2->insertElement(reliability-posterior); }
								else zap ( hap ); //p->getElement ( rand() %2 )->insertHardElement ( h );
						}
						else zap ( hap );
					}
				}
				zap ( fk );
				zap ( g1 );
				zap ( g2 );
	  zap(posteriors1);
		zap(posteriors2);
				if ( p->getElement ( 0 )->size() >0 && p->getElement ( 1 )->size() >0 )
					result=new TDTtable<T> (p );
				zap ( p );
				return result;
			}
			catch ( BasicException& be ) {be.addMessage ( "\ncalled from G2TreeMeasure::set()" ); throw;};
		}

		/*_____________________________________________________________*/

	GeneticUnitCountsSample* G2TreeMeasure::getPartition ( GeneticUnitCountsVector* hapCountsVector, double totalFirst, double totalSecond )
	{
GeneticUnitCountsSample * p=new GeneticUnitCountsSample();
			p->insertElement ( new GeneticUnitCountsVector() );
			p->insertElement ( new GeneticUnitCountsVector() );

		//			doubleList* posteriors1=new doubleList(), *posteriors2=new doubleList();
		GeneticUnitCounts* h;
		intSet* minPosG1, *minPosG2;
		FreqAndKeyVector* fk=getOrderedHaplotypes ( hapCountsVector );
		double frequencyFirst, frequencySecond, estimationFirst, estimationSecond, priorFirst, priorSecond, posterior;
		GeneticUnit* hap=NULL;
		GeneticUnitVector * g1=new GeneticUnitVector(), *g2=new GeneticUnitVector();
		doubleList* posteriors1=new doubleList(), *posteriors2=new doubleList();
		double tFreq, uFreq, totalHaps1, totalHaps2, prior, reliability, r, n1, n2, distanceG1, distanceG2, si=s, wi=0;
		for ( int i=0; i<fk->size(); i++ )
		{
			h=hapCountsVector->getElement ( fk->getElement ( i )->second() );

			hap=h->getGeneticElement()->clone();


			frequencyFirst=h->getFirstFrequency();
			frequencySecond=h->getSecondFrequency();
			priorFirst=si/2;
			if ( g1->size() >0 && g2->size() >0 )
			{
				minPosG1=g1->getPositionsWithMinDistance ( hap );
				minPosG2=g2->getPositionsWithMinDistance ( hap );

				distanceG1=hap->getDistance ( g1->getElement ( minPosG1->getElement ( 0 ) ) );
				distanceG2=hap->getDistance ( g2->getElement ( minPosG2->getElement ( 0 ) ) );
				n1=0; n2=0;
				if ( distanceG1<=distanceG2 ) { n1=getTotalCounts ( g1, hapCountsVector, minPosG1 ); wi=getReliability ( g1, hapCountsVector, minPosG1, posteriors1 );}
				if ( distanceG1>=distanceG2 ) { n2=getTotalCounts ( g2, hapCountsVector, minPosG2 ); wi=wi+getReliability ( g2, hapCountsVector, minPosG2, posteriors2 );}
				r=n1/ ( n1+n2 );
			//	si=s*wi;
				priorFirst=si* ( 1/4+r/2 );
				zap(minPosG1);
				zap(minPosG2);			
			}
			priorSecond=si-priorFirst;
//     priorFirst=getPriorFirst()*getReliability();
//    priorSecond=getPriorSecond()*getReliability();
			estimationFirst= ( frequencyFirst+priorFirst ) / ( si+totalFirst );
			estimationSecond= ( frequencySecond+priorSecond ) / ( si+totalSecond );
			posterior=estimationFirst/ ( estimationFirst+estimationSecond );

			if ( estimationFirst > estimationSecond )
			{
				p->getElement ( 0 )->insertHardElement ( hapCountsVector->getElement ( fk->getElement ( i )->second() ) ); g1->insertElement ( hap ); posteriors1->insertElement ( posterior );
			}
			else
				if ( estimationFirst<estimationSecond )
				{
					p->getElement ( 1 )->insertHardElement ( hapCountsVector->getElement ( fk->getElement ( i )->second() ) ); g2->insertElement ( hap ); posteriors2->insertElement ( 1-posterior );
				}
				else zap ( hap ); //p->getElement ( rand() %2 )->insertHardElement ( h );
		}
		zap ( fk );
		zap ( g1 );
		zap ( g2 );
		zap ( posteriors1 );
		zap ( posteriors2 );
return p;
	}
	/*_____________________________________________________________*/
	/*
		template <class T> 	double G2Measure<T>::getReliability ( Container<vector<T*>, T*> * p, T* hapCountsVector, double totalFirst, double totalSecond )
		{
	}
			/*_____________________________________________________________*/
	/*
		template <class T> 	double G2Measure<T>::getPrior ( Container<vector<T*>, T*> * p, T* hapCountsVector, double totalFirst, double totalSecond )
		{

		  	/*				if ( g1->size() >0 && g2->size() >0 ) // in case there are at least one haplotype in each group already
							{
								minPosT=g1->getPositionsWithMinDistance ( hap,  position, false );
								distanceG1=hap->getDistance ( g1->getElement ( minPosT->getElement ( 0 ) ), position, false );
								minPosU=g2->getPositionsWithMinDistance ( hap, position, false );
								distanceG2=hap->getDistance ( g2->getElement ( minPosU->getElement ( 0 ) ), position, false );
								if ( distanceG1<distanceG2 ) prior=s*(3/4); // by default s=2 so alpha=2*reliability and then Beta(1.5*reliability,0.5*reliability))
								if ( distanceG1>distanceG2 ) prior=s*(1/4); // by default s=2 and then Beta(0.5*reliability,1.5*reliability)
								if ( distanceG1==distanceG2 )
								{
									totalHaps1=getTotalCounts ( g1, aTUCounts, minPosT);
									totalHaps2=getTotalCounts ( g2, aTUCounts, minPosU);
		 						prior=s*(1/4+(totalHaps1 / ( double ) ( totalHaps1 + totalHaps2 ))/2);//prior beta is Beta(0.5+p1,0.5+p2), being p1 and p2 the relative frequencies of haplotypes in g1 and g2 with the shortest distance to the current haplotype

					}
		 reliability=s*getWeightedTotalCounts ( g1, aTUCounts, minPosT, posteriors1);
		if (totalHaps2>totalHaps1)  reliability=getWeightedTotalCounts ( g2, aTUCounts, minPosU, posteriors2);
								zap ( minPosT );
								zap ( minPosU );
							}
		     else //  if ( g1->size() ==0 || g2->size()==0 )
		{
		     reliability=1; // it does not affect final output
		     prior=s/2; // Beta (s/2,s/2), by default is s=2 so Beta(1,1), a uniform distribution on [0,1]
		}
	}*/
//}
	/*_____________________________________________________________*/

	FreqAndKeyVector* G2TreeMeasure::getOrderedHaplotypes ( GeneticUnitCountsVector* hapCountsVector )
	{
		// it  creates a vector fk with the haploypes in the data set ordered by frequencies
		FreqAndKeyVector* fk=new FreqAndKeyVector();
		FreqAndKey* element;
		int pos=0;
		doubleList* posteriors1=new doubleList(), *posteriors2=new doubleList();
		GeneticUnitCounts* h;
		for ( GeneticUnitCountsVector::iterator it=hapCountsVector->begin(); it!=hapCountsVector->end();it++ )
		{
			h= hapCountsVector->getElement ( it );
			if ( h !=NULL ) // !h->getHaplotype()->hasAMissingPosition() )
				if ( ( ( h->getFirstFrequency() + h->getSecondFrequency() ) ) >=this->minFreq )
					if ( h->getFirstFrequency() +h->getSecondFrequency() > 0 )
					{
						element=new FreqAndKey ( std::pow ( h->getFirstFrequency()-h->getSecondFrequency(),2 ) / ( double ) ( h->getFirstFrequency() +h->getSecondFrequency() ), pos );
//		element=new FreqAndKey ((  double ) ( h->getFirstFrequency() +h->getSecondFrequency() ), pos );
						//element=new FreqAndKey ( std::pow ( h->getFirstFrequency()-h->getSecondFrequency(),2 ), pos );
						fk->insertElement ( element );
					}
			pos++;
		}
		//cout << "end pos \n"; //is:" << (void*)fk->getLast();
		fk->sort ( false );
		return fk;
	}
	/*_____________________________________________________________*/
	/*
		template <class T> 	double G2TreeMeasure<T>::getPriorFirst ( double counts, double totalCounts,  Container<vector<T*>, T*> * p)
		{
	return counts/totalCounts;
			}



		/*_____________________________________________________________*/

	G2TreeMeasure::G2TreeMeasure ( double s, double minFreq, int testMode, bool useDistances, bool lengthDistance ) :G2Measure ( minFreq, testMode, useDistances, lengthDistance )
	{
		this->s=s;
	}


	/*_____________________________________________________________*/

	G2TreeMeasure::G2TreeMeasure ( G2TreeMeasure& other ) :G2Measure ( other )
	{
		s=other.s;
	}


	/*_________________________________________________________________*/

	G2TreeMeasure* G2TreeMeasure::getNewMeasure ( SampleGenericCounts* tuCounts, SampleGenericCounts** training, SampleGenericCounts** test )
	{
		try
		{
			return new G2TreeMeasure ( ( SampleGeneticCounts* ) tuCounts, this->s, this->minFreq, this->testMode, ( SampleGeneticCounts** ) training, ( SampleGeneticCounts** ) test, this->useDistances, this->lengthDistance );
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from G2TreeMeasure* G2TreeMeasure::getNewMeasure(TUCounts* tuCounts, SampleTUCounts** training, SampleTUCounts** test)" ); throw;};
	}

	/*_________________________________________________________________*/
	/*
	  G2TreeMeasure* G2TreeMeasure::inferMeasure(TUCounts* tuCounts)
	{
	return new G2TreeMeasure(tuCounts, minFreq);
	}
	/*____________________________________________________________________________*/


	G2TreeMeasure::~G2TreeMeasure()
	{
	};

	/*____________________________________________________________________________*/


	G2TreeMeasure*	G2TreeMeasure::clone()
	{
		return new G2TreeMeasure ( *this );
	};

	/*____________________________________________________________________________*/

	string G2TreeMeasure::getName()
	{
		string result=string ( "mTDT2GTree" );
		if ( this->testMode==0 ) result=result+string ( "_noCorrection" );
		if ( this->testMode==-1 ) result=result+string ( "_Bonferroni" );
		if ( this->testMode>=2 ) result=result+string ( "_cv" ) +tos ( this->testMode );
		if ( this->testMode==1 ) result=result+string ( "_holdout" );
		if ( this->useDistances )
			if ( this->lengthDistance ) result=result+string ( "_useLengthDistances" );
			else result=result+string ( "_useBiosDistances" );
		if ( this->s!=2 ) result=result+string ( "_precision" ) +tos ( this->s );
		if ( this->minFreq!=0 ) result=result+string ( "_minFreq" ) +tos ( this->minFreq );
//if (permutations) result=result+string("_")+tos(tuCounts->getTotalPermutations())+string("permutations");
		return result;
	}
	/*_________________________________________________________________*/
	/*
		stringList*  G2TreeMeasure::getHeadFile()
		{
			stringList *result=new stringList();
			result->insertElement ( string ( "FirstSNP" ) );
			result->insertElement ( string ( "pVal " ) );
			result->insertElement ( string ( "TotalUsedDifferentHaplotypesInG1 // " ) );
			result->insertElement ( string ( "T/U G1 // " ) );
			result->insertElement ( string ( "TotalUsedDifferenteHaplotypesInG2 //" ) );
			result->insertElement ( string ( "T/U G2" ) );
			return result;
		};

		/*_____________________________________________________________*/

	/*
		double G2TreeMeasure::getOR()
		{
			try
			{
				double result=0;
				if ( partialTdtTables==NULL  || partialTdtTables->size() ==0 ) return tdtTable->getValue ( 0,0 ) / ( double ) tdtTable->getValue ( 1,0 );
				for ( TDTtableVector::iterator it=partialTdtTables->begin(); it<partialTdtTables->end(); it++ )
				{
					if ( partialTdtTables->getElement ( it ) !=NULL )
						result=result+partialTdtTables->getElement ( it )->getValue ( 0,0 ) / ( double ) partialTdtTables->getElement ( it )->getValue ( 1,0 );
				}
				return result;
			}
			catch ( BasicException& be ) {be.addMessage ( "\ncalled from GroupBasedTDTMeasure::getPVal()" ); throw;};

		}


		/*____________________________________________________________________________________________*/
	/*
		bool G2TreeMeasure::getOneSide()
		{
			return false;
		}
		/*_____________________________________________________________________________________________________________*/

	/*
		void G2TreeMeasure::onePrint ( ostream& out, SampleTUCounts* aTuCounts, TDTtable* aTDTtable )
		{
			if ( aTuCounts==NULL || aTuCounts->getParentalGenotypes() ==NULL )
				out << "no counts";
			else
			{
				out << aTuCounts->getParentalGenotypes()->getPositions() [aTuCounts->getPositions() [0]] <<"\t";
				if ( aTDTtable!=NULL )
				{
					for ( int i=1; i<3; i++ )
					{
						aTDTtable->partition->getElement ( i-1 )->setDelimiters ( '\0', '\0' );
	//if (i==2) out <<"\n";
						out << getPVal() << "\t";
						out << "G" << i <<":\t" << *aTDTtable->partition->getElement ( i-1 );
						out <<"\tT:\t" << aTDTtable->getValue ( 0,i-1 ) << "\tU: \t" << aTDTtable->getValue ( 1,i-1 );
						if ( i==1 ) out <<"\t";
						aTDTtable->partition->getElement ( i-1 )->setDelimiters ( '[', ']' );
					}
				}
				else out <<"nullTable";
			}
		};
	*/
}
#endif
